/***************************************************************************
                       kmfdocoptions.cpp  -  description
                          -------------------
 begin                : Wed Aug 21 2002
 copyright            : (C) 2002 by animal
 email                : animal@shit.orphi.iki
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kmfdocoptions.h"

// project includes
#include "core/kmfdoc.h"

// qt includes
#include <qcheckbox.h>

// kde includes
#include <kdebug.h>
#include <kapplication.h>

KMFDocOptions::KMFDocOptions( QWidget *parent, const char *name ) : KMyFirewallDocOptions( parent, name ) {}

KMFDocOptions::~KMFDocOptions() {}

void KMFDocOptions::loadDoc( KMFDoc* doc ) {
	kdDebug() << "void KMFDocOptions::loadDoc(KMFDoc* doc)" << endl;
	kmfdoc = doc;
	c_use_filter->setChecked( kmfdoc->useFilter() );
	c_use_nat->setChecked( kmfdoc->useNat() );
	c_use_mangle->setChecked( kmfdoc->useMangle() );
	c_use_ipfwd->setChecked( kmfdoc->useIPFwd() );
	c_use_rp_filter->setChecked( kmfdoc->useRPFilter() );
	c_use_martians->setChecked( kmfdoc->useMartians() );
	c_use_syn_cookies->setChecked( kmfdoc->useSynCookies() );
	c_use_modules->setChecked( kmfdoc->useModules() );
}
void KMFDocOptions::accept() {
	kmfdoc->setUseFilter( c_use_filter->isChecked() );
	kmfdoc->setUseNat( c_use_nat->isChecked() );
	kmfdoc->setUseMangle( c_use_mangle->isChecked() );
	kmfdoc->setUseIPFwd( c_use_ipfwd->isChecked() );
	if ( c_use_rp_filter->isChecked() ) {
		kmfdoc->setUseRPFilter( true );
		kmfdoc->setUseMartians( c_use_martians->isChecked() );
	} else {
		kmfdoc->setUseRPFilter( false );
		kmfdoc->setUseMartians( false );
	}
	kmfdoc->setUseSynCookies( c_use_syn_cookies->isChecked() );
	kmfdoc->setUseModules( c_use_modules->isChecked() );
	kmfdoc->changed();
	emit sigDocumentChanged( kmfdoc );
	QDialog::accept();
}

void KMFDocOptions::slotHelp() {
	kdDebug() << "void KMFDocOptions::slotHelp() {" << endl;
	kapp->invokeHelp();
}


#include "kmfdocoptions.moc"
