/***************************************************************************
                       kmfruleeditorinterface.cpp  -  description
                          -------------------
 begin                : Tue Mar 5 2002
 copyright            : (C) 2002 by Christian Hubinger
 email                : a9806056@unet.univie.ac.at
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/ 
//MY includes
#include "kmfruleeditorinterface.h"

// QT includes
#include <qstring.h>
#include <qcheckbox.h>
#include <qmessagebox.h>
#include <qcombobox.h>
#include <qgroupbox.h> 
// KDE includes
#include <kcombobox.h>
#include <kurl.h>
#include <kstandarddirs.h>
#include <kconfig.h>
#include <kapplication.h>
#include <kdebug.h> 
// STD includes
#include <iostream> 
// project include
#include "../core/iptchain.h"

KMFRuleEditorInterface::KMFRuleEditorInterface( QWidget *parent, const char *name, WFlags fl /*,IPTRule* cr */ ) : KMyFirewallRuleEditorInterface( parent, name, fl ) {
	slotReadConfig();
}
KMFRuleEditorInterface::~KMFRuleEditorInterface() {}

void KMFRuleEditorInterface::loadRule( IPTRule * rule ) {
	slotReadConfig();
	kdDebug() << "void  KMFRuleEditorInterface::loadRule( IPTRule * rule )" << endl;
	c_in_int->setChecked( false );
	c_inv_in_int->setChecked( false );
	cb_in_int->setCurrentItem( 0 );
	c_out_int->setChecked( false );
	c_inv_out_int->setChecked( false );
	cb_out_int->setCurrentItem( 0 );

	curr_rule = rule;
	QPtrList<QPtrList<QString> > opt_list = curr_rule->ruleOptions();
	for ( uint j = 0;j < opt_list.count();j++ ) {
		options = new QPtrList<QString>;
		options = opt_list.at( j );
		if ( options->count() > 1 ) {
			QString * opt = options->at( 0 );
			QString* cmd = options->at( 1 );
			if ( *opt == "in_int" ) {
				c_in_int->setChecked( true );
				if ( cmd->startsWith( "! " ) ) {
					c_inv_in_int->setChecked( true );
					cb_in_int->setEditText( cmd->right( cmd->length() - 2 ) );
				} else {
					cb_in_int->setEditText( *cmd );
				}
			} else if ( *opt == "out_int" ) {
				c_out_int->setChecked( true );
				if ( cmd->startsWith( "! " ) ) {
					c_inv_out_int->setChecked( true );
					cb_out_int->setEditText( cmd->right( cmd->length() - 2 ) );
				} else {
					cb_out_int->setEditText( *cmd );
				}
			}
		}
	}
	QString chain = curr_rule->chain() ->name();
	if ( chain == "INPUT" ) {
		gb_in_int->setEnabled( true );
		gb_out_int->setEnabled( false );
	} else if ( chain == "OUTPUT" ) {
		gb_in_int->setEnabled( false );
		gb_out_int->setEnabled( true );
	}
}

/** No descriptions */
void KMFRuleEditorInterface::slotOk() {
	//  KMyFirewallRuleEditor* ed = (KMyFirewallRuleEditor*)parentWidget();
	if ( !c_in_int->isChecked() ) {
		QString * del = new QString( "in_int" );
		//     curr_rule->delRuleOption(*del);
		emit sigDelRuleOpt( del );
	}
	if ( !c_out_int->isChecked() ) {
		QString * del = new QString( "out_int" );
		//     curr_rule->delRuleOption(*del);
		emit sigDelRuleOpt( del );
	}

	QString in = cb_in_int->currentText();
	if ( c_in_int->isChecked() && !in.isEmpty() ) {
		QString * name = new QString( "in_int" );
		bool inv = c_inv_in_int->isChecked();
		if ( inv ) {
			in.prepend( "! " );
		}
		QString* opt = new QString( in );
		QPtrList<QString>* options = new QPtrList<QString>;
		options->append( opt );
		emit sigAddRuleOpt( name, options );
	}

	QString out = cb_out_int->currentText();
	if ( c_out_int->isChecked() && !out.isEmpty() ) {
		QString * name = new QString( "out_int" );
		bool inv = c_inv_out_int->isChecked();
		if ( inv ) {
			out.prepend( "! " );
		}
		QString* opt = new QString( out );
		QPtrList<QString>* options = new QPtrList<QString>;
		options->append( opt );
		emit sigAddRuleOpt( name, options );
	}
	emit sigDocumentChanged();
	// accept();
}
/** No descriptions */
void KMFRuleEditorInterface::slotCheckConfig() {}
/** No descriptions */
void KMFRuleEditorInterface::slotReadConfig() {
	cb_in_int->clear();
	cb_out_int->clear();
	KConfig* _config = kapp->config();
	_config->setGroup( "INTERFACES" );
	QStringList interf = _config->readListEntry( "interface" );
	if ( !interf.isEmpty() ) {
		for ( uint i = 0; i < interf.count(); i++ ) {
			QString interface = *interf.at( i );
			cb_in_int->insertItem( interface );
			cb_out_int->insertItem( interface );
		}
	}
}

void KMFRuleEditorInterface::slotHelp() {
	kdDebug() << "void KMFRuleEditorInterface::slotHelp()" << endl;
	kapp->invokeHelp( "interfaces" );
}
void KMFRuleEditorInterface::reject() {
	kdDebug() << "void KMFRuleEditorInterface::reject()" << endl;
	emit sigHideMe();
}
#include "kmfruleeditorinterface.moc"
