/***************************************************************************
                       kmferrorhandler.cpp  -  description
                          -------------------
 begin                : Tue Aug 6 2002
 copyright            : (C) 2002 by Christian Hubinger
 email                : a9806056@unet.univie.ac.at
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kmferrorhandler.h"

// QT includes
#include <kmessagebox.h>
#include <qstring.h>

// KDE includes
#include <kdebug.h>
#include <klocale.h> 
// my includes
#include "kmferror.h"

KMFErrorHandler::KMFErrorHandler( const QString& name ) {
	m_caller_name = new QString( name );
}
KMFErrorHandler::~KMFErrorHandler() {}

bool KMFErrorHandler::showError( KMFError* err ) {
	//  kdDebug() << "KMFErrorHandler::showError(KMFError* err)" << endl;
	int err_num = err->errNum();
	QString header = "";
	if ( err_num == 0 && err->errType() != "HINT")
		return true;

	if ( err_num == 0 && err->errType() == "HINT" ) {
		header += i18n( " - Hint" );
		const QString err_msg = err->errMsg();
		kdDebug() << "Error Msg: " + err_msg << endl;
		KMessageBox::error( 0, err_msg, header );
		return true;
	}

	if ( err_num > 0 ) {
		header += i18n( "Error (Class: %1)" ).arg( *m_caller_name );
		const QString err_msg = err->errMsg();
		kdDebug() << "Error Msg: " + err_msg << endl;
		KMessageBox::error( 0, err_msg, header );
		return false;
	}
	return false;
}
