/***************************************************************************
                      iptable.cpp  -  description
                         -------------------
begin                : Tue Aug 20 2002
copyright            : (C) 2002 by animal
email                : animal@shit.orphi.iki
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "iptable.h"

// qt includes
#include <qstring.h>
#include <qregexp.h>

// kde includes
#include <kdebug.h>
#include <klocale.h>

// project includes
#include "kmfcheckinput.h"
#include "iptchain.h"
#include "kmferror.h"
#include "kmfdoc.h"
#include "kmferrorhandler.h"

IPTable::IPTable( KMFDoc* doc, const QString& name ) {
	//  kdDebug() << "IPTable::IPTable(QString& name)" << endl;
	kmfdoc = doc;
	m_err = new KMFError();
	m_err_handler = new KMFErrorHandler( "IPTable" );
	m_chains.setAutoDelete( true );
	m_name = "UNDEFINED";
	setName( name );
	settupDefaultChains();
}

IPTable::~IPTable() {
	kdDebug() << "\n\nIPTable::~IPTable()" << endl;
	m_chains.clear();
}

void IPTable::resetTable() {
	kdDebug() << "void IPTable::resetTable()" << endl;
	m_chains.clear();
	settupDefaultChains();
	m_used = true;
}

void IPTable::settupDefaultChains() {
	//	kdDebug() << "void IPTable::settupDefaultChains()" << endl;
	QString target = "ACCEPT";
	if ( m_name == "filter" ) {
		IPTChain * filter_inp = new IPTChain( "INPUT", this, true );
		filter_inp->setDefaultTarget( target );
		filter_inp->setUsed( true );
		m_err = addChain( *filter_inp );

		IPTChain* filter_out = new IPTChain( "OUTPUT", this, true );
		filter_out->setDefaultTarget( target );
		filter_out->setUsed( true );
		m_err = addChain( *filter_out );

		IPTChain* filter_fwd = new IPTChain( "FORWARD", this, true );
		filter_fwd->setDefaultTarget( target );
		filter_fwd->setUsed( true );
		m_err = addChain( *filter_fwd );

	} else if ( m_name == "nat" ) {
		IPTChain * nat_out = new IPTChain( "OUTPUT", this, true );
		nat_out->setDefaultTarget( target );
		nat_out->setUsed( true );
		m_err = addChain( *nat_out );

		IPTChain* nat_pre = new IPTChain( "PREROUTING", this, true );
		nat_pre->setDefaultTarget( target );
		nat_pre->setUsed( true );
		m_err = addChain( *nat_pre );

		IPTChain* nat_post = new IPTChain( "POSTROUTING", this, true );
		nat_post->setDefaultTarget( target );
		nat_post->setUsed( true );
		m_err = addChain( *nat_post );
	} else if ( m_name == "mangle" ) {
		IPTChain * mangle_inp = new IPTChain( "INPUT", this, true );
		mangle_inp->setDefaultTarget( target );
		mangle_inp->setUsed( true );
		m_err = addChain( *mangle_inp );

		IPTChain* mangle_out = new IPTChain( "OUTPUT", this, true );
		mangle_out->setDefaultTarget( target );
		mangle_out->setUsed( true );
		m_err = addChain( *mangle_out );

		IPTChain* mangle_fwd = new IPTChain( "FORWARD", this, true );
		mangle_fwd->setDefaultTarget( target );
		mangle_fwd->setUsed( true );
		m_err = addChain( *mangle_fwd );

		IPTChain* mangle_pre = new IPTChain( "PREROUTING", this, true );
		mangle_pre->setDefaultTarget( target );
		mangle_pre->setUsed( true );
		m_err = addChain( *mangle_pre );

		IPTChain* mangle_post = new IPTChain( "POSTROUTING", this, true );
		mangle_post->setDefaultTarget( target );
		mangle_post->setUsed( true );
		m_err = addChain( *mangle_post );
	}
}



void IPTable::setName( const QString& name ) {
	kdDebug() << "void IPTable::setName(QString& name) " << endl;
	m_name = name;
}

IPTChain* IPTable::chainForName( QString& name ) {
	IPTChain * tmp_chain;
	for ( tmp_chain = m_chains.first();tmp_chain; tmp_chain = m_chains.next() ) {
		if ( tmp_chain->name() == name )
			return tmp_chain;
	}
	return 0;
}

QPtrList<IPTChain>& IPTable::chains() const {
	QPtrList<IPTChain>* ret_val = new QPtrList<IPTChain>;
	*ret_val = m_chains;
	return *ret_val;
}
/**  Add a IPTChain object to this table
*/

KMFError* IPTable::addChain( QString& chain_name, QString& chain_target, bool builtin ) {
	kdDebug() << "KMFError* IPTable::addChain( QString& chain_name,QString& chain_table,QString& chain_target,bool builtin )" << endl;
	KMFCheckInput* check = new KMFCheckInput();
	m_err = check->checkInput( chain_name, "CHAINNAME" );
	if ( m_err->errNum() == 0 ) {
		IPTChain * chain = new IPTChain( chain_name, this, builtin );
		if ( builtin && chain_target != QString::null )
			chain->setDefaultTarget( chain_target );
		m_err = addChain( *chain );
	}
	return m_err;
}

KMFError* IPTable::addChain( IPTChain &chain ) {
	//	kdDebug() << "KMFError* IPTable::addChain( IPTChain *chain )" << endl;
	KMFError * err = new KMFError();
	IPTChain* new_chain = new IPTChain( chain );
	QString tmp_name = new_chain->name();
	for ( uint i = 0; i < m_chains.count();i++ ) {
		QString curr_name = m_chains.at( i ) ->name();
		//    kdDebug() << "Found Chain: " << curr_name << " in table: " << m_name << endl;
		if ( curr_name == tmp_name ) {
			const QString msg = i18n( "Chain \"%1\" already exists. Chains must be unique in a table." ).arg( curr_name );
			err->setErrMsg( msg );
			err->setErrType( "NORMAL" );
			return err;
		}
	}
	m_chains.append( new_chain );
	const QString msg = "";
	err->setErrMsg( msg );
	err->setErrType( "OK" );
	return err;
}

/** Remove the given IPTChain
*/
KMFError* IPTable::delChain( IPTChain *chain ) {
	kdDebug() << "KMFError* IPTable::delChain( IPTChain *chain )" << endl;
	m_err = new KMFError();
	QString name = chain->name();
	if ( chain->isBuildIn() ) {
		const QString msg = i18n( "Cannot delete built-in chain: %1" ).arg( name );
		m_err->setErrMsg( msg );
		m_err->setErrType( "NORMAL" );
		return m_err;
	}
	int index = m_chains.find( chain );
	kdDebug() << "fount chain nr: " << index << endl;
	if ( index < 0 ) {
		const QString msg = i18n( "Cannot delete nonexistent chain" );
		m_err->setErrMsg( msg );
		m_err->setErrType( "NORMAL" );
		return m_err;
	} else {
		m_chains.remove( index );
		const QString msg = "";
		m_err->setErrMsg( msg );
		m_err->setErrType( "OK" );
		return m_err;
	}
}

KMFError* IPTable::moveRuleToChain( IPTRule* rule, IPTChain *target_chain ) {
	kdDebug() << "KMFError* IPTable::moveRuleToChain(IPTRule* rule, IPTChain *target_chain )" << endl;
	if ( rule == 0 ) {
		m_err->setErrType( "FATAL" );
		const QString& msg = "IPTable::moveRuleToChain(IPTRule* rule, IPTChain *target_chain rule == 0). This is a bug";
		m_err->setErrMsg( msg );
		return m_err;
	}
	if ( target_chain == 0 ) {
		m_err->setErrType( "FATAL" );
		const QString& msg = "IPTable::moveRuleToChain(IPTRule* rule, IPTChain *target_chain target_chain == 0). This is a bug.";
		m_err->setErrMsg( msg );
		return m_err;
	}
	kdDebug() << "Move Rule: " << rule->name() <<" from Chain: " <<  rule->chain() ->name() << "to chain" <<  target_chain->name()  << endl;

	IPTRule& new_rule = *rule->createRuleClone();
	m_err = target_chain->addRule( new_rule );
	if ( m_err->errNum() == 0 ) {
		IPTRule & ru = *rule;
		rule->chain() ->delRule( ru );
		kmfdoc->changed();
	}
	return m_err;
}

KMFError* IPTable::copyRuleToChain( IPTRule* rule, IPTChain *target_chain ) {
	kdDebug() << "KMFError* IPTable::copyRuleToChain(IPTRule* rule, IPTChain *target_chain )" << endl;
	if ( rule == 0 ) {
		m_err->setErrType( "FATAL" );
		const QString& msg = "IPTable::moveRuleToChain(IPTRule* rule, IPTChain *target_chain rule == 0). This is a bug ";
		m_err->setErrMsg( msg );
		return m_err;
	}
	if ( target_chain == 0 ) {
		m_err->setErrType( "FATAL" );
		const QString& msg = "IPTable::moveRuleToChain(IPTRule* rule, IPTChain *target_chain target_chain == 0). This is a bug ";
		m_err->setErrMsg( msg );
		return m_err;
	}
	kdDebug() << "Copy Rule: " << rule->name() << " from Chain: " <<  rule->chain() ->name() << "to chain" <<  target_chain->name()  << endl;

	IPTRule& new_rule = *rule->createRuleClone();
	m_err = target_chain->addRule( new_rule );
	if ( m_err->errNum() == 0 )
		kmfdoc->changed();
	return m_err;
}

