/* -*- c++ -*-
 *
 * addserver.cpp
 *
 * Copyright (C) 2003 Sebastian Sauer <dipesh@gmx.de>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#include "addserver.h"
#include "addserver.moc"

#include "kmldonkey.h"
#include "donkeyprotocol.h"
#include "network.h"

#include <qlayout.h>
#include <qlabel.h>
#include <qgroupbox.h>

#include <kglobal.h>
#include <kconfig.h>
#include <klocale.h>
#include <kdebug.h>
#include <kcombobox.h>
#include <klineedit.h>
#include <knuminput.h>

AddServerDialog::AddServerDialog(QWidget* parent, const char* name)
    : KDialogBase(Plain, i18n("Add Server"), Ok|Cancel, Cancel, parent, name)
{
    KConfig* conf = KGlobal::config();
    conf->setGroup("AddServerDialog");
    QString defnetwork = conf->readEntry("Network", "Donkey");
    QString defaddress = conf->readEntry("Address", "");
    int defport = conf->readNumEntry("Port", 4662);

    QVBoxLayout* l1 = new QVBoxLayout(plainPage());
    QGroupBox* box = new QGroupBox(plainPage());
    box->setColumnLayout(0, Qt::Vertical);
    box->layout()->setSpacing(6);
    box->layout()->setMargin(11);
    box->setTitle(i18n("Add Server"));
    QGridLayout* boxl = new QGridLayout(box->layout());
    boxl->setAlignment(Qt::AlignTop);

    QLabel* label = new QLabel(i18n("&Address:"), box);
    label->setSizePolicy(QSizePolicy::Fixed, QSizePolicy::Fixed);
    boxl->addWidget(label, 0, 0);

    m_addressEntry = new KLineEdit(box);
    label->setBuddy(m_addressEntry);
    boxl->addMultiCellWidget(m_addressEntry, 0, 0, 1, 3);

    label = new QLabel(i18n("&Port:"), box);
    label->setSizePolicy(QSizePolicy::Fixed, QSizePolicy::Fixed);
    boxl->addWidget(label, 1, 0);

    m_portEntry = new KIntNumInput(box);
    m_portEntry->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Fixed);
    m_portEntry->setMinValue(1);
    m_portEntry->setMaxValue(65535);
    label->setBuddy(m_portEntry);
    boxl->addWidget(m_portEntry, 1, 1);

    label = new QLabel(i18n("&Network:"), box);
    label->setSizePolicy(QSizePolicy::Fixed, QSizePolicy::Fixed);
    boxl->addWidget(label, 1, 2);

    m_networkEntry = new KComboBox(false, box);
    m_networkEntry->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Fixed);
    label->setBuddy(m_networkEntry);
    boxl->addWidget(m_networkEntry, 1, 3);

    QIntDictIterator<Network> it( KMLDonkey::App->donkey->availableNetworks() );
    for ( ; it.current(); ++it )
	if (it.current() && it.current()->networkEnabled() && it.current()->networkFlags() & Network::NetworkHasServers) {
	    m_networkEntry->insertItem( it.current()->networkName() );
	    if (it.current()->networkName() == defnetwork)
		m_networkEntry->setCurrentItem( m_networkEntry->count() - 1 );
	}

    l1->addWidget(box);

    setTabOrder(m_addressEntry, m_portEntry);
    setTabOrder(m_portEntry, m_networkEntry);

    m_addressEntry->setText(defaddress);
    m_addressEntry->selectAll();
    m_addressEntry->setFocus();
    connect(m_addressEntry, SIGNAL(textChanged(const QString &)), this, SLOT(addressEditChanged()));
    addressEditChanged();

    m_portEntry->setValue(defport);

    resize(QSize(486, 124).expandedTo(minimumSizeHint()));
    clearWState(WState_Polished);

    connect(this, SIGNAL(finished()), this, SLOT(closeDialog()));
    connect(this, SIGNAL(okClicked()), this, SLOT(addServer()));
}

void AddServerDialog::addressEditChanged()
{
    enableButton(KDialogBase::Ok, !m_addressEntry->text().isEmpty());
}

void AddServerDialog::addServer()
{
    int network = 0;
    if (m_networkEntry) {
        QIntDictIterator<Network> it( KMLDonkey::App->donkey->availableNetworks() );
        for ( ; it.current(); ++it )
            if (it.current() && it.current()->networkName() == m_networkEntry->currentText()) {
                network = it.current()->networkNo();
                break;
            }
    }
    QString address = m_addressEntry->text().stripWhiteSpace();
    int16 port = (int16)m_portEntry->value();

    KMLDonkey::App->donkey->addServer(network, address, port);
}

void AddServerDialog::closeDialog()
{
    KConfig* conf = KGlobal::config();
    conf->setGroup("AddServerDialog");
    if (m_networkEntry) conf->writeEntry("Network", m_networkEntry->currentText());
    conf->writeEntry("Address", m_addressEntry->text());
    conf->writeEntry("Port", m_portEntry->value());

    delayedDestruct();
}
