/***************************************************************************
                          systemnotifier.cpp  -  description
                             -------------------
    begin                : Tue Feb 20 2001
    copyright            : (C) 2001 by olaf lueg
    email                : olaf.lueg@t-online.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include "systemnotifier.h"
//qt
#include <qlabel.h>
#include <qframe.h>
#include <qtimer.h>

// kde
#include <kwinmodule.h>
#include <kstddirs.h>

SystemNotifier::SystemNotifier(int timer,QWidget *parent, const char *name ) : QWidget(parent,name,WStyle_Customize|WStyle_Tool|WStyle_StaysOnTop){
	Timer = timer;
	QFrame *frame = new QFrame(this);
	frame->setGeometry(0,0, width(), height());
	frame->setFrameStyle(QFrame::Box|QFrame::Plain);
	frame->setLineWidth(2);
	messageLabel = new QLabel(frame);
	messageLabel->show();
	messageLabel->setAlignment(AlignVCenter);
	
	KWinModule mod;
	y = mod.workArea().bottom() -100;
	x = mod.workArea().right() -100;
	setGeometry(x+100,y,100,100);
	move(x+100,y);
	frame->resize(width(),height());
	messageLabel->setGeometry(2,2,width()-4,height()-4);
	show_id = 0;
	
	aniTmr = new QTimer;
	aniTmr->stop();
	connect(aniTmr, SIGNAL(timeout()), this, SLOT(slotAniTimeout()));
	counter = 100;
}
SystemNotifier::~SystemNotifier(){
}

/** Display a message window in the upper right corner*/
/* Valid images :																*/
/* 0 = mail.png, 1 = user.png										*/

void SystemNotifier::showMessage(int image,QString message){
	KStandardDirs dir;
	QString dummy;
	switch(image){
		case 0:
		dummy = "<center><img src=\""+ dir.findResource("data","kmerlin/pics/mail.png")+"\"border=0>";
		break;

		case 1:
		dummy = "<center><img src=\""+ dir.findResource("data","kmerlin/pics/user.png")+"\"border=0>";
		break;
	}
	dummy += "<br>"+message+"</center>"	;
	message = dummy;
	messageLabel->setText(message);
	show();
	if(show_id == 0){
		show_id = startTimer(Timer * 1000);
	}
	else{
		killTimer(show_id);
		show_id = startTimer(Timer * 1000);
	}
	counter = 100;
	aniTmr->start(1);
}
void SystemNotifier::timerEvent(QTimerEvent*){
	hide();
	killTimer(show_id);
	show_id = 0;
}

void SystemNotifier::slotAniTimeout(){
	if(counter == 0){
		aniTmr->stop();
	}
	setGeometry(x+counter,y,100,100);
	counter--;
}

#include "systemnotifier.moc"
