/***************************************************************************
                          onlineview.h  -  description
                             -------------------
    begin                : Fri Jun 22 2001
    copyright            : (C) 2001 by olaf lueg
    email                : olaf.lueg@t-online.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef ONLINEVIEW_H
#define ONLINEVIEW_H

#include <qwidget.h>
#include <qpixmap.h>

class MyListView;
class KURLLabel;
class QLabel;
class QListViewItem;
class QPixmap;
class KMsnApp;

/**This is the new Online View
  *@author olaf lueg
  */

class OnlineView : public QWidget  {
   Q_OBJECT
public: 
	OnlineView(QWidget *parent=0, const char *name=0);
	~OnlineView();
	KMsnApp *theApp;
	QPixmap execPixmap;
public:	
	void setOnlineLabelText(const QString& text);
	void setMailLabelText(const QString& text);
	QString getHandle();
	QString getGroup();
	QString getParent();
	bool isEmpty();

protected:
	MyListView* ListView;
	KURLLabel*  mailLabel,*onlineLabel;
	QPixmap			Pixmap1,Pixmap2;
	QLabel *mailLabelPixmap,*onlineLabelPixmap;
	QPixmap offlinePixmap,onlinePixmap,invisiblePixmap,awayPixmap, blockedPixmap;
	/** Root pixmaps */
	QPixmap collapsedPixmap,expandedPixmap;
	/** Menus */
	QListViewItem *onlineItem,*offlineItem;

protected: //functions
	void loadIcons();

public slots: // Public slots
	/** No descriptions */
	void slotRightClick(QListViewItem*,const QPoint& point,int);
	void slotExpanded(QListViewItem *item);
	void slotCollapsed(QListViewItem *item);
	void slotDbClicked(QListViewItem* item);
	void slotSelectionChanged(QListViewItem*);
	void slotConnected(bool f);
	
	void slotUpdateGroup(QString oldGroup, QString newGroup);
	void slotInsertGroup( QString groupName );
	void slotRemoveGroup( QString groupName);
	
	void slotContactAdded(QString handle, QString publicName, QString groupName);
	void slotContactRemoved( QString handle, QString groupName );
	void slotUpdateContact(QString handle, uint status );
	/** Toggle display of mail indication */
	void slotHideEmail(bool);

	void processMailURL(const QString& url);
	void processOnlineURL(const QString&);
	/** No descriptions */

signals: // Signals
  /** No descriptions */
  void chatToUser(QString handle);
  void selectionChanged();
};

#endif
