/***************************************************************************
                          imservice.h  -  description
                             -------------------
    begin                : Sat Nov 10 2001
    copyright            : (C) 2001 by Olaf Lueg
    email                : olueg@olsd.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef IMSERVICE_H
#define IMSERVICE_H

#include <qobject.h>
#include <qlist.h>

/**
  *@author olaf
  */

	enum Status  {
			NLN,    // Online
			BSY,    // Busy
			BRB,    // Be right back
			AWY,  // Away from computer
			PHN,   // On the phone
			LUN,    // Out to lunch
			FLN,    // Offline
			HDN,   // Invisible
			IDL,     // Idle
			BLO     // blocked
	};
	enum List {
			FL,    // forward
			AL,   // allow
			BL,   // blocked
			RL    // reverse
	};
	
class IMGroups;
class IMContact;
class IMServiceSocket;
class IMChatService;

class IMService : public QObject
{
	Q_OBJECT
public: 
	IMService();
	~IMService();
	
public:
	void setMyContactInfo(QString handle, QString password) { _handle = handle; _password = password;}
	void setMyPublicName(QString publicName);
	
	void disconnect();
	void cancelConnect();
	
	void changeStatus( Status status );
	

	void groupRename( QString oldGroupName, QString newGroupName );
	void groupDelete( QString  groupName );
	void groupAdd(  );
	
	void contactAdd(QString handle );
	void contactRemove( QString handle, QString groupName);
	void contactDelete( QString handle );
	void contactCopy( QString handle, QString groupName );
	void contactMove( QString handle, QString oldGroupName, QString newGroupName );
	void contactBlock( QString handle );
	void contactUnBlock( QString handle );
	
	
	void setSilent(bool f){ _silent = f;}
	bool isSilent(){ return _silent;}
	
	int getStatus() { return _status;}
	int getStatus( QString handle );
	
	QStringList getBlockedContacts();
	QStringList getContacts( const QString &groupName);
	QStringList getGroups();
	QStringList getAvailableContacts();
	QString getGroupInfo(QString groupName);
	
	bool isBlocked( QString handle);
	bool isNewContact(QString handle );
	bool isAvailable(QString handle);
	
	QString getPublicName() { return _publicName;}
	QString getPublicName( const QString handle);
	
	int convertStatus( QString status );
	QString getHandle(){return _handle;}

protected:
	QString _handle;
	QString msgHandle;
	QString _publicName;
	QString _password;
	uint _serial;
	uint _status;
	bool _silent;
	bool connected;
	
	IMServiceSocket *serviceSocket;
	IMChatService *chatService;
	

	void setIdle(bool idle);
	QList<IMGroups>groupList;
	QList<IMContact>contactList;
	
	uint getGroupNumber( QString groupName );
	QString getGroupName( QString number );
	
	void readConfig();
	void cleanUp();
	
protected slots:
	void slotGroupRenamed( QString groupName, uint serial, uint group);
	void slotGroupAdded( QString groupName, uint serial, uint group);
	void slotGroupRemoved( uint serial, uint group);
	void slotGroupName(QString groupName, uint group);
	
	void slotContactAdded(QString handle, QString publicName, QString list, uint serial, uint group );
	void slotContactRemoved(QString handle, QString list, uint serial, uint group );
	
	void slotContactStatusChanged(QString handle, QString publicName, QString status);
	void slotContactStatus(QString handle, QString publicName, QString status);
	void slotContactList(QString handle, QString publicName, QString group, QString list );
	void slotConnected (bool f);
	
	void slotCreateChat(QString ID, QString address, QString auth, QString handle, QString publicName);
	void slotCreateChat( QString address, QString auth);
	void slotStatusChanged( QString );
	
	void slotNewMail( QString message, uint count );

	void slotPublicNameChanged(QString handle, QString publicName);
	void slotPublicNameReceived(QString publicName);
	
public slots:
	void slotStartChatSession(QString handle );
	void slotConnectToService();
	
signals:
//	void contactList(QStringList);
	void updateContact(QString , uint);
	
	void statusChanged(Status);
	void contactStatus(QString, QString, int);
	void contactStatusChanged(QString, QString, int);
	void publicNameChanged(QString);
	
//	void contactMoved(const QString&, const QString&, uint);
//	void contactCopied(const QString&, const QString&, uint);
	void contactRemoved( QString,  QString );
	void contactAdded( QString,  QString, QString);
	void contactBlocked(QString, bool );
	
	void connectingToService();
	void connectedToService(bool);
	
	void groupAdded( QString );
	void groupRemoved( QString );
	void groupRenamed( QString, QString );
	
	void startChat(IMChatService*,QString);
	
	void statusChanged( uint);
	void newContact( QString );
	
	void newMail(QString, uint);
	
	
	
	
};

#endif
