/***************************************************************************
                          imservice.cpp  -  description
                             -------------------
    begin                : Sat Nov 10 2001
    copyright            : (C) 2001 by Olaf Lueg
    email                : olueg@olsd.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

 

// other include
#include "imservice.h"
#include "imcontact.h"
#include "imgroups.h"
#include "imservicesocket.h"
#include "imchatservice.h"

// qt include
#include <qlabel.h>

// KDE
#include <klocale.h>
#include <kdebug.h>

IMService::IMService()
{
	_serial = 0;
	groupList.setAutoDelete(true);
	contactList.setAutoDelete(true);
	_status = FLN;
	_publicName = "";
	connected = false;
	_silent = false;
	serviceSocket = new IMServiceSocket();
	// connections
	connect( serviceSocket, SIGNAL(groupAdded(QString, uint,uint)), this, SLOT(slotGroupAdded(QString, uint, uint )));
	connect( serviceSocket, SIGNAL(groupRenamed(QString, uint,uint)), this, SLOT(slotGroupRenamed( QString, uint, uint)));
	connect( serviceSocket, SIGNAL(groupName(QString, uint)), this, SLOT(slotGroupName(QString, uint)));
	connect( serviceSocket, SIGNAL(groupRemoved( uint, uint )), this, SLOT(slotGroupRemoved(uint, uint )));

	connect( serviceSocket, SIGNAL(contactAdded(QString, QString, QString, uint, uint)), this, SLOT(slotContactAdded(QString, QString, QString, uint, uint )));
	connect( serviceSocket, SIGNAL(contactRemoved(QString, QString, uint, uint)), this, SLOT(slotContactRemoved(QString, QString, uint, uint)));

	// SessionID, Address, AuthInfo, handle, publicName
	connect( serviceSocket, SIGNAL(invitedToChat(QString, QString, QString, QString, QString )), this, SLOT(slotCreateChat( QString, QString, QString, QString, QString )));
	connect( serviceSocket, SIGNAL(startChat( QString,QString )), this, SLOT(slotCreateChat(QString, QString )));

	connect( serviceSocket, SIGNAL(contactStatusChanged(QString, QString, QString)), this, SLOT(slotContactStatusChanged(QString, QString, QString)));
	connect( serviceSocket, SIGNAL(contactStatus(QString, QString, QString)), this, SLOT(slotContactStatus(QString, QString, QString)));
	connect( serviceSocket, SIGNAL(contactList(QString, QString, QString, QString)), this, SLOT(slotContactList(QString, QString, QString, QString)));

	connect( serviceSocket, SIGNAL( connected(bool)), this, SLOT(slotConnected(bool )));
	connect( serviceSocket, SIGNAL( statusChanged( QString )), this, SLOT(slotStatusChanged( QString )));

	connect( serviceSocket, SIGNAL( newMail( QString, uint )), this, SLOT(slotNewMail( QString, uint )));

	connect( serviceSocket, SIGNAL( publicNameChanged(QString ,QString)), this, SLOT(slotPublicNameChanged(QString, QString)));
	connect( serviceSocket, SIGNAL( newPublicName(QString)), this, SLOT(slotPublicNameReceived(QString)));

}
IMService::~IMService(){
}


void IMService::cleanUp()
{
	contactList.clear();
	groupList.clear();
	_status = FLN;
	_serial = 0;
}

/* Connect to MSN Service */
void IMService::slotConnectToService()
{

	serviceSocket->connectToService(_handle, _password, _serial, _silent);
	emit connectingToService();
}

/* Disconnect from MSN Service */
void IMService::disconnect()
{
	serviceSocket->closeService();
}

/* Kill current connection - delete the socket */
void IMService::cancelConnect()
{
	serviceSocket->kill();
}

/* Change the status */
void IMService::changeStatus( Status status)
{
	serviceSocket->setStatus(status);
}

/* change the publicName to this new name */
void IMService::setMyPublicName( QString publicName )
{
	serviceSocket->changePublicName( publicName );
}

// slots
/* Incoming RING command: connect to the Switchboard server and send the startChat signal */
// SessionID, Address, AuthInfo, handle, publicName     ( RNG)
void IMService::slotCreateChat(QString ID, QString address, QString auth, QString handle, QString publicName)
{
	chatService = new IMChatService();
	chatService->setHandle(_handle);
	chatService->imService = this;
	chatService->connectToSwitchBoard(ID, address, auth);
	emit startChat(chatService, handle);
}

/* 	Incoming XFR command: this is an result from slotStartChatSession(handle)
**	connect to the switchboard server and sen startChat signal */
// (XFR)
void IMService::slotCreateChat( QString address, QString auth)
{
	chatService = new IMChatService();
	chatService->setHandle(_handle);
	chatService->msgHandle = msgHandle;
	chatService->imService = this;
	chatService->connectToSwitchBoard(0L, address, auth);
	emit startChat(chatService, msgHandle);
}

/*	Start a new chat session: the result is an XFR command, see above
**	**FIXME** The chat session needs an update, */
void IMService::slotStartChatSession(QString handle)
{
	if(connected)
	{
		if( handle == _handle) return;
		msgHandle =handle;
		serviceSocket->createChatSession(  );
	}
}

/*	connected or disconnectd from service */
void IMService::slotConnected( bool f)
{
	if(f)
	{
		_publicName = serviceSocket->_publicName;
	}
	emit connectedToService(f);
	kdDebug() << "set connected to: " << f << endl;
	connected = f;
	if(!f)
	{
		cleanUp();
	}
	
}

// this is the own status
void IMService::slotStatusChanged( QString status )
{
	_status = convertStatus( status );
	emit statusChanged( _status );
}

// contact has changed status
void IMService::slotContactStatusChanged(QString handle, QString publicName, QString status)
{
	IMContact *imContact;
	for(imContact = contactList.first(); imContact != 0; imContact = contactList.next() )
	{
		if(imContact->getHandle() == handle )
		{
			if( status == "FLN" )
			{
				imContact->setStatus(convertStatus(status) );
				emit updateContact( handle,  convertStatus(status) );
				return;
			}
			else
			{
				imContact->setStatus(convertStatus(status) );
				imContact->setPublicName(publicName);
				emit updateContact( handle,  convertStatus(status) );
				return;
			}
		}
	}
}

// status of contact after login
void IMService::slotContactStatus(QString handle, QString publicName, QString status)
{
	IMContact *imContact;
	for(imContact = contactList.first(); imContact != 0; imContact = contactList.next() )
	{
		if(imContact->getHandle() == handle )
		{
			imContact->setStatus(convertStatus(status) );
			imContact->setPublicName(publicName);
			emit updateContact(handle, convertStatus(status) );
			return;
		}
	}
}

void IMService::slotContactList(QString handle, QString publicName, QString group, QString list )
{
	IMContact *imContact, *imSearchContact;
	QString groupName;
	QStringList groups;
	groups = QStringList::split(",",group, false );
	if( list == "FL")
	{
		imContact = new IMContact();
		imContact->setHandle(handle);
		imContact->setPublicName(publicName);
		for ( QStringList::Iterator it = groups.begin(); it != groups.end(); ++it )
		{
			imContact->addToGroup( getGroupName( (*it).latin1() ) );
		}
		contactList.append( imContact );
		return;
	}
	if( list == "BL")
	{
		for( imSearchContact = contactList.first(); imSearchContact != 0; imSearchContact = contactList.next() )
		{
			if(imSearchContact->getHandle() == handle)
			{
				imSearchContact->setBlocked(true);
				return;
			}
		}
		imContact = new IMContact();  // deleted contact
		imContact->setHandle(handle);
		imContact->setPublicName(publicName); // this is an deleted Contact
		imContact->setDeleted(true);
		contactList.append( imContact );
		return;
	}
	if( list == "AL" ) // deleted Contacts still contain in AL list
	{
		for( imSearchContact = contactList.first(); imSearchContact != 0; imSearchContact = contactList.next() )
		{
			if(imSearchContact->getHandle() == handle)
			{
				return;
			}
		}
		imContact = new IMContact();
		imContact->setHandle(handle);
		imContact->setPublicName(publicName); // this is an deleted Contact
		imContact->setDeleted(true);
		contactList.append( imContact );
		return;
	}
	if(list == "RL" )
	{
		// search for new Contacts
		for( imSearchContact = contactList.first(); imSearchContact != 0; imSearchContact = contactList.next() )
		{
			if(imSearchContact->getHandle() == handle)
			{
				imSearchContact->setPublicName(publicName);
				return;
			}
		}
		// contact not found - Authenticate
		emit newContact( handle );
	}
		
}

/*	A new contact is added to the list.*/
void IMService::slotContactAdded(QString handle, QString publicName, QString list, uint serial, uint group)
{
	IMContact *imContact;
	IMGroups *imGroup;
	QString groupName;
	_serial = serial;
	for( imGroup = groupList.first(); imGroup != 0; imGroup = groupList.next())
	{
		if(imGroup->group == group)
		{
			groupName = imGroup->groupName;
		}
	}
	for( imContact = contactList.first(); imContact != 0; imContact = contactList.next() )
	{
		if(imContact->getHandle() == handle )
		{
			if( group != 0L)
			{
				imContact->addToGroup(groupName);
			}
			if( list == "BL" )
			{
				imContact->setBlocked(true);
				emit updateContact(handle, BLO);
			}
			if( list == "FL" )
			{
				imContact->addToGroup(groupName );
				emit contactAdded(handle, publicName, groupName);
			}
			return;
		}
	}
	// contact not found
	// create new one
	if( list == "FL" )
	{
		imContact = new IMContact();
		imContact->setHandle(handle);
		imContact->setPublicName(publicName); // this is an deleted Contact
		imContact->setDeleted(true);
		imContact->addToGroup( groupName );
		contactList.append( imContact );
		emit contactAdded(handle, publicName, groupName);
		return;
	}
	if( list == "AL" )
	{
		imContact = new IMContact();
		imContact->setHandle(handle);
		imContact->setPublicName(publicName);
		imContact->setBlocked(false);
		contactList.append( imContact );
		return;
	}
	if( list == "BL" )
	{
		imContact = new IMContact();
		imContact->setHandle(handle);
		imContact->setPublicName(publicName); // this is an deleted Contact
		imContact->setDeleted(false);
		imContact->setBlocked(true);
		imContact->addToGroup( groupName );
		contactList.append( imContact );
		emit contactAdded(handle, publicName, groupName);
		return;
	}

	emit newContact( handle );
}

/*	This contact is removed from the list */
void IMService::slotContactRemoved(QString handle, QString list, uint serial, uint group)
{
	IMContact *imContact;
	IMGroups *imGroup;
	QString groupName;
	_serial = serial;
	// get the group name from the groupList
	for( imGroup = groupList.first(); imGroup != 0; imGroup = groupList.next())
	{
		if(imGroup->group == group)
		{
			groupName = imGroup->groupName;
		}
	}
	// search the contact in the contactList
	for( imContact = contactList.first(); imContact != 0; imContact = contactList.next() )
	{
		if(imContact->getHandle() == handle )
		{
			if( group != 0L)
			{
				imContact->removeFromGroup(groupName);
			}
			if( list == "BL" )
			{
				// the contact is removed from the blocked list, add it to the AL list
				imContact->setBlocked(false);
				serviceSocket->addContact( handle, getPublicName(handle), 0, AL );
				emit updateContact(handle, imContact->getStatus());
			}
			if( list == "RL" )
			{ /*
				// this contact is removed from the reverse list, only msn can do this
				// this is currently not supported
				InfoWidget *info = new InfoWidget(0);
				info->title->setText("<b>" + i18n( "Contact removed!" ) +"</b>" );
				QString dummy;
				dummy = "<center><b>" + imContact->getPublicName() + "(" +imContact->getHandle()  +")</b></center><br>";
				dummy += i18n("has removed you from his contact list!") + "<br>";
				dummy += i18n("This contact is now removed from your contact list");
				info->infoText->setText(dummy);
				info->setCaption("KMerlin - Info");
				info->show();  */
				
			}
			if( list == "FL" )
			{
				// Contact is removed from the FL list, remove it from the group
				imContact->removeFromGroup(groupName);
				emit contactRemoved( handle, groupName );
			}
			if( imContact->getGroupList().count() == 0 )
			{
				// The contact isn't in a group, so delete it. bye bye
				contactList.remove(imContact);
			}
			
		}
	}
}

/*	MSN has send the current publicName */
void IMService::slotPublicNameReceived(QString publicName)
{
	_publicName = publicName;
	emit publicNameChanged(_publicName);
}

/*	The publicName has successful changed
**	This is an anwser from setMyPublicName, */
void IMService::slotPublicNameChanged(QString handle, QString publicName)
{
	if( handle == _handle)
	{
		_publicName = publicName;
		emit publicNameChanged(_publicName);
	}
}

/*	MSN send the LSG command: this is a list of all groups */
void IMService::slotGroupName(QString groupName, uint group)
{
	IMGroups *imGroup = new IMGroups();
	imGroup->group = group;
	imGroup->groupName = groupName;
	groupList.append(imGroup);
}

/*	The new group has successful added */
void IMService::slotGroupAdded( QString groupName, uint serial, uint group)
{
	IMGroups *imGroup = new IMGroups();
	_serial = serial;
	imGroup->group = group;
	imGroup->groupName = groupName;
	groupList.append(imGroup);
	emit groupAdded(groupName);
}

/*	The group has successful renamed
	groupName: is new new group name
	search the old groupName in the groupList with (uint group)*/
void IMService::slotGroupRenamed( QString groupName, uint serial, uint group )
{
	IMGroups *imGroup;
	IMContact *imContact;
	QString oldGroupName;
	_serial = serial;
	for( imGroup = groupList.first(); imGroup != 0; imGroup = groupList.next() )
	{
		if(imGroup->group == group ) // same group ID
		{
			oldGroupName = imGroup->groupName;
			// each contact has a groupList, so change it
			for( imContact = contactList.first(); imContact != 0; imContact = contactList.next() )
			{
				if( imContact->isInGroup(oldGroupName) )
				{
					imContact->removeFromGroup(oldGroupName);
					imContact->addToGroup(groupName);
				}
			}
			imGroup->groupName = groupName;
			emit groupRenamed(oldGroupName, groupName);
			return;
		}
	}
}

void IMService::slotNewMail( QString message, uint count )
{
	emit newMail(message, count);
}

/*	The group has successful removed, delete it in the groupList */
void IMService::slotGroupRemoved( uint serial, uint group )
{
	IMGroups *imGroup;
	QString groupName;
	_serial = serial;
	 for( imGroup = groupList.first(); imGroup != 0; imGroup = groupList.next() )
	{
		if( imGroup->group == group)
		{
			groupName = imGroup->groupName;
		}
	}
	for( imGroup = groupList.first(); imGroup != 0; imGroup = groupList.next() )
	{
		if(imGroup->group == group )
		{
			groupList.remove(imGroup);
		}
	}
	emit groupRemoved(groupName);
}

// get a list of all contacts in this group
QStringList IMService::getContacts( const QString &groupName)
{
	IMContact *imContact;
	QStringList list;
	for(imContact = contactList.first(); imContact != 0; imContact = contactList.next() )
	{
		if( imContact->isInGroup(groupName) )
		{
			list.append(imContact->getHandle() );
		}
	}
	return list;
}

/*	Returns true if this contact is online, otherwise false */
bool IMService::isAvailable(QString handle)
{
	IMContact *imContact;
	for(imContact = contactList.first(); imContact != 0; imContact = contactList.next() )
	{
		if( imContact->getHandle() == handle )
		{
			if(imContact->getStatus() != FLN  )
			{
				return true;
			}
			else return false;
		}
	}
	return false;
}

/*	This returns a list of all online contacts */
QStringList IMService::getAvailableContacts()
{
	IMContact *imContact;
	QStringList list;
	for(imContact = contactList.first(); imContact != 0; imContact = contactList.next() )
	{
		if( imContact->getStatus() != FLN  )
		{
			list.append(imContact->getHandle() );
		}
	}
	return list;
}

/*	This return an info string: how many contacts in ti and how many are online */
QString IMService::getGroupInfo(QString groupName)
{
	IMContact *imContact;
	int cnCount, coCount;
	cnCount = coCount =0;
	QString dummy;
	for(imContact = contactList.first(); imContact != 0; imContact = contactList.next() )
	{
		if( imContact->isInGroup(groupName) )
		{
			cnCount++;
			if(imContact->getStatus() != FLN)
			{
				coCount++;
			}
		}
	}
	dummy.sprintf("( %i / %i )",cnCount, coCount);
	return dummy;

}
// get a list of all groups
QStringList IMService::getGroups()
{
	IMGroups *imGroup;
	QStringList list;
	for( imGroup = groupList.first(); imGroup != 0; imGroup = groupList.next() )
	{
		list.append(imGroup->groupName );
	}
	return list;
}

// add a new group
void IMService::groupAdd()
{
	IMGroups *imGroup;
	int i = 1;
	QString newGroupName;
	QString num;
redo:
	num.setNum(i);
	newGroupName = i18n("New Group")+ num;
	for( imGroup = groupList.first(); imGroup != 0; imGroup = groupList.next() )
	{
		if(imGroup->groupName == newGroupName) //  this groupName exists
		{
			i++;
			goto redo; // create next one
		}
	}
	serviceSocket->addGroup( newGroupName );
}

// rename a group
void IMService::groupRename( QString oldGroupName, QString newGroupName )
{
	IMGroups *imGroup;
	// search the group ID for the oldGroupName
	for( imGroup = groupList.first(); imGroup != 0; imGroup = groupList.next() )
	{
		if(imGroup->groupName == oldGroupName)
		{
			serviceSocket->renameGroup( newGroupName, imGroup->group );
			return;
		}
	}
}

// remove a group
void IMService::groupDelete( QString groupName )
{
	IMGroups *imGroup;
	for( imGroup = groupList.first(); imGroup != 0; imGroup = groupList.next() )
	{
		if(imGroup->groupName == groupName)
		{
			serviceSocket->removeGroup( imGroup->group );
			return;
		}
	}
}

void IMService::contactAdd( QString handle )
{
	if(connected)
	{
		serviceSocket->addContact( handle, getPublicName( handle ), 0, FL);
		serviceSocket->addContact( handle, getPublicName( handle ), 0, AL);
	}
}

/*	Copy an Contact the a other group */
void IMService::contactCopy( QString handle, QString groupName )
{
	IMGroups *imGroup;
	for( imGroup = groupList.first(); imGroup != 0; imGroup = groupList.next() )
	{
		if(imGroup->groupName == groupName)
		{
			serviceSocket->addContact( handle, getPublicName( handle), imGroup->group, FL);
			kdDebug() << getPublicName(handle) << endl;
			return;
		}
	}
}

/*	Move an contact to a other group */
void IMService::contactMove( QString handle, QString oldGroupName, QString newGroupName )
{
	IMGroups *imGroup;
	uint newGroup = getGroupNumber( newGroupName );
	uint oldGroup = getGroupNumber( oldGroupName );
	for( imGroup = groupList.first(); imGroup != 0; imGroup = groupList.next() )
	{
		if(imGroup->groupName == oldGroupName)
		{
			serviceSocket->addContact( handle, getPublicName(handle), newGroup, FL);
			serviceSocket->removeContact(handle, oldGroup, FL );
			return;
		}
	}
}

/*	Remove a contact from a group */
void IMService::contactRemove( QString handle, QString groupName )
{
	IMGroups *imGroup;
	for( imGroup = groupList.first(); imGroup != 0; imGroup = groupList.next() )
	{
		if(imGroup->groupName == groupName)
		{
			serviceSocket->removeContact( handle, imGroup->group, FL );
			return;
		}
	}
}


uint IMService::getGroupNumber( QString groupName )
{
	IMGroups *imGroup;
	for( imGroup = groupList.first(); imGroup != 0; imGroup = groupList.next() )
	{
		if(imGroup->groupName == groupName)
		{
			return imGroup->group;
		}
	}
	return 0;
}

QString IMService::getGroupName( QString number )
{
	IMGroups *imGroup;
	for( imGroup = groupList.first(); imGroup != 0; imGroup = groupList.next() )
	{
		if(imGroup->group == number.toUInt() )
		{
			return imGroup->groupName;
		}
	}
	return "";
}

// this deletes a contact from the list
void IMService::contactDelete( QString handle )
{
	QStringList list;
	QString groupName;
	IMContact *imContact;
	for(imContact = contactList.first(); imContact != 0; imContact = contactList.next() )
	{
		if( imContact->getHandle() == handle )
		{
			list =  imContact->getGroupList();
		}
	}
	for ( QStringList::Iterator it = list.begin(); it != list.end(); ++it )
	{
		serviceSocket->removeContact( handle, getGroupNumber( (*it).latin1() ), FL );
	}
	if( isBlocked( handle ) )
	{
		serviceSocket->removeContact( handle, 0, BL );
	}
	
}

/*	Add this contact to the block list */
void IMService::contactBlock( QString handle )
{
	serviceSocket->removeContact( handle, 0, AL); // remove it from the al list
	serviceSocket->addContact( handle, getPublicName( handle ), 0, BL );
}

/*	Allow this blocked contact */
void IMService::contactUnBlock( QString handle )
{
	serviceSocket->removeContact( handle, 0, BL );
	
}


// get a list of all blocked contacts
QStringList IMService::getBlockedContacts()
{
	IMContact *imContact;
	QStringList list;
	for(imContact = contactList.first(); imContact != 0; imContact = contactList.next() )
	{
		if( imContact->isBlocked () )
		{
			list.append(imContact->getHandle() );
		}
	}
	return list;
}

/*	Returns the publicName */
QString IMService::getPublicName(  QString handle)
{
	IMContact *imContact;
	for(imContact = contactList.first(); imContact != 0; imContact = contactList.next() )
	{
		if( imContact->getHandle() == handle )
		{
			return imContact->getPublicName();
		}
	}
	return handle;
}

/*	Return true if this contact is blocked */
bool IMService::isBlocked( QString handle)
{
	IMContact *imContact;
	for(imContact = contactList.first(); imContact != 0; imContact = contactList.next() )
	{
		if(imContact->getHandle() == handle )
		{
			return imContact->isBlocked();
		}
	}
	return false;
}

bool IMService::isNewContact(QString handle )
{
	IMContact *imContact;
	for(imContact = contactList.first(); imContact != 0; imContact = contactList.next() )
	{
		if(imContact->getHandle() == handle )
		{
			return false;
		}
	}
	return true;
}

// get the status from this contacts
int IMService::getStatus(  QString handle)
{
	IMContact *imContact;
	for(imContact = contactList.first(); imContact != 0; imContact = contactList.next() )
	{
		if(imContact->getHandle() == handle )
		{
			return imContact->getStatus();
		}
	}
	return FLN;
}

void IMService::readConfig()
{

}




int IMService::convertStatus( QString status )
{
	if(status == "NLN")
	{
		return NLN;
	}
	if(status == "FLN")
	{
		return FLN;
	}
	if(status == "HDN")
	{
		return HDN;
	}
	if(status == "PHN")
	{
		return PHN;
	}
	if(status == "LUN")
	{
		return LUN;
	}
	if(status == "BRB")
	{
		return BRB;
	}
	if(status == "AWY")
	{
		return AWY;
	}
	if(status == "BSY")
	{
		return BSY;
	}
	if( status == "IDL" )
	{
		return IDL;
	}
	return FLN;
}

#include "imservice.moc"



