/***************************************************************************
                          chatwindow.h  -  description
                             -------------------
    begin                : Wed Jul 4 2001
    copyright            : (C) 2001 by olaf lueg
    email                : olaf.lueg@t-online.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CHATWINDOW_H
#define CHATWINDOW_H

#include <qwidget.h>

#include <kapp.h>
#include <kmainwindow.h>
#include <kaccel.h>
#include <kaction.h>
/**
  *@author olaf lueg
  */
class ChatMember;
class ChatViewImpl;
class QPopupMenu;
class KMsnApp;
class QFont;
class ChatWindow : public KMainWindow  {
   Q_OBJECT
public: 
	ChatWindow(QWidget *parent=0, const char *name=0);
	~ChatWindow();
	ChatViewImpl *view;
	KMsnApp *theApp;
	int timer_id;
	bool textChanged;
	QFont myFont;
	QString chatWith, waitingMessage;
	QString strPixUser;
	bool switchBoardIsActive,available;
	QList <ChatMember> chatMemberList;
	// Actions
	KToolBarPopupAction* fileInvite;
	KSelectAction* fileContact;
	KSelectAction* fileInviteMenu;
	KAction* fileSave;
	KAction* filePrint;
	KAction* fileQuit;
	
	KToggleAction* viewToolBar;
	KToggleAction* viewStatusBar;
	KToggleAction* viewSmileys;

	KAction* editCut;
	KAction* editCopy;
	KAction* editPaste;
	KAction* editFont;
	
	KToolBarPopupAction *toolBarSmiley;
	
	QPopupMenu* menu;
private:
	QString statusMsg;
	
public slots: // Public slots
	/** Saves the chat to a file */
	void slotFileSave();
	/** No descriptions */
	void slotViewStatusBar();
	/** No descriptions */
	void slotViewToolBar();
	void slotStatusMsg(const QString &text);
	/** toggle the smileys */
	void slotViewSmileys();
	/** No descriptions */
	void slotFileQuit();
	/** No descriptions */
	void slotEditCopy();
	/** No descriptions */
	void slotEditPaste();
	/** No descriptions */
	void slotEditCut();
	/** No descriptions */
	void slotFilePrint();
	/** No descriptions */
	
	/** No descriptions */
	void slotInviteContact(int i);
	void slotInviteContact();
	void slotInviteContactMenu(int i);
	void slotUpdateInviteMenu();
	
	void slotAddContact(int i);
	void slotAddContact();
	void slotUpdateContact();
	  	
	void slotChatWith(QString handle,bool av);
	void updateInfoText(QString text);
	void slotSwitchBoardIsActive(bool active);
	void slotContactTyping(QString handle);
	void slotUpdateChatMemberList(QString handle, QString command,bool last);
	void slotMsgAcknowledgement(bool f);
	void slotMsgReceived(QString handle,QString publicName ,QString msg);
	void slotSendButtonClicked(QString);
	void slotWriteMessage();
	void slotSmiley(int index);

public:
    void updateStatusText();

	/** No descriptions */
  	void initActions();
  	/** No descriptions */
  	void readOptions();
  	/** No descriptions */
  	void saveOptions();
  	/** No descriptions */
  	void closeEvent(QCloseEvent*);
private slots: // Private slots
  /** No descriptions */
  void slotUpdateInviteButton();
  /** No descriptions */
  void slotSetFont();
protected: // Protected methods
  /** No descriptions */
  void timerEvent(QTimerEvent* ev);

public:
signals: // Signals
	/** sends the contact is writing a message command
	*/
	void typingMsg();
	/** Invite an user to the current chat
  		@param The handle from this user
  	*/
  	void inviteContact(QString);
  	/** No descriptions */
  	void closeSession();
	/** reconnect to switchoard server */
	void createSession(QString);
	/** sends a message to switchboard server */
	void sendMsg(QString);
};

#endif
