#ifndef wrappers_h
#define wrappers_h

#include <config.h>
#include "kinterface.h"
#include "stdtypes.h"
#include "llist.h"

//this structure is common to RJK and LINUX_KERNEL
#ifdef KISSME_RJK_KERNEL
#include "kinterface.h"

char* strchr(const char* str, int c);

//#define USE_WAIT_QUEUES

typedef struct tmutexwaitentry {
#ifdef USE_WAIT_QUEUES
  struct wait_queue* wq;
#else
  int thread_id;
  struct task_struct* ts;
#endif
} tMutexWaitEntry;

#endif

#ifdef KISSME_LINUX_KERNEL
#define NATIVE_MUTEX
#endif

#ifdef KISSME_LINUX_USER
#ifdef ALTERNATE_CONDITION
#define NATIVE_MUTEX
#endif
#endif

#ifdef NATIVE_MUTEX

#ifdef ALTERNATE_CONDITION
typedef struct tmutexwaitentry {
#ifdef USE_WAIT_QUEUES
  struct wait_queue* wq;
#else
  int thread_id;
  struct task_struct* ts;
#endif
} tMutexWaitEntry;
#endif

struct kernel_mutex {

  kuint spinlock;		//Lock used to lock this mutex when we're changing its structure members
  int thread_owner_id;	//ID of thread that owns the lock
  int type;		//0 indicates normal mutex, 1 is recursive
  int recursion_count;	//recursion count for type 1 mutexes
  int status;		//lock status, 0 is unlocked, 1 is locked

  tMutexWaitEntry* waitList;
  //  int* waitList;	//list of thread IDs waiting on this lock
  int waitListSize;	//size of that list
  int waitListUsed;	//number of valid entries in that list
} ;

typedef struct kernel_mutex tMutex;

typedef struct tcondwaitentry {
  int thread_id;
  volatile int signalled;
} tCondWaitEntry;

typedef struct tcondvariable {

  kuint spinlock; //lock used while altering members
  tList* pstWaitingList; //list of threads waiting on this condition
} tCondVariable;
#endif

#ifdef KISSME_LINUX_KERNEL
#define sys_current_thread() current->pid

typedef struct file tFile;

typedef struct kissme_timespec {
  int tv_sec;
  int tv_nsec;
} tTimeSpec;

#else

#ifdef KISSME_LINUX_USER


#include <pthread.h>
#include <stdio.h>
#include <time.h>

#define sys_current_thread() pthread_self()

#ifdef ALTERNATE_CONDITION



#else
typedef pthread_cond_t tCondVariable;
typedef pthread_mutex_t tMutex;
#endif


typedef struct timespec tTimeSpec;
typedef FILE tFile;

#else

#ifndef KISSME_RJK_KERNEL
#error You must define one of KISSME_LINUX_KERNEL, KISSME_LINUX_USER or KISSME_RJK_KERNEL!
#endif

/* RJK */



//hack for JNIData table with only 65535 entries. Must hash this later.
#define sys_current_thread() (kinterface->kthread_current())

typedef kmutex tMutex;
typedef kcondition tCondVariable;

struct rjkfile {
  int empty;
};

typedef struct rjkfile tFile;
typedef struct kissme_timespec {
  int tv_sec;
  int tv_nsec;
} tTimeSpec;

#endif
#endif


/* Mutex and synchronisation prototypes */

int sys_mutex_provider_init();

tMutex* sys_mutex_create(int type);
int sys_mutex_destroy(tMutex* mutex);

int sys_mutex_lock(tMutex* mutex);
int sys_mutex_unlock(tMutex* mutex);

int sys_condition_provider_init();
tCondVariable* sys_condition_create();
tCondVariable* sys_condition_create_inplace(tCondVariable* cond);
int sys_condition_destroy(tCondVariable* cond);

int sys_condition_signal(tCondVariable* cond);
int sys_condition_broadcast(tCondVariable* cond);
int sys_condition_wait(tCondVariable* cond, tMutex* mutex);
int sys_condition_wait_nogc(tCondVariable* cond, tMutex* mutex);
int sys_condition_timedwait(tCondVariable* cond, tMutex* mutex, tTimeSpec* timeout);

/* Memory allocation */

void* sys_malloc( int size );
void sys_free( void* ptr );

/* File IO */

tFile* sys_file_open(const char* filepath, int mode);
int sys_file_read(tFile* filp, byte* buffer, int amount);
int sys_file_write(tFile* filp, byte* buffer, int amount);
int sys_file_length(tFile* filp);
int sys_file_close(tFile* filp);
/* Misc. */

int sprintInt(char* str, int value);

#endif
