/*
 * Copyright (C) 2001, John Leuner.
 *
 * This file is part of the kissme/teaseme project, which in turn is part of the JOS project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2,
 * or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * thread.h
 *
 */

#ifdef KISSME_LINUX_USER
#include <pthread.h>
#endif

#include "jni.h"
#include "interp/methodstacks.h"
#include "llist.h"
#include "wrappers.h"
#include "garbage/public_methods.h"

void java_lang_Thread_yield(JNIEnv* env, jobject obj);
void java_lang_Thread_sleep(JNIEnv* env, jobject obj, jlong millis, jint nanos);
void java_lang_Thread_start(JNIEnv* env, jobject obj);
void java_lang_Thread__throwState(JNIEnv* env, jobject obj, jobject throwobj, jint state, jlong millis, jint nanos);
void java_lang_Thread_destroy(JNIEnv* env, jobject obj);
jboolean java_lang_Thread_isAlive(JNIEnv* env, jobject obj);
void java_lang_Thread_suspend(JNIEnv* env, jobject obj);
void java_lang_Thread_resume(JNIEnv* env, jobject obj);
void java_lang_Thread_join(JNIEnv* env, jobject obj, jlong millis);
void java_lang_Thread__setPriority(JNIEnv* env, jobject obj, jint newPriority);
jint java_lang_Thread__countStackFrames(JNIEnv* env, jobject obj);

void java_lang_Thread__initC(JNIEnv* env, jobject obj);
void java_lang_Thread__link(JNIEnv* env, jobject obj);
void java_lang_Thread__createJNIData(JNIEnv* env, jobject obj);

void java_lang_Thread_nativeSetDaemon(JNIEnv* env, jobject thisthread, jboolean on);
jboolean java_lang_Thread_nativeIsDaemon(JNIEnv* env, jobject thisthread);

int THREAD_unlockThreadList();
tMutex* THREAD_GetThreadListMutex();


#ifdef NATIVE_THREADS

#ifndef __thread_node__
#define __thread_node__
typedef struct tthreadnode
{
    int         thread_id; 
    jobject	      object;    // A reference to the java/lang/Thread object
    struct tthreadnode* next;    // Next pointer

    tList*	     pstInitialFrames;

    void*	      stackBottom; //The place where the stack starts. From here to stackTop is the C stack.
    void*	      stackTop; //The place where the stack ends. 
    int		      isDaemon; //Flag indicating whether this is a daemon thread
    int		      isTerminated; //Flag indicating that the thread is dead (natural or unnatural death)
  //for sablevm locking, we need a contention bit, a contention lock and a ll of waiting thread,object,cond tuples, and a waitNotify list

#ifdef SABLE_LOCKS
  int32 i32ContentionBit;
  tMutex* mutContentionLock;
  tList* pstWaitList;
#endif

//moved the condition variable into the object header

} tThreadNode;


typedef struct tthreadargs
{
    tStackFrame* newFrame;
    tStackFrame* cleanupFrame; //unused in kissme
    tOBREF threadObject;
    tClassLoaderTuple* pstMainClass; //unused in kissme
    void* returnStackBottom;
    JNIEnv* env;
    tAllocatorHeap* pstOrigHeap; //unused in kissme
} tThreadArgs;

#ifdef EVICTIONS
typedef struct tthreadstackelem
{
  tOBREF              hThread;
  tStackFrame*        pstTopFrame;
  struct tthreadstackelem* pstNext;
} tThreadStackElem;
#endif

#endif
tThreadNode* THREAD_lockAndGetThreadList();
tThreadNode* THREAD_GetThreadList();
tThreadNode* THREAD_FindThread();
pthread_mutex_t* THREAD_getThreadListMutex();
tThreadNode* THREAD_getThreadList();
void THREAD_setThreadList(tThreadNode* nlist);
void THREAD_Init();
#include "threadinfo.h"
#endif
