#include <config.h>
#include "stdtypes.h"
#include <stdio.h>

#include "loading_errors.h"

void printLoadingError(uint32 errcode)
{
  switch(errcode)
    {
    case 0:
      eprintf("No error");
      break;
    case LOADING_ERROR_NO_FILE:
      eprintf("Could not find a .class file for this class");
      break;
    case LOADING_ERROR_BAD_MAGIC:
      eprintf("The .class file for this class had an invalid magic number. Are you sure this is a valid class file?");
      break;
    case LOADING_ERROR_NO_SUPERCLASS:
      eprintf("The superclass for this class could not be created");
      break;
    case LOADING_ERROR_BAD_FIELDS:
      eprintf("An error ocurred while processing the field structures for this class");
      break;
    case LOADING_ERROR_BAD_METHODS:
      eprintf("An error ocurred while processing the method structures for this class");
      break;
    case LOADING_ERROR_BAD_ATTRIBUTES:
      eprintf("An error ocurred while processing the attributes structures for this class");
      break;
    case LOADING_ERROR_OUT_OF_MEMORY:
      eprintf("Out of memory");
      break;
    case LOADING_ERROR_NO_CLASSPATH:
      eprintf("No classpath specified. Try kissme --help");
      break;
    case LOADING_ERROR_BAD_CLASS_NAME:
      eprintf("The class loaded has the wrong name");
      break;
    default:
      eprintf("Unknown error code, please contact program author");
      break;
    }
}
