// This file contains the routines for turning bytecodes into assembly

void* gen_c_getfield_quick(byte* pbCode, byte* pbIter);

int max_ass_instructions_per_opcode = 50;

static void* object_pointers[] = { SVETLANA_getfield,
				   SVETLANA_arraylength,
				   SVETLANA_iastore,
};

/* This is the standard C prologue that saves the previous stack pointer and sets up our stack */

//9:   60                      pushal
//    a:   61                      popal
      
    //    9:   66 60                   pushaw 
#define gen_c_prologue()  *(pbIter++) = 0x55; \
    *(pbIter++) = 0x89;\
    *(pbIter++) = 0xe5; \
   *(pbIter++) = 0x60;\


/* The epilogue is a leave and ret instruction */
//b:   66 61                   popaw  

#define gen_c_epilogue()  *(pbIter++) = 0x61; \
    *(pbIter++) = 0xc9; \
    *(pbIter++) = 0xc3;\

/* This generates the asm for each bytecode */

inline byte* gen_bytecode_instruction(byte code, byte* pbIter)
{
    switch(code)
	{
	    /* Stack inss */
	case nop:
	    break;
	case pop:
	    //	    9:   58                      popl   %eax
  	    *(pbIter++) = 0x58;
	    break;
	case pop2:
	    //	    9:   58                      popl   %eax
  	    *(pbIter++) = 0x58;
  	    *(pbIter++) = 0x58;
	    break;
	case dup_:

	    //	    9:   58                      popl   %eax
  	    *(pbIter++) = 0x58;

	    //		26:   50                      pushl  %eax 
	    *(pbIter++) = 0x50;
	    //		26:   50                      pushl  %eax 
	    *(pbIter++) = 0x50;

	    break;
	case swap:
    	    //	    9:   58                      popl   %eax
  	    *(pbIter++) = 0x58;

	    //   18:   5a                      popl   %edx
	    (*pbIter++) = 0x5a;

	    //		26:   50                      pushl  %eax 
	    *(pbIter++) = 0x50;

	    //	    1b:   52                      pushl  %edx
    	    (*pbIter++) = 0x52;

	    break;
 	    /* Constant instructions 

	     */
	case iconst_m1:
	    //	    21:   b8 00 00 00 00          movl   $0x0,%eax
	    *(pbIter++) = 0xb8;
	    *(pbIter++) = 0xff;
	    *(pbIter++) = 0xff;
	    *(pbIter++) = 0xff;
	    *(pbIter++) = 0xff;
	    //		26:   50                      pushl  %eax 
	    *(pbIter++) = 0x50;
	    break;
	case iconst_0:
	case aconst_null:
	    //	    21:   b8 00 00 00 00          movl   $0x0,%eax
	    *(pbIter++) = 0xb8;
	    *(pbIter++) = 0x00;
	    *(pbIter++) = 0x00;
	    *(pbIter++) = 0x00;
	    *(pbIter++) = 0x00;
	    //		26:   50                      pushl  %eax 
	    *(pbIter++) = 0x50;
	    break;
	case iconst_1:
	    //	    21:   b8 00 00 00 00          movl   $0x0,%eax
	    *(pbIter++) = 0xb8;
	    *(pbIter++) = 0x01;
	    *(pbIter++) = 0x00;
	    *(pbIter++) = 0x00;
	    *(pbIter++) = 0x00;

	    //		26:   50                      pushl  %eax 
	    *(pbIter++) = 0x50;
	    break;
	case iconst_2:
	    //	    21:   b8 00 00 00 00          movl   $0x0,%eax
	    *(pbIter++) = 0xb8;
	    *(pbIter++) = 0x02;
	    *(pbIter++) = 0x00;
	    *(pbIter++) = 0x00;
	    *(pbIter++) = 0x00;
	    //		26:   50                      pushl  %eax 
	    *(pbIter++) = 0x50;
	    break;
	case iconst_3:
	    //	    21:   b8 00 00 00 00          movl   $0x0,%eax
	    *(pbIter++) = 0xb8;
	    *(pbIter++) = 0x03;
	    *(pbIter++) = 0x00;
	    *(pbIter++) = 0x00;
	    *(pbIter++) = 0x00;
	    //		26:   50                      pushl  %eax 
	    *(pbIter++) = 0x50;
	    break;
	case iconst_4:
	    //	    21:   b8 00 00 00 00          movl   $0x0,%eax
	    *(pbIter++) = 0xb8;
	    *(pbIter++) = 0x04;
	    *(pbIter++) = 0x00;
	    *(pbIter++) = 0x00;
	    *(pbIter++) = 0x00;
	    //		26:   50                      pushl  %eax 
	    *(pbIter++) = 0x50;
	  break;
	case iconst_5:
	    //	    21:   b8 00 00 00 00          movl   $0x0,%eax
	    *(pbIter++) = 0xb8;
	    *(pbIter++) = 0x05;
	    *(pbIter++) = 0x00;
	    *(pbIter++) = 0x00;
	    *(pbIter++) = 0x00;
	    //		26:   50                      pushl  %eax 
	    *(pbIter++) = 0x50;
	  break;
	    /* Load instructions 

	       These generally get the pointer to optop by calculating ebp + 0x8 and storing it in eax
	       Then we add 0,4,8,12 to eax and push [eax]

	     */
	case iload_0:
	case aload_0:
	    fprintf(stderr, "Generating aload_0\n");
	    *(pbIter++) = 0x8b;  // 3:   8b 45 08                movl   0x8(%ebp),%eax ; iload_0
	    *(pbIter++) = 0x45;
	    *(pbIter++) = 0x08;

	    //   b:   ff 30                   pushl  (%eax)
	    *(pbIter++) = 0xff;
	    *(pbIter++) = 0x30;
	break;
	case iload_1:
	case aload_1:
	    *(pbIter++) = 0x8b;  // 3:   8b 45 08                movl   0x8(%ebp),%eax ; iload_1
	    *(pbIter++) = 0x45;
	    *(pbIter++) = 0x08;

	    //   6:   05 04 00 00 00          addl   $0x4,%eax
	    *(pbIter++) = 0x05;
	    *(pbIter++) = 0x04;
	    *(pbIter++) = 0x00;
	    *(pbIter++) = 0x00;
	    *(pbIter++) = 0x00;

	    //   b:   ff 30                   pushl  (%eax)
	    *(pbIter++) = 0xff;
	    *(pbIter++) = 0x30;
	break;
	case iload_2:
	case aload_2:
	    //   d:   8b 45 08                movl   0x8(%ebp),%eax ; iload_2
	    *(pbIter++) = 0x8b;
	    *(pbIter++) = 0x45;
 	    *(pbIter++) = 0x08;
	    //   10:   05 08 00 00 00          addl   $0x8,%eax
	    *(pbIter++) = 0x05;
	    *(pbIter++) = 0x08;
	    *(pbIter++) = 0x00;
	    *(pbIter++) = 0x00;
	    *(pbIter++) = 0x00;

	    //   15:   ff 30                   pushl  (%eax)
	    *(pbIter++) = 0xff;
	    *(pbIter++) = 0x30;

	    break;
	case iload_3:
	case aload_3:
	    //   d:   8b 45 08                movl   0x8(%ebp),%eax ; iload_2
	    *(pbIter++) = 0x8b;
	    *(pbIter++) = 0x45;
 	    *(pbIter++) = 0x08;
	    //   10:   05 0c 00 00 00          addl   $0xc,%eax
	    *(pbIter++) = 0x05;
	    *(pbIter++) = 0x0c;
	    *(pbIter++) = 0x00;
	    *(pbIter++) = 0x00;
	    *(pbIter++) = 0x00;

	    //   15:   ff 30                   pushl  (%eax)
	    *(pbIter++) = 0xff;
	    *(pbIter++) = 0x30;

	    break;
	case iadd:
	    //   17:   59                      popl   %ecx ; iadd
	    (*pbIter++) = 0x59;
	    //   18:   5a                      popl   %edx
	    (*pbIter++) = 0x5a;
	    //   19:   01 ca                   addl   %ecx,%edx
    	    (*pbIter++) = 0x01;
	    (*pbIter++) = 0xca;


	    //Add a push here
	    //	    1b:   52                      pushl  %edx
    	    (*pbIter++) = 0x52;

	    /*
	    //   1b:   8b 45 08                movl   0x8(%ebp),%eax
	    (*pbIter++) = 0x8b;
	    (*pbIter++) = 0x45;
	    (*pbIter++) = 0x08;
	    //   1e:   89 10                   movl   %edx,(%eax)
	    (*pbIter++) = 0x89;
	    (*pbIter++) = 0x10;
	    */
	    break;

	case isub:
	    //   17:   59                      popl   %ecx ; iadd
	    (*pbIter++) = 0x59;
	    //   18:   5a                      popl   %edx
	    (*pbIter++) = 0x5a;

	    // 23:   29 ca                   subl   %ecx,%edx 
    	    (*pbIter++) = 0x29;
	    (*pbIter++) = 0xca;


	    //Add a push here
	    //	    1b:   52                      pushl  %edx
    	    (*pbIter++) = 0x52;

	    //   1b:   8b 45 08                movl   0x8(%ebp),%eax
	    (*pbIter++) = 0x8b;
	    (*pbIter++) = 0x45;
	    (*pbIter++) = 0x08;
	    //   1e:   89 10                   movl   %edx,(%eax)
	    (*pbIter++) = 0x89;
	    (*pbIter++) = 0x10;
	    break;

	    /* Store instructions 

	       These generally get the pointer to optop by calculating ebp + 0x8 and storing it in eax
	       Then we add 0,4,8,12 to eax 
	       We pop the stack into edx
	       and copy edx to [eax]

	     */

	case istore_0:
	case astore_0:
	    //  21:   8b 45 08                movl   0x8(%ebp),%eax  
	    *(pbIter++) = 0x8b;
	    *(pbIter++) = 0x45;
 	    *(pbIter++) = 0x08;
	    // 29:   5a                      popl   %edx
	    *(pbIter++) = 0x5a;
	    //    2a:   89 10                   movl   %edx,(%eax) 
	    *(pbIter++) = 0x89;
	    *(pbIter++) = 0x10;
	    break;
	case istore_1:
	case astore_1:
	    //  21:   8b 45 08                movl   0x8(%ebp),%eax  
	    *(pbIter++) = 0x8b;
	    *(pbIter++) = 0x45;
 	    *(pbIter++) = 0x08;
	    //	    24:   05 04 00 00 00          addl   $0x4,%eax  
	    *(pbIter++) = 0x05;
	    *(pbIter++) = 0x04;
	    *(pbIter++) = 0x00;
	    *(pbIter++) = 0x00;
	    *(pbIter++) = 0x00;
	    // 29:   5a                      popl   %edx
	    *(pbIter++) = 0x5a;
	    //    2a:   89 10                   movl   %edx,(%eax) 
	    *(pbIter++) = 0x89;
	    *(pbIter++) = 0x10;
	    break;
	case istore_2:
	case astore_2:
	    //  21:   8b 45 08                movl   0x8(%ebp),%eax  
	    *(pbIter++) = 0x8b;
	    *(pbIter++) = 0x45;
 	    *(pbIter++) = 0x08;
	    // 24:   05 08 00 00 00          addl   $0x8,%eax    
	    *(pbIter++) = 0x05;
	    *(pbIter++) = 0x08;
	    *(pbIter++) = 0x00;
	    *(pbIter++) = 0x00;
	    *(pbIter++) = 0x00;
	    // 29:   5a                      popl   %edx
	    *(pbIter++) = 0x5a;
	    //    2a:   89 10                   movl   %edx,(%eax) 
	    *(pbIter++) = 0x89;
	    *(pbIter++) = 0x10;
	    break;
	case istore_3:
	case astore_3:
	    //  21:   8b 45 08                movl   0x8(%ebp),%eax  
	    *(pbIter++) = 0x8b;
	    *(pbIter++) = 0x45;
 	    *(pbIter++) = 0x08;
	    // 24:   05 0c 00 00 00          addl   $0xc,%eax    
	    *(pbIter++) = 0x05;
	    *(pbIter++) = 0x0c;
	    *(pbIter++) = 0x00;
	    *(pbIter++) = 0x00;
	    *(pbIter++) = 0x00;
	    // 29:   5a                      popl   %edx
	    *(pbIter++) = 0x5a;
	    //    2a:   89 10                   movl   %edx,(%eax) 
	    *(pbIter++) = 0x89;
	    *(pbIter++) = 0x10;
	    break;
	case return_:

	    fprintf(stderr, "Generating return_ %x\n", (int) return_);
	    //	    6f:   b8 00 00 00 00          movl   $0x0,%eax 
	    *(pbIter++) = 0xb8;
	    *(pbIter++) = 0x00;
	    *(pbIter++) = 0x00;
	    *(pbIter++) = 0x00;
	    *(pbIter++) = 0x00;

	    gen_c_epilogue();

	    break;
	case ireturn:
	case areturn:
	    fprintf(stderr, "Generating ireturn %x or %x\n", (int) ireturn, (int) areturn);
	    //   18:   5a                      popl   %edx
	    (*pbIter++) = 0x5a;

	    //   1b:   8b 45 08                movl   0x8(%ebp),%eax
	    (*pbIter++) = 0x8b;
	    (*pbIter++) = 0x45;
	    (*pbIter++) = 0x08;
	    //   1e:   89 10                   movl   %edx,(%eax)
	    (*pbIter++) = 0x89;
	    (*pbIter++) = 0x10;


	    //	    6f:   b8 00 00 00 00          movl   $0x0,%eax 
	    *(pbIter++) = 0xb8;
	    *(pbIter++) = 0x00;
	    *(pbIter++) = 0x00;
	    *(pbIter++) = 0x00;
	    *(pbIter++) = 0x00;

	    gen_c_epilogue();


	    break;
	default:
	    fprintf(stderr, "Unknown instruction %x in gen_bytecode_instruction\n", code);
	    break;
	}
    return pbIter;
}


void* gen_c_istore(byte* pbCode, byte* pbIter)
{
	    //  21:   8b 45 08                movl   0x8(%ebp),%eax  
	    *(pbIter++) = 0x8b;
	    *(pbIter++) = 0x45;
 	    *(pbIter++) = 0x08;

	    //We don't add 0xc instead *pbCode + 1
	    // 24:   05 0c 00 00 00          addl   $0xc,%eax    
	    *(pbIter++) = 0x05;
	    *(pbIter++) = *(pbCode + 1);
	    *(pbIter++) = 0x00;
	    *(pbIter++) = 0x00;
	    *(pbIter++) = 0x00;
	    // 29:   5a                      popl   %edx
	    *(pbIter++) = 0x5a;
	    //    2a:   89 10                   movl   %edx,(%eax) 
	    *(pbIter++) = 0x89;
	    *(pbIter++) = 0x10;


	    return pbIter;
}

void* gen_c_iload(byte* pbCode, byte* pbIter)
{
	    //  21:   8b 45 08                movl   0x8(%ebp),%eax  
	    *(pbIter++) = 0x8b;
	    *(pbIter++) = 0x45;
 	    *(pbIter++) = 0x08;

	    //We don't add 0xc instead *pbCode + 1
	    // 24:   05 0c 00 00 00          addl   $0xc,%eax    
	    *(pbIter++) = 0x05;
	    *(pbIter++) = *(pbCode + 1);
	    *(pbIter++) = 0x00;
	    *(pbIter++) = 0x00;
	    *(pbIter++) = 0x00;

	    //   15:   ff 30                   pushl  (%eax)
	    *(pbIter++) = 0xff;
	    *(pbIter++) = 0x30;


	    return pbIter;
}


void* SVETLANA_createOptimisedMethod(tMethod* pstMethod, byte* pCode, int length) {

 
    int i = 0;
    byte* asmCode = (byte*) malloc( length * max_ass_instructions_per_opcode * 4);
    byte* pbIter = asmCode;

    tList* pstListLabels = LLIST_Create_List();
    jumplabel* label;

    //We allocate the maximum amount of bytes that we might consume
    assert(asmCode);

    assert(pstListLabels);

    fprintf(stderr, "Generating code for method %s\n", pstMethod->uidName);

    //Now generate the C prologue
    gen_c_prologue();

    //Now for each instruction
    for( i = 0; i < length;i++)
	{

#ifdef DEBUG_BRANCHES
	    fprintf(stderr, "Instruction %i at %x\n", i, (byte*) pbIter - (byte*) asmCode);
#endif

	    if(pstListLabels->count)
		{
		    tListIterator* iterator = LLIST_FindFirst(pstListLabels);

		    while(iterator != NULL)
			{
			    label = iterator->entry->payload; 
#ifdef DEBUG_BRANCHES
		    fprintf(stderr, "list count is %i, branch to %i, at %i\n", pstListLabels->count, label->java_instruction, i);
#endif
		    if(label->java_instruction == i)
			{
		    fprintf(stderr, "We are jumping from %x\n", (byte*) label->address - (byte*) asmCode);
		    fprintf(stderr, "We are jumping to   %x\n", (byte*) pbIter - (byte*) asmCode);
			    //We probably have to adjust this by two to account for the actual jne instructions
			    *((int32*) label->patch_location) = ((byte*) pbIter) - ((byte*) label->address);
			    fprintf(stderr, "Generated jump of %i bytes, from %x to %x\n",  *((int32*) label->patch_location),  (int32*) label->patch_location, (int32*) pbIter);
		           iterator = LLIST_FindNext(pstListLabels, iterator);
			    LLIST_Remove(pstListLabels, label);
			    free(label);
			}
		    else
		           iterator = LLIST_FindNext(pstListLabels, iterator);


			}
		}

	    if(pCode[i] == getfield_quick)
		{
		    //		   pbIter = gen_c_call_getfield_quick_ver3(pCode + i, pbIter);
		    		    pbIter =  gen_c_call_getfield_quick(pCode + i,  pbIter);
		    //void* gen_c_call_getfield_quick(byte* pbCode, byte* pbIter)
		   i++; i++; //Skip over fields
		}
	    else if((pCode[i] == ifeq) || (pCode[i] == ifnull))
		{
		pbIter = gen_c_ifeq(pCode + i, i, pbIter, pstListLabels);
		i++; i++; //Skip word index
		}
	    else if(pCode[i] == iflt)
		{
		    fprintf(stderr, "Generating lt jump\n");
		pbIter = gen_c_iflt(pCode + i, i, pbIter, pstListLabels);
		i++; i++; //Skip word index
		}
	    else if(pCode[i] == ifge)
		{
		pbIter = gen_c_ifge(pCode + i, i, pbIter, pstListLabels);
		i++; i++; //Skip word index
		}
	    else if(pCode[i] == ifgt)
		{
		pbIter = gen_c_ifgt(pCode + i, i, pbIter, pstListLabels);
		i++; i++; //Skip word index
		}
	    else if(pCode[i] == ifle)
		{
		pbIter = gen_c_ifle(pCode + i, i, pbIter, pstListLabels);
		i++; i++; //Skip word index
		}
	    else if((pCode[i] == ifne) || (pCode[i] == ifnonnull))
		{
		pbIter = gen_c_ifne(pCode + i, i, pbIter, pstListLabels);
		i++; i++; //Skip word index
		}
	    else if(pCode[i] == goto_)
		{
		pbIter = gen_c_goto(pCode + i, i, pbIter, pstListLabels);
		i++; i++; //Skip word index
		}
	    else if(pCode[i] == arraylength)
	      {
		pbIter = gen_c_call_arraylength(pCode + i, pbIter);
	      }
	    else if((pCode[i] == istore) || (pCode[i] == astore))
	      {
		pbIter = gen_c_istore(pCode + i, pbIter);
		   i++; //Skip over field
	      }
	    else if((pCode[i] == iload) || (pCode[i] == aload))
	      {
		pbIter = gen_c_iload(pCode + i, pbIter);
		   i++; //Skip over field
	      }
	    else if(pCode[i] == iastore)
	      {
		pbIter = gen_c_call_iastore(pCode + i, pbIter);
	      }
	    else if(pCode[i] == iaload)
	      {
		pbIter = gen_c_call_iaload(pCode + i, pbIter);
	      }
	    else
		{
		  //		    fprintf(stderr, "Genning instruction %i\n", pCode[i]);
		pbIter = gen_bytecode_instruction(pCode[i], pbIter);
		}
	}

    fprintf(stderr, "Epilogue is at %x\n", pbIter);
    //Now generate the C epilogue
    //    gen_c_epilogue();

    LLIST_DestroyList(pstListLabels);

    //Cool now we've got executable code
    fprintf(stderr, "Returning method at %x %i, used %i asm bytes \n", asmCode, length, pbIter - asmCode ); 


    return asmCode;
   }
