#include <config.h>
#include "svetlana.h"
#include "../interp.h"
#include "../jni.h"
#include "../lib/indigenous/java.lang/Class_Reflection.h"
#include "../newobject.h"
#include <stdio.h>
#include <assert.h>

jarray Java_kissme_code_generator_BuildGenerator_getBytecodeForMethod( JNIEnv* env, jclass arbclass, jclass clazz, jobject methodObject)
{
    //		jmethodID methodID = (*env)->GetMethodID(env, clazz, "compileMethod", "([BIILjava/lang/String;Z)[B");

    tARREF pstArrayTemp;

    tClassLoaderTuple* class = CLASS_GetClassStruct( clazz) ; 
    jclass methodClass;
    jfieldID fieldID;
    tMethod* method;
    jclass ret;

    (*env)->FindClass( env, class->uidName);
    methodClass = ODEREF(methodObject)->pstType->classObject;
    assert(methodClass);
    fieldID = (*env)->GetFieldID(env, methodClass, "slot", "I");
    assert(fieldID);
    method = &class->pstClass->pstMethods[(*env)->GetIntField(env, methodObject, fieldID)];
    assert(method);
    {
	int length = method->pstCode->u32CodeLength;
	int i;

	pstArrayTemp = INTERP_NewArray(env, T_BYTE, length, NULL, NULL);
	(*env)->NewGlobalRef(env, pstArrayTemp) ;

		for(i = 0; i < length;i++)
		    {
			((byte*) ADEREF(pstArrayTemp)->pvElements)[i] = method->pstCode->pbCode[i];
		    }

	return pstArrayTemp;
    }
}


//    private native static int[] getNativeExceptionTable(Class c, Method m);
//    private native static Class coerceToClass( int t );

//1
jarray Java_getNativeExceptionTable( JNIEnv* env, jclass arbclass, jclass clazz, jobject methodObject)
{
    tARREF pstArrayTemp;

    tClassLoaderTuple* class = CLASS_GetClassStruct( clazz) ; 
    tClassLoaderTuple* classp;
    jclass methodClass;
    jfieldID fieldID;
    tMethod* method;
    jclass ret;

    (*env)->FindClass( env, class->uidName);
    methodClass = ODEREF(methodObject)->pstType->classObject;
    assert(methodClass);
    fieldID = (*env)->GetFieldID(env, methodClass, "slot", "I");
    assert(fieldID);
    method = &class->pstClass->pstMethods[(*env)->GetIntField(env, methodObject, fieldID)];
    assert(method);

    {
	int i;	
	int length = method->pstCode->u16ExceptionTableLength * 4;
	pstArrayTemp = INTERP_NewArray(env, T_INT, length, NULL, NULL);
	(*env)->NewGlobalRef(env, pstArrayTemp);
	for(i = 0; i < length / 4;i++)
	    {
		((int*) ADEREF(pstArrayTemp)->pvElements)[ i * 4 ] = method->pstCode->pstExceptionTable[ i / 4 ].u16StartPC;
		((int*) ADEREF(pstArrayTemp)->pvElements)[ i * 4 + 1 ] = method->pstCode->pstExceptionTable[ i / 4 ].u16EndPC;
		((int*) ADEREF(pstArrayTemp)->pvElements)[ i * 4 + 2 ] = method->pstCode->pstExceptionTable[ i / 4 ].u16HandlerPC;
		classp = method->pstCode->pstExceptionTable[ i / 4 ].pstCatchType;
		(*env)->FindClass(env, classp->uidName);
		((int*) ADEREF(pstArrayTemp)->pvElements)[ i * 4 + 3 ] = (int) classp->classObject;
	    }
	return pstArrayTemp;
    }
}


//2
jobject Java_coerceToClass( JNIEnv* env, jclass arbclass, int ptr)
{
    return (jobject) ptr; //Don't you just love C? 
}

//3
int Java_getInternalClassStruct( JNIEnv* env, jclass arbclass, jclass clazz)
{
    return (int) CLASS_GetClassStruct(clazz);
}
