/*
 * @doc TYPE
 * @struct
 * This structure contains all the information that needs to be stored
 * about classes.
 *
 */

struct tclass
{
  #ifdef PERSIST
  PID persIndex;               /* @field PID of this class's string in persistent store */
  #endif
#ifdef DEBUG_CLASS_FOR_GC
  int magic1;
#endif
//now in tuple
//  Uid uidName;                 /* @field Pointer to class's name */
  uint16 u16MajorVersion;      /* @field Major version of compiler used */
  uint16 u16MinorVersion;      /* @field Minor version of compiler used */
  uint16 u16ConstPoolCount;    /* @field Number of items in const pool */
  uint16 u16ConstPoolRealCount;/* @field Number of actual slots in const pool (because longs and doubles use up two slots each. */
  uint32* pu32ConstPool;       /* @field Pointer to constant pool data */
  byte* pbConstTags;           /* @field Pointer to array of const pool tags */

//Changes to Tuple
  tClassLoaderTuple* pstSuperClass;       /* @field Pointer to the class's superclass */

  uint16 u16AccessFlags;       /* @field The class's access flags */
  uint16 u16InterfacesCount;   /* @field Number of interfaces the class implements */

  tClassLoaderTuple** ppstInterfaces;     /* @field Array of pointers to the interface classes that this class implements */

  tMethod* pstMethods;         /* @field Array of class's methods */

  uint16 u16MethodsCount;      /* @field Number of methods in class */
  uint16 u16SourceFile;        /* @field Index of name of source file in constant pool */

#ifdef DEBUG_CLASS_FOR_GC
  int magic2;
#endif

  uint16 u16InstCount;         /* @field Number of instance fields */
  uint16 u16InstSize;          /* @field Number of 32-bit slots needed for instance fields */
  tField* pstInstOffsets;      /* @field Array of information structures for instance fields */

  
  uint16 u16StatCount;         /* @field Number of static fields */
  uint16 u16StatSize;          /* @field Number of 32-bit slots needed for static fields */


  tField* pstStatOffsets;      /* @field Array of information structures for static fields */
//Removed and moved into tClassLoaderTuple
//  int32* pi32StatVars;         /* @field Pointer to space for static fields */

  uint16 u16VTSize;            /* @field Size of virtual table */
  uint16 u16NumNatives;        /* @field The number of native methods in this class */

  tMethod** ppstVT;            /* @field Virtual table of method pointers */

  #ifdef QUICK2
  uint16 u16CTSize;            /* @field Size of class table */
  tClass** ppstCT;             /* @field Class table of class pointers */
  #endif

// Removed and put in tClassLoaderTuple
//  struct tobject** pstClassObject; /* @field The Class object that represents this class, NULL if none has been created */
  JNINativeMethod* pstNativeMethods; /* @field Pointer to native method table */

  byte bInitialised;           /* @field Remember if this class is initialised */
#ifdef DEBUG_CLASS_FOR_GC
  int magic3;
#endif
};

