/* struct for arrays *******************************************************/

/*
 * @doc TYPE
 * @struct
 * This structure keeps information used for the internal representation
 * of arrays.  It stores the number of elements, the type of the elements
 * and a pointer to memory to use to store the elements.
 *
 */

#include "wrappers.h"

struct tarray
{
  #ifdef GARBAGE
  /* this must always be the first field of this structure */
  int32   i32Flags;    /* @field Used for type and marking in garbage collection */
  #endif
#ifdef DEBUG_OBJECT_FOR_GC
  int32 magic1;
#endif
#ifdef IBM_LOCKS
 int32 lock_word;
#endif
  #ifdef PERSIST
  #ifndef REVRPOT
  PID    pid;
  #endif
  #endif
  tCondVariable* condVariable;
#ifdef IN_PLACE_CONDITION
  tCondVariable actualCondVariable;
#endif
  struct tobject** hHandle; /* @field Pointer to this object's handle so that it can be updated if it moves */
//was tClass*
  tClassLoaderTuple* pstType;     /* @field Pointer to the class that this object is an instance of */
  int32* pi32Vars;     /* @field Pointer to memory for instance variables */
  /* ^^^^ up to here must always be the same as in tobject */

  int32   i32Number;  /* @field Number of elements in the array */
  tAType  enType;     /* @field Type of the elements */
  void*   pvElements; /* @field Pointer to space for the elements to be stored */
};
