/*
#ifdef STACKMAP
struct tstackmap 
{
  int i32NumEntries;
  byte* data;
};
#endif 
*/

  #ifdef STACKMAP
   struct tstackmap* pstStackMap;
  #endif


/* Structure to represent the stack map at each point of a method's execution 
 *
 * The format is an integer containing the number of entries. We are basically storing a table:
 *
 * Instruction range			Map
 *
 *    0 - 1				
 *    2 - 5				I
 *    6 - 7				III
 *    etc
 *
 *  The number of entries is the number of rows in this table.
 *
 *  Then we encode each instruction range as a byte, with the high bit set to 0.
 *  The Map is encoded with the following 2-bit values:
 *
 *	00 - End of sequence
 *	01 - Literal value on stack
 *	10 - Address on stack
 *	11 - Unused
 *
 *  It is just a repetition of 01, 10 values until ended by 00. 
 *
 *  The information for the next row follows directly in the bit stream.
 *
 *  If the range of instructions is greater than 128, we use an integer with the high bit set to 1
 *
 */

