

struct tstackmap* generateStackMap(byte* pbCode, int* retLength, int numBytes, tMethod* pstMethod, tClass* pstClass);
void STACKMAP_printTable();
void STACKMAP_printStackOp(FILE* stream, int op);


int STACKMAP_handleMethod( int insNumber, char** mapInsToMap, int prevLen, int ins, unsigned int b1, unsigned int b2, tMethod* pstMethod, tClass* pstClass);

#define STACKOP_PushVal  0x600
#define STACKOP_PopVal  0x601
#define STACKOP_Push2Val 0x602
#define STACKOP_Pop2Val 0x603


#define STACKOP_PushAddress 0x604
#define STACKOP_PopAddress 0x605
#define STACKOP_Push2Address 0x606
#define STACKOP_Pop2Address 0x607

#define STACKOP_NoOp 0x608

#define STACKOP_PopUndef 0x609
#define STACKOP_Pop2Undef 0x60a
#define STACKOP_PushUndef 0x60b
#define STACKOP_Push2Undef 0x60c
#define STACKOP_Swap 0x60d

#define STACKOP_Method 0x60e
#define STACKOP_PopAddressPushUndef 0x60f
#define STACKOP_Getfield 0x610

#define STACKOP_ArrayLoadAndPushAddress 0x611
#define STACKOP_ArrayLoadAndPushVal 0x612
#define STACKOP_ArrayLoadAndPush2Val 0x613

#define STACKOP_PushDup 0x614
#define STACKOP_Getstatic 0x615

#define STACKOP_PopAddressAndArrayStore 0x616
#define STACKOP_PopValAndArrayStore 0x617
#define STACKOP_Pop2ValAndArrayStore 0x618

#define STACKOP_PopValPushAddress 0x619
#define STACKOP_PopAddressPushVal 0x61a

#define STACKOP_Ldc1 0x61b
#define STACKOP_Ldc2 0x61c

#define STACKOP_Pop3Val 0x61d

/* We build up the map using a table containing info for each bytecode
 *
 * 
 *
 *
 *
 *
 *
 *
 *
 */

struct byteCodeInfo {

//Most instructions just cause execution to continue to the next one. Control instructions may cause a jump.

  int controlInstruction; 

//Each instruction may modify the stack, eg POPPING a value, PUSHING an address etc
  int stackChange;

//Some instructions have extra bytes that we need to skip 
  int extraBytes; 
  
};

#ifdef __STACKMAP_TABLE__

struct byteCodeInfo infoTable[] = 
{
  //nop
  {0, STACKOP_NoOp, 0}, 
  /* pushing constants 

  aconst_null,
  iconst_m1,*/

  {0, STACKOP_PushAddress, 0},
  {0, STACKOP_PushVal, 0},

  /*
  iconst_0,
  iconst_1,
  iconst_2,
  iconst_3,
  iconst_4,
  iconst_5, */


  {0, STACKOP_PushVal, 0},
  {0, STACKOP_PushVal, 0},
  {0, STACKOP_PushVal, 0},
  {0, STACKOP_PushVal, 0},
  {0, STACKOP_PushVal, 0},
  {0, STACKOP_PushVal, 0},


  /*
  lconst_0,
  lconst_1,  // 10 */

  {0, STACKOP_Push2Val, 0}, //
  {0, STACKOP_Push2Val, 0}, //10

  /*
  fconst_0,
  fconst_1,
  fconst_2,

  */

  {0, STACKOP_PushVal, 0},
  {0, STACKOP_PushVal, 0},
  {0, STACKOP_PushVal, 0},

  /*
  dconst_0,
  dconst_1, */

  {0, STACKOP_Push2Val, 0},
  {0, STACKOP_Push2Val, 0},

  /*
  bipush,
  sipush,
  */

  {0, STACKOP_PushVal, 1}, //bipush
  {0, STACKOP_PushVal, 2}, //sipush

  /*  ldc1,
  ldc2,
  ldc2w,     20 */
  {0, STACKOP_Ldc1, 1}, 
  {0, STACKOP_Ldc2, 2}, 
  {0, STACKOP_Push2Val, 2}, 

  /* loading local variables 

  iload,
  lload,
  fload,
  dload,
  aload, */

  {0, STACKOP_PushVal, 1}, 
  {0, STACKOP_Push2Val, 2},
  {0, STACKOP_PushVal, 1}, 
  {0, STACKOP_Push2Val, 2},
  {0, STACKOP_PushAddress, 1}, 

  /*
  iload_0,
  iload_1,
  iload_2,
  iload_3,
  lload_0,   30
  lload_1,
  lload_2,
  lload_3,
  fload_0,
  fload_1,
  fload_2,
  fload_3,
  dload_0,
  dload_1,
  dload_2,   40 
  dload_3 */


//iload_0
  {0, STACKOP_PushVal, 0}, 
  {0, STACKOP_PushVal, 0}, 
  {0, STACKOP_PushVal, 0}, 
  {0, STACKOP_PushVal, 0}, 
//lload_0
  {0, STACKOP_Push2Val, 0}, 
  {0, STACKOP_Push2Val, 0}, 
  {0, STACKOP_Push2Val, 0}, 
  {0, STACKOP_Push2Val, 0}, 
//fload_0
  {0, STACKOP_PushVal, 0}, 
  {0, STACKOP_PushVal, 0}, 
  {0, STACKOP_PushVal, 0}, 
  {0, STACKOP_PushVal, 0}, 
//dload_0
  {0, STACKOP_Push2Val, 0}, 
  {0, STACKOP_Push2Val, 0}, 
  {0, STACKOP_Push2Val, 0}, 
  {0, STACKOP_Push2Val, 0}, 
//aload_0
  {0, STACKOP_PushAddress, 0}, 
  {0, STACKOP_PushAddress, 0}, 
  {0, STACKOP_PushAddress, 0}, 
  {0, STACKOP_PushAddress, 0},

  /* loading array elements 

  iaload,
  laload,
  faload, */

//Do these with a code for STACKOP_ArrayLoadAndPushAddress and STACKOP_ArrayLoadAndPushVal

  {0, STACKOP_ArrayLoadAndPushVal, 0},
  {0, STACKOP_ArrayLoadAndPush2Val, 0},
  {0, STACKOP_ArrayLoadAndPushVal, 0},

  /*
  daload,
  aaload,     50 
  baload,
  */
  {0, STACKOP_ArrayLoadAndPush2Val, 0},
  {0, STACKOP_ArrayLoadAndPushAddress, 0},
  {0, STACKOP_ArrayLoadAndPushVal, 0},
  /*
  caload,
  saload,
  */

  {0, STACKOP_ArrayLoadAndPushVal, 0},
  {0, STACKOP_ArrayLoadAndPushVal, 0},

  /* storing to local variables 
  istore,
  lstore,
  fstore,
  dstore,
  astore,
  istore_0,
  istore_1,   60 
  istore_2,
  istore_3,
  lstore_0,
  lstore_1,
  lstore_2,
  lstore_3, */

  {0, STACKOP_PopVal, 1},
  {0, STACKOP_Pop2Val, 1},
  {0, STACKOP_PopVal, 1},
  {0, STACKOP_Pop2Val, 1},
  {0, STACKOP_PopAddress, 1},

//istore_0
  {0, STACKOP_PopVal, 0},
  {0, STACKOP_PopVal, 0},
  {0, STACKOP_PopVal, 0},
  {0, STACKOP_PopVal, 0},
//lstore_0
  {0, STACKOP_Pop2Val, 0},
  {0, STACKOP_Pop2Val, 0},
  {0, STACKOP_Pop2Val, 0},
  {0, STACKOP_Pop2Val, 0},

  /*  fstore_0,
  fstore_1,
  fstore_2,
  fstore_3,   70 
  dstore_0,
  dstore_1,
  dstore_2,
  dstore_3,
  */

  {0, STACKOP_PopVal, 0},
  {0, STACKOP_PopVal, 0},
  {0, STACKOP_PopVal, 0},
  {0, STACKOP_PopVal, 0},
//dstore
  {0, STACKOP_Pop2Val, 0},
  {0, STACKOP_Pop2Val, 0},
  {0, STACKOP_Pop2Val, 0},
  {0, STACKOP_Pop2Val, 0},
  /*
  astore_0,
  astore_1,
  astore_2,
  astore_3,*/

  {0, STACKOP_PopAddress, 0},
  {0, STACKOP_PopAddress, 0},
  {0, STACKOP_PopAddress, 0},
  {0, STACKOP_PopAddress, 0},

  /* storing to array elements 

  iastore,
  lastore,    80 
  fastore,
  dastore, */

  {0, STACKOP_PopValAndArrayStore, 0},
  {0, STACKOP_Pop2ValAndArrayStore, 0},
  {0, STACKOP_PopValAndArrayStore, 0},
  {0, STACKOP_Pop2ValAndArrayStore, 0},

  /*
  aastore,
  bastore,
  castore,
  sastore, */

  {0, STACKOP_PopAddressAndArrayStore, 0},
  {0, STACKOP_PopValAndArrayStore, 0},
  {0, STACKOP_PopValAndArrayStore, 0},
  {0, STACKOP_PopValAndArrayStore, 0},

  /* stack instructions 

  pop,
  pop2,
  dup_,
  dup_x1,    90 
  dup_x2,
  dup2_,
  dup2_x1,
  dup2_x2,
  swap,*/

//pop, pop2
  {0, STACKOP_PopUndef, 0},
  {0, STACKOP_Pop2Undef, 0},

//dup_
  {0, STACKOP_PushDup, 0},
  {0, STACKOP_PushDup, 0},
  {0, STACKOP_PushDup, 0},
//dup2_
  {0, STACKOP_Push2Undef, 0},
  {0, STACKOP_Push2Undef, 0},
  {0, STACKOP_Push2Undef, 0},
//swap
  {0, STACKOP_Swap, 0},

  /* arithmetic instructions 

  iadd,
  ladd,
  fadd,
  dadd,
  isub,       100 
  lsub,
  fsub,
  dsub,*/

  {0, STACKOP_PopVal, 0},
  {0, STACKOP_Pop2Val, 0},
  {0, STACKOP_PopVal, 0},
  {0, STACKOP_Pop2Val, 0},
  {0, STACKOP_PopVal, 0},
  {0, STACKOP_Pop2Val, 0},
  {0, STACKOP_PopVal, 0},
  {0, STACKOP_Pop2Val, 0},

  /*
  imul,
  lmul,
  fmul,
  dmul,
  idiv,
  ldiv_,
  fdiv,      110 
  ddiv,*/

  {0, STACKOP_PopVal, 0},
  {0, STACKOP_Pop2Val, 0},
  {0, STACKOP_PopVal, 0},
  {0, STACKOP_Pop2Val, 0},

  {0, STACKOP_PopVal, 0},
  {0, STACKOP_Pop2Val, 0},
  {0, STACKOP_PopVal, 0},
  {0, STACKOP_Pop2Val, 0},

  /*
  imod,
  lmod,
  fmod_,
  dmod,
  ineg,
  lneg,
  fneg,
  dneg,*/

  {0, STACKOP_PopVal, 0},
  {0, STACKOP_Pop2Val, 0},
  {0, STACKOP_PopVal, 0},
  {0, STACKOP_Pop2Val, 0},

  {0, STACKOP_NoOp, 0},
  {0, STACKOP_NoOp, 0},
  {0, STACKOP_NoOp, 0},
  {0, STACKOP_NoOp, 0},

  /* logical instructions 

  ishl,      120 
  lshl,
  ishr,
  lshr, */

  {0, STACKOP_NoOp, 0},
  {0, STACKOP_NoOp, 0},
  {0, STACKOP_NoOp, 0},
  {0, STACKOP_NoOp, 0},

  /*
  iushr,
  lushr, */

  {0, STACKOP_NoOp, 0},
  {0, STACKOP_NoOp, 0},

  /*
  iand,
  land,
  ior,
  lor,
  ixor,       130 
  lxor,*/





//iand
  {0, STACKOP_PopVal, 0},
  {0, STACKOP_Pop2Val, 0},

//ior
  {0, STACKOP_PopVal, 0},
  {0, STACKOP_Pop2Val, 0},

//ixor
  {0, STACKOP_PopVal, 0},
  {0, STACKOP_Pop2Val, 0},

  /* increment 

  iinc,*/
  {0, STACKOP_NoOp, 2}, //it has 2 extra bytes

  /* conversion operations 

  i2l,       // 133 
  i2f,       // 134 
  */

  {0, STACKOP_PushVal, 0},
  {0, STACKOP_NoOp, 0}, //No change

  /*
  i2d,       // 135 
  l2i,
  l2f,
  l2d,
  */

  {0, STACKOP_PushVal, 0},
  {0, STACKOP_PopVal, 0},
  {0, STACKOP_PopVal, 0},
  {0, STACKOP_NoOp, 0},

  /*
  f2i,
  f2l,       // 140 
  f2d,
  d2i,
  d2l,
  d2f,*/
  {0, STACKOP_NoOp, 0},
  {0, STACKOP_PushVal, 0},
  {0, STACKOP_PushVal, 0},
  {0, STACKOP_PopVal, 0},
  {0, STACKOP_NoOp, 0},
  {0, STACKOP_PopVal, 0},
  /*
  int2byte,
  int2char,
  int2short,*/
  {0, STACKOP_NoOp, 0},
  {0, STACKOP_NoOp, 0},
  {0, STACKOP_NoOp, 0},

  /* comparison instructions 

  lcmp,
  fcmpl,
  fcmpg,     150 
  dcmpl,
  dcmpg,*/

  {0, STACKOP_Pop3Val, 0},
  {0, STACKOP_PopVal, 0},
  {0, STACKOP_PopVal, 0},
  {0, STACKOP_Pop3Val, 0},
  {0, STACKOP_Pop3Val, 0},


  /* branch instructions 

  ifeq,
  ifne,
  iflt,
  ifge,
  ifgt,
  ifle,*/

//These are control instructions
  {1, STACKOP_PopVal, 2},
  {1, STACKOP_PopVal, 2},
  {1, STACKOP_PopVal, 2},
  {1, STACKOP_PopVal, 2},
  {1, STACKOP_PopVal, 2},
  {1, STACKOP_PopVal, 2},

  /*
  if_icmpeq,
  if_icmpne,  160 
  if_icmplt,
  if_icmpge,
  if_icmpgt,
  if_icmple,
  if_acmpeq,
  if_acmpne,*/


  {1, STACKOP_Pop2Val, 2},
  {1, STACKOP_Pop2Val, 2},
  {1, STACKOP_Pop2Val, 2},
  {1, STACKOP_Pop2Val, 2},
  {1, STACKOP_Pop2Val, 2},
  {1, STACKOP_Pop2Val, 2},
  {1, STACKOP_Pop2Address, 2},
  {1, STACKOP_Pop2Address, 2},

  /*  goto_,
  jsr,
  ret,*/

  {1, STACKOP_NoOp, 2},
  {0,0,0},
  {0,0,0},

  /* table jumping 

  tableswitch, // 170 
  lookupswitch, */

  {1,STACKOP_PopVal,1000}, //special value indicating that we should examine
  //the actual bytes following the instruction
  {0,0,0},

  /* function return 

  ireturn,
  lreturn,
  freturn,
  dreturn,
  areturn,
  return_,
*/

  {1,STACKOP_NoOp,0},
  {1,STACKOP_NoOp,0},
  {1,STACKOP_NoOp,0},
  {1,STACKOP_NoOp,0},
  {1,STACKOP_NoOp,0},
  {1,STACKOP_NoOp,0},

  /* manipulating object fields 

  getstatic,
  putstatic,
  getfield,  180 
  putfield,*/

  {0,STACKOP_Getstatic,2},
  {0,STACKOP_PopUndef,2},
//  {0,STACKOP_PopAddressPushUndef,2},
  {0,STACKOP_Getfield,2},
  {0,STACKOP_PopUndef,2},


  /* method invocation 

  invokevirtual,
  invokespecial,  // was nonvirtual,
  invokestatic,
  invokeinterface,*/

  {0,STACKOP_Method,2},
  {0,STACKOP_Method,2},
  {0,STACKOP_Method,2},
  {0,STACKOP_Method,2},

  /* miscellaneous object operations 

  newfromname,
  new_,
  newarray, //188
  anewarray, //189
  */
  {0,STACKOP_NoOp,0}, //Pops a string and pushes the new object
  {0,STACKOP_PushAddress,2},
  {0,STACKOP_PopValPushAddress, 1},
  {0,STACKOP_PopValPushAddress, 2},
  /*
  arraylength,  190 
  athrow,
  checkcast,
  instanceof,
  */

  {0,STACKOP_PopAddressPushVal,0},
  {0,STACKOP_NoOp,0}, //the exception is on the stack, are we popping it? Not really
  {0,STACKOP_NoOp,2}, //I don't think it actually pops it
  {0,STACKOP_PopAddressPushVal,2},
  // monitors 
  /*
  monitorenter,
  monitorexit,

  // debugging 

  verifystack,
// more arrays

  multianewarray,
  */
  {0,0,0},
  {0,0,0},
  {0,0,0},
  {0,0,0},

  /*
  // undocumented java class stuff 
  ifnull,
  ifnonnull,
  */

  {1,STACKOP_PopAddress,2},
  {1,STACKOP_PopAddress,2},

  /*
  // optimisations 
  ldc1_quick, 200
  ldc2_quick,
  ldc2w_quick,
  */

  {0,0,0},
  {0,0,0},
  {0,0,0},
  /*
  getfield_quick,
  putfield_quick,
  getfield2_quick,
  putfield2_quick,*/
  {0,STACKOP_PushUndef,2},
  {0,STACKOP_PopUndef,2},
  {0,STACKOP_PushUndef,2},
  {0,STACKOP_PopUndef,2},

  /* These are short-cuts when the current class is not the same as the static field's class 
  getstatic_quick,
  putstatic_quick,
  getstatic2_quick,
  putstatic2_quick,   210 */
  {0,0,0},
  {0,0,0},
  {0,0,0},
  {0,0,0},
  /*
  invokevirtual_quick,
  invokespecial_quick, was nonvirtual 
  invokestatic_quick,
  invokeinterface_quick,
  invokevirtualobject_quick, 215     ???? I can't understand this !!!! 
*/
  {0,STACKOP_Method,2},
  {0,STACKOP_Method,2},
  {0,STACKOP_Method,2},
  {0,STACKOP_Method,2},
  {0,STACKOP_Method,2},

  /*
  new_quick, 216
  anewarray_quick,
  checkcast_quick,
  instanceof_quick,
  */
  {0,STACKOP_PushAddress,2},
  {0,STACKOP_PushAddress,1},
  {0,STACKOP_NoOp,2},
  {0,STACKOP_PopAddressPushVal,2},

  /* shortcuts for when the current class is the same as the static field's
     class
  putstaticcurrclass_quick,  220 
  putstatic2currclass_quick,
  getstaticcurrclass_quick,
  getstatic2currclass_quick,
  */
  {0,0,0},
  {0,0,0},
  {0,0,0},
  {0,0,0},
  /*
  invokenonvirtualcurrclass_quick,
  invokestaticcurrclass_quick,
  */
  {0,0,0},
  {0,0,0},

  /* used for preloaded classes in ROM because we can't overwrite the operand
     with a guess 
  invokeinterface_noguess,  226 

   Special instructions to invoke optimised methods 
  invokevirtual_quick_optimised
*/
  {0,0,0},
  {0,0,0},
};

#endif
