#include <config.h>

#ifdef STACKMAP

#include <stdlib.h>
#include <stdio.h>
#include <assert.h>
#include <string.h>
#include "../interp.h"
#include "../disass.h"
#include "../sys_linux_host/wrappers.h"
#include "mapencoder.h"
#include "../opcodes.h"


#define __STACKMAP_TABLE__


#include "stackmap.h"


int init_histogram = 0;

struct tstackmap* generateStackMap(byte* pbCode, int* retLength, int numBytes, tMethod* pstMethod, tClass* pstClass) {

  char** mapInsToMap;
  char* currentMap;
  int i = 0;

  if(init_histogram == 0) {
    buildHistogram();
    init_histogram = 1;
  }

  currentMap = NULL;
  mapInsToMap = sys_malloc( numBytes * sizeof(char*));
  assert(mapInsToMap);

  for(i = 0; i < numBytes; i++) {
    
    if( ((unsigned char) pbCode[i]) > 226) {
      fprintf(stderr, "Invalid instruction %i in generateStackMap %s (at %i)\n", (unsigned char) pbCode[i], pstMethod->uidName, i);
      return NULL;
    }

    if( infoTable[((unsigned char) pbCode[i])].stackChange == 0) {
      fprintf(stderr, "Empty entry in infoTable for instruction %i in generateStackMap %s (at %i)\n", (unsigned char) pbCode[i], pstMethod->uidName, i);
      return NULL;
    }

    {
      int prevLen = 0;
      int additionalBytes = 3;
      int stackChange = infoTable[((unsigned char) pbCode[i])].stackChange;


      if(i > 0)
	{
	  prevLen = strlen( currentMap ); //mapInsToMap[i - 1] );
	}

      mapInsToMap[i] = sys_malloc( (prevLen + additionalBytes) * sizeof(char*));

      assert(mapInsToMap[i]);
      if(i > 0)
	strcpy( mapInsToMap[i], currentMap) ; //mapInsToMap[i - 1]);
      else
	strcpy( mapInsToMap[i], "");

      currentMap = mapInsToMap[i];
      switch( stackChange ) {

      case 0:
	fprintf(stderr, "0 entry for stackChange encountered\n");
	return NULL;
      case STACKOP_PushVal:
	strcat( mapInsToMap[i], "I");
	break;
      case STACKOP_Push2Val:
	strcat( mapInsToMap[i], "II");
	break;
      case STACKOP_PopVal:
	assert( mapInsToMap[i][prevLen - 1] == 'I');
	mapInsToMap[i][prevLen - 1] = '\0'; 
	break;
      case STACKOP_PopValPushAddress:
	assert( mapInsToMap[i][prevLen - 1] == 'I');
	mapInsToMap[i][prevLen - 1] = '\0'; 
	strcat(mapInsToMap[i], "A");
	break;
      case STACKOP_PopAddressPushVal:
	assert( mapInsToMap[i][prevLen - 1] == 'A');
	mapInsToMap[i][prevLen - 1] = '\0'; 
	strcat(mapInsToMap[i], "I");
	break;
      case STACKOP_Pop2Val:
	assert( mapInsToMap[i][prevLen - 1] == 'I');
	mapInsToMap[i][prevLen - 1] = '\0'; 
	assert( mapInsToMap[i][prevLen - 2] == 'I');
	mapInsToMap[i][prevLen - 2] = '\0'; 
	break;
      case STACKOP_Pop3Val:
	assert( mapInsToMap[i][prevLen - 1] == 'I');
	mapInsToMap[i][prevLen - 1] = '\0'; 
	assert( mapInsToMap[i][prevLen - 2] == 'I');
	mapInsToMap[i][prevLen - 2] = '\0'; 
	assert( mapInsToMap[i][prevLen - 3] == 'I');
	mapInsToMap[i][prevLen - 3] = '\0'; 
	break;
      case STACKOP_PushAddress:
	strcat( mapInsToMap[i], "A");
	break;
      case STACKOP_PopAddress:
	assert(prevLen > 0);
	assert( (mapInsToMap[i][prevLen - 1] == 'A') || (mapInsToMap[i][prevLen - 1] == 'U'));
	mapInsToMap[i][prevLen - 1] = '\0'; 
	break;
      case STACKOP_PopAddressPushUndef:
	assert(prevLen > 0);
	assert( (mapInsToMap[i][prevLen - 1] == 'A') || ((mapInsToMap[i][prevLen - 1] == 'U')));
	mapInsToMap[i][prevLen - 1] = '\0'; 
	strcat( mapInsToMap[i], "U");
	break;
      case STACKOP_Push2Address:
	strcat( mapInsToMap[i], "AA");
	break;
      case STACKOP_Pop2Address:
	assert( mapInsToMap[i][prevLen - 1] == 'A');
	mapInsToMap[i][prevLen - 1] = '\0'; 
	assert( mapInsToMap[i][prevLen - 2] == 'A');
	mapInsToMap[i][prevLen - 2] = '\0'; 
	break;
      case STACKOP_NoOp:
	break;
      case STACKOP_PopUndef:
	mapInsToMap[i][prevLen - 1] = '\0'; 
	break;
      case STACKOP_Pop2Undef:
	mapInsToMap[i][prevLen - 2] = '\0'; 
	break;
      case STACKOP_PushUndef:
	strcat( mapInsToMap[i], "U");
	break;
	case STACKOP_PushDup:
	 if( mapInsToMap[i][prevLen - 1] == 'I')
	  strcat( mapInsToMap[i], "I");
	 else if( mapInsToMap[i][prevLen - 1] == 'A')
	  strcat( mapInsToMap[i], "A");
	 else
	  assert(1 == 2); //duplicating undefined stack item
	break;
      case STACKOP_Swap: {
	char temp = mapInsToMap[i][prevLen - 1];
	mapInsToMap[i][prevLen - 1] = mapInsToMap[i][prevLen - 2];
	mapInsToMap[i][prevLen - 2] = temp;
	break;
      }
      case STACKOP_ArrayLoadAndPushAddress: {
	
	//We pop an index, pop a ref and push an address
	assert( mapInsToMap[i][prevLen - 1] == 'I');
	mapInsToMap[i][prevLen - 1] = '\0'; 
	assert( mapInsToMap[i][prevLen - 2] == 'A');
	mapInsToMap[i][prevLen - 2] = '\0'; 
	strcat( mapInsToMap[i], "A");
	break;
      }
      case STACKOP_ArrayLoadAndPushVal: {
	
	//We pop an index, pop a ref and push a val
	assert( mapInsToMap[i][prevLen - 1] == 'I');
	mapInsToMap[i][prevLen - 1] = '\0'; 
	assert( mapInsToMap[i][prevLen - 2] == 'A');
	mapInsToMap[i][prevLen - 2] = '\0'; 
	strcat( mapInsToMap[i], "I");

	break;
      }
      case STACKOP_ArrayLoadAndPush2Val: {
	
	//We pop an index, pop a ref and push 2 vals
	assert( mapInsToMap[i][prevLen - 1] == 'I');
	mapInsToMap[i][prevLen - 1] = '\0'; 
	assert( mapInsToMap[i][prevLen - 2] == 'A');
	mapInsToMap[i][prevLen - 2] = '\0'; 
	strcat( mapInsToMap[i], "I");
	strcat( mapInsToMap[i], "I");
	break;
      }

      case STACKOP_PopAddressAndArrayStore: {
	//We pop the ref
	//We pop an index, pop a ref
	assert( mapInsToMap[i][prevLen - 1] == 'A');
	mapInsToMap[i][prevLen - 1] = '\0'; 

	assert( mapInsToMap[i][prevLen - 2] == 'I');
	mapInsToMap[i][prevLen - 2] = '\0'; 
	assert( mapInsToMap[i][prevLen - 3] == 'A');
	mapInsToMap[i][prevLen - 3] = '\0'; 
	break;
      }

      case STACKOP_PopValAndArrayStore: {
	//We pop the I
	//We pop an index, pop a ref
	assert( mapInsToMap[i][prevLen - 1] == 'I');
	mapInsToMap[i][prevLen - 1] = '\0'; 

	assert( mapInsToMap[i][prevLen - 2] == 'I');
	mapInsToMap[i][prevLen - 2] = '\0'; 
	assert( mapInsToMap[i][prevLen - 3] == 'A');
	mapInsToMap[i][prevLen - 3] = '\0'; 
	break;
      }

      case STACKOP_Pop2ValAndArrayStore: {
	//We pop the I, I
	//We pop an index, pop a ref
	assert( mapInsToMap[i][prevLen - 1] == 'I');
	mapInsToMap[i][prevLen - 1] = '\0'; 

	assert( mapInsToMap[i][prevLen - 2] == 'I');
	mapInsToMap[i][prevLen - 2] = '\0'; 

	assert( mapInsToMap[i][prevLen - 3] == 'I');
	mapInsToMap[i][prevLen - 3] = '\0'; 
	assert( mapInsToMap[i][prevLen - 4] == 'A');
	mapInsToMap[i][prevLen - 4] = '\0'; 
	break;
      }

      case STACKOP_Getfield: {

	char* sig;	
	int i16Temp;
	//Same as pop address
	assert( (mapInsToMap[i][prevLen - 1] == 'A') || (mapInsToMap[i][prevLen - 1] == 'U'));
	mapInsToMap[i][prevLen - 1] = '\0'; 
	
	i16Temp = pbCode[ i + 1 ] * 256 + pbCode[ i + 2 ];
	sig = CONSTGET_UidFieldSig(pstMethod->pstClass, i16Temp);
	switch( sig[0] ) {
	 case 'L':
	 case '[':

	//It's an address
	  strcat( mapInsToMap[i], "A");
	  break;
	default:
	//It's a value
	  strcat( mapInsToMap[i], "I");
	  break;
	} //end inner switch
	break;
	}

      case STACKOP_Getstatic: {

	char* sig;	
	int i16Temp;
	
	i16Temp = pbCode[ i + 1 ] * 256 + pbCode[ i + 2 ];
	sig = CONSTGET_UidFieldSig(pstMethod->pstClass, i16Temp);
	switch( sig[0] ) {
	 case 'L':
	 case '[':

	//It's an address
	  strcat( mapInsToMap[i], "A");
	  break;
	default:
	//It's a value
	  strcat( mapInsToMap[i], "I");
	  break;
	} //end inner switch
	break;
	}
	case STACKOP_Ldc1:  {

	int i16Temp;
	i16Temp = pbCode[i + 1];
	switch (CONSTTAG(pstMethod->pstClass, i16Temp))
	  {
	     case CONSTANT_Integer:
	     case CONSTANT_Float:
	      strcat( mapInsToMap[i], "I");
	      break;
	  case CONSTANT_String:
	      strcat( mapInsToMap[i], "A");
	      break;
	  default:
	   fprintf(stderr, "Serious error in ldc1 in stackmap.c\n");
	  }
	break;
       }
	case STACKOP_Ldc2:  {

	int i16Temp;
	i16Temp = pbCode[i + 1] * 256 + pbCode[i + 2];
	switch (CONSTTAG(pstMethod->pstClass, i16Temp))
	  {
	     case CONSTANT_Integer:
	     case CONSTANT_Float:
	      strcat( mapInsToMap[i], "I");
	      break;
	  case CONSTANT_String:
	      strcat( mapInsToMap[i], "A");
	      break;
	  default:
	   fprintf(stderr, "Serious error in ldc2 in stackmap.c\n");
	  
	}
	break;
       }
      case STACKOP_Method: {

	eprintf("%i: b1 is %i, b2 %i, code is %p\n", pbCode[i], pbCode[i + 1], pbCode[i + 2], pbCode);
	if( STACKMAP_handleMethod( i, mapInsToMap, prevLen, pbCode[i], (unsigned int) pbCode[i + 1], (unsigned int) pbCode[i + 2], pstMethod, pstMethod->pstClass) == -1)
	return NULL;
	break;
      }
      default:
	fprintf(stderr, "Unknown stack change value encountered\n");
	return NULL;
	break;
      } //end switch


{
  int extraBytes = infoTable[((unsigned char) pbCode[i])].extraBytes;
  int j = 0;

  assert(extraBytes < 7);

  for(j = 0; j < extraBytes;j++)
    mapInsToMap[i + j + 1] = NULL;

//  fprintf(stderr, "Map %s:%i %s, next i %i ", pstMethod->uidName, i, mapInsToMap[i], i + extraBytes + 1);

//  STACKMAP_printStackOp( stderr, stackChange);
//	fprintf(stderr, " (skip %i+%i)\n", i, extraBytes);

    i += extraBytes;
}
     } //end brace

    if(mapInsToMap[i])
     addToHistogram( mapInsToMap[i] );

} //end for



/* We now build an encoded version of these maps */
{
 int insNumber = 0;
 int startRange = -1;
 int haveStartedRange = 1;
 struct tstackmap* map;
 currentMap = ""; //mapInsToMap[0];

 map = STACKMAP_startEncoding();

 while(insNumber < numBytes) {

  if(currentMap != NULL) {
   if( (mapInsToMap[insNumber] != NULL) && (strcmp(currentMap, mapInsToMap[insNumber])))
	{

	 STACKMAP_newRange( map, (insNumber - startRange) + 1);
//	fprintf(stderr, "%i compared map %s and %s; added range %i \n", insNumber, currentMap, mapInsToMap[insNumber], insNumber - startRange);
	 startRange = insNumber;	

	}
	else 
	{
//	 fprintf(stderr, "No diff %i compared map %s and %s;\n", insNumber, currentMap, mapInsToMap[insNumber]);
	}
}

	if(mapInsToMap[ insNumber ])
	   currentMap = mapInsToMap[ insNumber ];
//   insNumber += infoTable[((unsigned char) pbCode[insNumber])].extraBytes;
   insNumber++;
 }

  STACKMAP_printEncodedMap( map );
	return map;
}

}
/* Returns 0 for success, -1 for error */

int STACKMAP_handleMethod( int insNumber, char** mapInsToMap, int prevLen, int ins, unsigned int b1, unsigned int b2, tMethod* pstMethod, tClass* pstClass) {

	if(((unsigned char) ins == invokevirtual) || ((unsigned char) ins == invokespecial))
	{
	int args;
	int i ;
	tMethod* pstMethodTemp;
	uint16 i16Temp;
	int type; //0 is integer I, 1 is address A, 2 is long/double II, -1 is error
	 //We need to figure out what the stack changes look like from the signature

    i16Temp = (b1) * 256;
    i16Temp += (b2);

// eprintf("-- i16Temp is %i class is %s, b1 %i, b2 %i\n", i16Temp, pstClass->uidName, (int) b1, (int) b2);
    pstMethodTemp = CONSTGET_MethodNonVirtual(pstClass, i16Temp);

//	 fprintf(stderr, "Sig is %s\n", pstMethodTemp->uidSignature);	

	args = CLASSFILE_CalcNumArguments( pstMethodTemp->uidSignature );
	for(i = 0; i < args;i++) {
		type = CLASSFILE_GetArgumentType( pstMethodTemp->uidSignature, i);
	        if(type == 0) //I
		{
		 mapInsToMap[insNumber][prevLen - 1] = '\0'; 
		 prevLen--;
		}
		else if(type == 1) //A
		{
		 mapInsToMap[insNumber][prevLen - 1] = '\0'; 
		 prevLen--;
		}
		else if(type == 2) //II
		{
		 mapInsToMap[insNumber][prevLen - 1] = '\0'; 
		 prevLen--;
		 mapInsToMap[insNumber][prevLen - 1] = '\0'; 
		 prevLen--;
		}
		else if(type == -1) 
		{
		 fprintf(stderr, "INVALID type from GetArgumentType %i, %s:%i\n", type, pstMethodTemp->uidSignature, i);
		}
	fprintf(stderr, "Sig is %s, %i is type %i\n", pstMethodTemp->uidSignature, i, type);
	}

	//We always pop the virtual object 
	 mapInsToMap[insNumber][prevLen - 1] = '\0'; 
	 prevLen--;

	//Now we push the return value
	type = CLASSFILE_GetReturnType( pstMethodTemp->uidSignature );
	if(type == 0) //I
	 {
	  strcat(mapInsToMap[insNumber], "I");
	  prevLen++;
	 }
	else if(type == 1) //A
	 {
	  strcat(mapInsToMap[insNumber], "A");
	  prevLen++;
	 }
	else if(type == 2) //II
	 {
	  strcat(mapInsToMap[insNumber], "II");
	  prevLen++; 	  prevLen++;
	 }
//For invokespecial this should always be the case
	else if(type == 3) // V
	 {
	
	 }
	else if(type == -1)
	 {
 	 fprintf(stderr, "INVALID type from GetReturnType %i, %s\n", type, pstMethodTemp->uidSignature);
	 }
	}
	else if(((unsigned char) ins == invokestatic))
	{	
	tMethod* pstMethodTemp;
	uint16 i16Temp;
	int type; //0 is integer I, 1 is address A, 2 is long/double II, -1 is error
	int args, i;

	i16Temp = b1 * 256 + b2;
    
	pstMethodTemp = CONSTGET_MethodStatic(pstClass, i16Temp);
	
	args = CLASSFILE_CalcNumArguments( pstMethodTemp->uidSignature );
	for(i = 0; i < args;i++) {
		type = CLASSFILE_GetArgumentType( pstMethodTemp->uidSignature, i);
	        if(type == 0) //I
		{
		 mapInsToMap[insNumber][prevLen - 1] = '\0'; 
		 prevLen--;
		}
		else if(type == 1) //A
		{
		 mapInsToMap[insNumber][prevLen - 1] = '\0'; 
		 prevLen--;
		}
		else if(type == 2) //II
		{
		 mapInsToMap[insNumber][prevLen - 1] = '\0'; 
		 prevLen--;
		 mapInsToMap[insNumber][prevLen - 1] = '\0'; 
		 prevLen--;
		}
		else if(type == -1) 
		{
		 fprintf(stderr, "INVALID type from GetArgumentType %i, %s:%i\n", type, pstMethodTemp->uidSignature, i);
		}
	fprintf(stderr, "Sig is %s, %i is type %i\n", pstMethodTemp->uidSignature, i, type);
	}
	//Now we push the return value
	type = CLASSFILE_GetReturnType( pstMethodTemp->uidSignature );
	if(type == 0) //I
	 {
	  strcat(mapInsToMap[insNumber], "I");
	  prevLen++;
	 }
	else if(type == 1) //A
	 {
	  strcat(mapInsToMap[insNumber], "A");
	  prevLen++;
	 }
	else if(type == 2) //II
	 {
	  strcat(mapInsToMap[insNumber], "II");
	  prevLen++; 	  prevLen++;
	 }
//For invokespecial this should always be the case
	else if(type == 3) // V
	 {
	
	 }
	else if(type == -1)
	 {
 	 fprintf(stderr, "INVALID type from GetReturnType %i, %s\n", type, pstMethodTemp->uidSignature);
	 }
	return 0;
	}
	else //not invokevirtual or invokespecial
	{
	 fprintf(stderr, "Yuck\n\n\n\n\n");
	DISASS_PrintInstructionName(stderr, ins);
	 return -1;
	}
	return 0;
}



void STACKMAP_printTable() {

  int i = 0;

  for(i = 0; i < 212; i++) {

    fprintf(stderr, "%i: \t", i);
    DISASS_PrintInstructionName(stderr, (byte) i);
    fprintf(stderr, "\tControl %i, extra bytes %i\t", infoTable[i].controlInstruction, infoTable[i].extraBytes);
    STACKMAP_printStackOp(stderr, infoTable[i].stackChange);
    fprintf(stderr, "\n");

  }
}

void STACKMAP_printStackOp(FILE* stream, int op) {

  switch(op) {

  case STACKOP_PushVal:
    fprintf(stream, "STACKOP_PushVal");
    break;
  case STACKOP_PopVal:
    fprintf(stream, "STACKOP_PopVal");
    break;
  case STACKOP_Push2Val:
    fprintf(stream, "STACKOP_Push2Val");
    break;
  case STACKOP_Pop2Val:
    fprintf(stream, "STACKOP_Pop2Val");
    break;
  case STACKOP_PushAddress:
    fprintf(stream, "STACKOP_PushAddress");
    break;
  case STACKOP_PopAddress:
    fprintf(stream, "STACKOP_PopAddress");
    break;
  case STACKOP_Push2Address:
    fprintf(stream, "STACKOP_Push2Address");
    break;
  case STACKOP_Pop2Address:
    fprintf(stream, "STACKOP_Pop2Address");
    break;

  case STACKOP_NoOp:
    fprintf(stream, "STACKOP_NoOp");
    break;

  case STACKOP_PopUndef:
    fprintf(stream, "STACKOP_PopUndef");
    break;
  case STACKOP_Pop2Undef:
    fprintf(stream, "STACKOP_Pop2Undef");
    break;
  case STACKOP_PushUndef:
    fprintf(stream, "STACKOP_PushUndef");
    break;
  case STACKOP_Push2Undef:
    fprintf(stream, "STACKOP_Push2Undef");
    break;
  case STACKOP_Swap:
    fprintf(stream, "STACKOP_Swap");
    break;
  case STACKOP_Method:
    fprintf(stream, "STACKOP_Method");
    break;
  case STACKOP_Getfield:
    fprintf(stream, "STACKOP_Getfield");
    break;
  case STACKOP_PopAddressPushUndef:
    fprintf(stream, "STACKOP_PopAddressPushUndef");
    break;
  case STACKOP_ArrayLoadAndPushAddress:
    fprintf(stream, "STACKOP_ArrayLoadAndPushAddress");
    break;
  case STACKOP_ArrayLoadAndPushVal:
    fprintf(stream, "STACKOP_ArrayLoadAndPushVal");
    break;
  case STACKOP_ArrayLoadAndPush2Val:
    fprintf(stream, "STACKOP_ArrayLoadAndPush2Val");
    break;
  case STACKOP_PopAddressAndArrayStore:
    fprintf(stream, "STACKOP_PopAddressAndArrayStore");
    break;
  case STACKOP_PopValAndArrayStore:
    fprintf(stream, "STACKOP_PopValAndArrayStore");
    break;
  case STACKOP_Pop2ValAndArrayStore:
    fprintf(stream, "STACKOP_Pop2ValAndArrayStore");
    break;
  case STACKOP_PushDup:
    fprintf(stream, "STACKOP_PushDup");
    break;
  case STACKOP_Getstatic:
    fprintf(stream, "STACKOP_Getstatic");
    break;
  case STACKOP_PopValPushAddress:
    fprintf(stream, "STACKOP_PopValPushAddress");
    break;
  case STACKOP_PopAddressPushVal:
    fprintf(stream, "STACKOP_PopAddressPushVal");
    break;
case STACKOP_Ldc1:
    fprintf(stream, "STACKOP_Ldc1");
    break;
case STACKOP_Ldc2:
    fprintf(stream, "STACKOP_Ldc2");
    break;
case STACKOP_Pop3Val:
    fprintf(stream, "STACKOP_Pop3Val");
    break;
  default:
    fprintf(stream, "UNKNOWN STACKOP");
    break;
  }
}



#endif
