#include <config.h>

#include <assert.h>
#include "garbage/public_methods.h"
#include "jni.h"
#include "natives.h"

extern int32 i32NumTableEntries;
extern tNewNativeLookup pstNewNativeLookupTable[];

/* 
 * @doc FUNC 
 * @func 
 * This function adds the native methods to the specified class. It searches 
 * the array of native methods for the name of the class whose native methods 
 * it is going to add. When it finds a method that belongs to that class, it 
 * adds it to that class's native methods. If the class is a preloaded class 
 * then it puts the native method pointers in the correct place in the global 
 * native method array, otherwise space is allocated in the class and they are 
 * stored there. 
 * 
 */ 
 
extern tClassLoaderTuple* pstObjectType; // this can be globally used to get the type for java/lang/Object

void NATIVES_InitNatives 
(
  tClassLoaderTuple* tup_pstClass
)
{
  int i, j;
  char* lookingFor;
  tClass* pstClass = tup_pstClass->pstClass;

  if (pstClass->u16NumNatives == 0)
  {
    return;
  }

  pstClass->pstNativeMethods = (JNINativeMethod*) sys_malloc(sizeof(JNINativeMethod) * pstClass->u16NumNatives); 
  assert(pstClass->pstNativeMethods);

  if(tup_pstClass->uidName[0] == '[')
  {
    if(pstObjectType == NULL)
      lookingFor = "java/lang/Object";
    else
      lookingFor = pstObjectType->uidName;
    //this is an array, so we use Object's methods
  }
  else
{
 lookingFor = tup_pstClass->uidName;
}
  /* find this class's native methods in the table */ 
  for (i = 0, j = 0; i < i32NumTableEntries; i++) 
  {

#ifdef DEBUG_NATIVE
      printf("Comparing %s and %s\n", pstClass->uidName, pstNewNativeLookupTable[i].pszClassName);
#endif

    if (strcmp(lookingFor, pstNewNativeLookupTable[i].pszClassName) == 0) 
    {
      pstClass->pstNativeMethods[j].name = UID_GetUid(pstNewNativeLookupTable[i].pszMethodName); 
      pstClass->pstNativeMethods[j].signature = UID_GetUid(pstNewNativeLookupTable[i].pszMethodSig); 
      pstClass->pstNativeMethods[j].fnPtr = pstNewNativeLookupTable[i].pFunction; 

      j += 1; 
    } 
  } 
  if( j != pstClass->u16NumNatives)
    {
      eprintf("WARNING, the number of native methods declared in natives.c for %s is not the same as the number of natives in the java class file (%i in the java file, %i in native code)\n", tup_pstClass->uidName, pstClass->u16NumNatives, j);
    }
//  assert( j == pstClass->u16NumNatives);
}

