/*
 * Copyright (C) 2001, John Leuner.
 *
 * This file is part of the kissme/teaseme project, which in turn is part of the JOS project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2,
 * or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <pthread.h>
#include "interp.h"

/* Structure for the fat lock */

typedef struct tfatlock {

tMutex* lock;
int owner;
int recursion_count; //Number of times this lock has been locked be the owning thread

} tFatlock;


int THREAD_NotifyRandom(JNIEnv* env,tOBREF);
int THREAD_NotifyAll(JNIEnv* env,tOBREF);
int THREAD_Notify (JNIEnv* env, tOBREF pstObject, int notify_all);

int THREAD_WaitOnObject(JNIEnv*, tOBREF, jlong);

void THREAD_SynchroniseExit (tOBREF pstObject	/* @parm Object to release */  );
void THREAD_SynchroniseEnter (tOBREF pstObject	/* @parm Object to lock */ );
