/* This header file is included directly into interp_loop.c 
   
   It handles all the instructions for loading and storing variables, also for array variables
*/


      case iload:
      {
	  /*	printf("var 1 before %x\n", pi32Vars[1]);
	  printf("Frame vars %x, local vars %x, stack %x\n", pstCurrFrame->pi32Vars, pi32Vars, optop);
	  printf("iload, index %i, val %x\n", *pbPC, pi32Vars[*pbPC]);*/

        *(++optop) = pi32Vars[(*pbPC++)];

	//	printf("var 1 now %x\n", pi32Vars[1]);

        break;
      }
      case lload:
      {
        *(++optop) = pi32Vars[*pbPC];
        *(++optop) = pi32Vars[(*pbPC++) + 1];
        break;
      }
      case fload:
      {
        *(++optop) = pi32Vars[(*pbPC++)];
        break;
      }
      case dload:
      {
        *(++optop) = pi32Vars[*pbPC];
	*(++optop) = pi32Vars[(*pbPC++) + 1];
        break;
      }
      case aload:
      {
        *(++optop) = pi32Vars[(*pbPC++)];
        break;
      }
      case iload_0:
      {
        *(++optop) = pi32Vars[0];
        break;
      }
      case iload_1:
      {
        *(++optop) = pi32Vars[1];
        break;
      }
      case iload_2:
      {
        *(++optop) = pi32Vars[2];
        break;
      }
      case iload_3:
      {
        *(++optop) = pi32Vars[3];
        break;
      }
	case lload_0:
	{
	  *(++optop) = pi32Vars[0];
	  *(++optop) = pi32Vars[1];
        break;
      }
      case lload_1:
      {
        *(++optop) = pi32Vars[1];
        *(++optop) = pi32Vars[2];
        break;
      }
      case lload_2:
      {
        *(++optop) = pi32Vars[2];
        *(++optop) = pi32Vars[3];
        break;
      }
      case lload_3:
      {
        *(++optop) = pi32Vars[3];
        *(++optop) = pi32Vars[4];
        break;
      }
      case fload_0:
      {
        *(++optop) = pi32Vars[0];
        break;
      }
      case fload_1:
      {
        *(++optop) = pi32Vars[1];
        break;
	}
      case fload_2:
      {
        *(++optop) = pi32Vars[2];
        break;
      }
      case fload_3:
      {
        *(++optop) = pi32Vars[3];
        break;
      }
      case dload_0:
      {
        *(++optop) = pi32Vars[0];
        *(++optop) = pi32Vars[1];
        break;
      }
      case dload_1:
      {
        *(++optop) = pi32Vars[1];
        *(++optop) = pi32Vars[2];
        break;
      }
      case dload_2:
      {
        *(++optop) = pi32Vars[2];
        *(++optop) = pi32Vars[3];
        break;
      }
      case dload_3:
		{
			*(++optop) = pi32Vars[3];
		  *(++optop) = pi32Vars[4];
		  break;
		}
		case aload_0:
		{
		    //assert(*optop != 0);
		  *(++optop) = pi32Vars[0];
		  break;
		}
		case aload_1:
		{
		  *(++optop) = pi32Vars[1];
		  break;
		}
		case aload_2:
		{
		  *(++optop) = pi32Vars[2];
		  break;
		}
		case aload_3:
		{
		  *(++optop) = pi32Vars[3];
		  break;
		}
		case iaload:
		{
		  optop--;
		if (*optop)
		  {
			 if ((*(optop + 1) < ADEREF((tARREF) *optop)->i32Number)
			     && (*(optop + 1) >= 0))
			 {
				*optop = ((int32*) ADEREF((tARREF) *optop)->pvElements)[*(optop + 1)];
			 }
			 else
			 {
			     char buf[256];
			     sprintInt(buf, (int) *(optop + 1));
			     //			     snprintf(buf, 256, "%i\n", (int) *(optop + 1));
			     SAVEENV();
			     pstCurrFrame = ThrowNamedExceptionWithMessage(env, pstCurrFrame, "java/lang/ArrayIndexOutOfBoundsException", buf);
			     LOADENV();
			 }
		  }
		  else
		  {
		      SAVEENV();
		      pstCurrFrame = ThrowNamedException(env, pstCurrFrame, "java/lang/NullPointerException");
		      LOADENV();
		  }
		  break;
		}
		case laload:
		{
			long long*  pi32Temp;
		        int32   i32Index;

			if (*(optop - 1))
			{
			 if (*optop < ADEREF((tARREF) *(optop - 1))->i32Number)
			 {
				pi32Temp = (long long*) ADEREF((tARREF) *(optop - 1))->pvElements;
				i32Index = *optop;
				*((long long*) (optop - 1)) = pi32Temp[i32Index];
			 }
			 else
			   {
			     SAVEENV();
			     pstCurrFrame = ThrowNamedException(env,pstCurrFrame, "java/lang/ArrayIndexOutOfBoundsException");
			     LOADENV();
			   }
			}
			else
			  {
			    SAVEENV();
			    pstCurrFrame = ThrowNamedException(env,pstCurrFrame, "java/lang/NullPointerException");
			    LOADENV();
			  }
        break;
      }
      case faload:
      {
        optop--;
        if (*optop)
        {
          if (*(optop + 1) < ADEREF((tARREF) *optop)->i32Number)
          {
            *optop = ((int32*) ADEREF((tARREF) *optop)->pvElements)[*(optop + 1)];
          }
          else
          {
            SAVEENV();
            pstCurrFrame = ThrowNamedException(env,pstCurrFrame, "java/lang/ArrayIndexOutOfBoundsException");
            LOADENV();
          }
        }
		    else
        {
          SAVEENV();
          pstCurrFrame = ThrowNamedException(env,pstCurrFrame, "java/lang/NullPointerException");
          LOADENV();
        }
        break;
      }
      case daload:
      {
				int32*  pi32Temp;

				if (*(optop - 1))
        {
					if (*optop < ADEREF((tARREF) *(optop - 1))->i32Number)
          {
						pi32Temp = ADEREF((tARREF) *(optop - 1))->pvElements;
						*(optop - 1) = pi32Temp[*optop];
						*optop = pi32Temp[*optop + 1];
          }
          else
          {
            SAVEENV();
            pstCurrFrame = ThrowNamedException(env,pstCurrFrame, "java/lang/ArrayIndexOutOfBoundsException");
            LOADENV();
          }
        }
        else
        {
          SAVEENV();
          pstCurrFrame = ThrowNamedException(env,pstCurrFrame, "java/lang/NullPointerException");
          LOADENV();
        }
        break;
      }
      case aaload:
      {
        optop--;

        if (*optop)
        {
          if ((*(optop + 1) < ADEREF((tARREF) *optop)->i32Number) && ( *(optop +1) >= 0))
          {
            #ifdef PERSIST
            /* check if the element is a PID */
            #ifdef EAGERINDIRECT
            /* assume that it's already swizzled */
            *optop = ((int32*) ADEREF((tARREF) *optop)->pvElements)[*(optop + 1)];
            #else

#ifndef GARBAGE_GENERATIONAL
            /* check if it's swizzled */
	    
            if (ISPID((PID) ((int32*) ADEREF((tARREF) *optop)->pvElements)[*(optop + 1)]))
            {
              #ifdef NOSWIZZLE
              *optop = (int32) RPOT_FaultObject(((int32*) (ADEREF((tARREF) *optop)->pvElements))[*(optop + 1)]);
              #else
              ((int32*) ADEREF((tARREF) *optop)->pvElements)[*(optop + 1)] = (int32) RPOT_FaultObject(((int32*) ADEREF((tARREF) *optop)->pvElements)[*(optop + 1)]);
              *optop = ((int32*) ADEREF((tARREF) *optop)->pvElements)[*(optop + 1)];
              #endif
            }
            else
            {
#endif
              *optop = ((int32*) ADEREF((tARREF) *optop)->pvElements)[*(optop + 1)];
#ifndef GARBAGE_GENERATIONAL
            }
#endif
            #endif /* eagerindirect */
            #else
            *optop = ((int32*) ADEREF((tARREF) *optop)->pvElements)[*(optop + 1)];
            #endif /* persist */
          }
          else
          {
	    char buf[256];
	    snprintf(buf, 256, "%i\n", (int) *(optop + 1));
            SAVEENV();
            pstCurrFrame = ThrowNamedExceptionWithMessage(env, pstCurrFrame, "java/lang/ArrayIndexOutOfBoundsException", buf);
            LOADENV();
          }
		  }
				else
        {
          SAVEENV();
          pstCurrFrame = ThrowNamedException(env, pstCurrFrame, "java/lang/NullPointerException");
          LOADENV();
        }
        break;
      }
      case baload:
      {
        optop--;
        if (*optop)
        {
          if ((*(optop + 1) < ADEREF((tARREF) *optop)->i32Number)
	      && (*(optop + 1) >= 0))
          {
	      //No sign extension or any shit like that?
            *optop = ((byte*) ADEREF((tARREF) *optop)->pvElements)[*(optop + 1)];


	    if(*optop & 0x80)
		*optop = -(256 - *optop);

          }
          else
          {
            SAVEENV();
            pstCurrFrame = ThrowNamedException(env, pstCurrFrame, "java/lang/ArrayIndexOutOfBoundsException");
            LOADENV();
          }
        }
        else
        {
          SAVEENV();
          pstCurrFrame = ThrowNamedException(env, pstCurrFrame, "java/lang/NullPointerException");
          LOADENV();
        }
        break;
      }
      case caload:
      {

        optop--;
        if (*optop)
        {

	 if (*(optop + 1) < ADEREF((tARREF) *optop)->i32Number)
          {
            *optop = ((uint16*) ADEREF((tARREF) *optop)->pvElements)[*(optop + 1)];
          }
          else
          {
	  char buf[256];
	  sprintInt(buf, (int) *(optop + 1));
	  
	  //	  snprintf(buf, 256, "%i", (int) *(optop + 2));
	  SAVEENV();
	  pstCurrFrame = ThrowNamedExceptionWithMessage(env, pstCurrFrame, "java/lang/ArrayIndexOutOfBoundsException", buf);
	  LOADENV();
          }
		  }
        else
        {
          SAVEENV();
          pstCurrFrame = ThrowNamedException(env, pstCurrFrame, "java/lang/NullPointerException");
          LOADENV();
        }
        break;
      }
      case saload:
      {
        optop--;
        if (*optop)
        {
          if( (*(optop + 1) >= 0) &&  (*(optop + 1) < ADEREF((tARREF) *optop)->i32Number))
          {
            *optop = ((int16*) ADEREF((tARREF) *optop)->pvElements)[*(optop + 1)];
          }
          else
          {
	    char buf[256];
	    snprintf(buf, 256, "%i\n", (int) *(optop + 1));
	    SAVEENV();
	    pstCurrFrame = ThrowNamedExceptionWithMessage(env,pstCurrFrame, "java/lang/ArrayIndexOutOfBoundsException", buf);
	    LOADENV();
          }
        }
        else
        {
	  SAVEENV();
	  eprintf( "Error loading short from array, handle %x, index %i\n", (int) optop, (int) *(optop + 1));
	  pstCurrFrame = ThrowNamedException(env,pstCurrFrame, "java/lang/NullPointerException");
	  LOADENV();
        }
        break;
      }
      case istore:
      {
        pi32Vars[(*pbPC++)] = *(optop--);
        break;
      }
      case astore:
      {
        pi32Vars[(*pbPC++)] = *(optop--);
        break;
      }
      case lstore:
      {
        pi32Vars[(*pbPC) + 1] = *(optop--);
        pi32Vars[(*pbPC++)] = *(optop--);
        break;
      }
      case fstore:
      {
        pi32Vars[(*pbPC++)] = *(optop--);
        break;
      }
      case dstore:
      {
        pi32Vars[(*pbPC) + 1] = *(optop--);
        pi32Vars[(*pbPC++)] = *(optop--);
        break;
      }

      case istore_0:
      {
        pi32Vars[0] = *(optop--);
        break;
      }
      case istore_1:
      {
        pi32Vars[1] = *(optop--);
        break;
      }
      case istore_2:
      {
        pi32Vars[2] = *(optop--);
        break;
      }
      case istore_3:
      {
        pi32Vars[3] = *(optop--);
        break;
      }
      case lstore_0:
      {
        pi32Vars[1] = *(optop--);
        pi32Vars[0] = *(optop--);
        break;
      }
		case lstore_1:
      {
        pi32Vars[2] = *(optop--);
        pi32Vars[1] = *(optop--);
				break;
      }
      case lstore_2:
      {
        pi32Vars[3] = *(optop--);
        pi32Vars[2] = *(optop--);
        break;
      }
      case lstore_3:
      {
        pi32Vars[4] = *(optop--);
        pi32Vars[3] = *(optop--);
        break;
      }
      case fstore_0:
      {
        pi32Vars[0] = *(optop--);
        break;
      }
      case fstore_1:
      {
        pi32Vars[1] = *(optop--);
        break;
      }
      case fstore_2:
      {
        pi32Vars[2] = *(optop--);
        break;
      }
      case fstore_3:
      {
	pi32Vars[3] = *(optop--);
        break;
      }
      case dstore_0:
      {
		  pi32Vars[1] = *(optop--);
        pi32Vars[0] = *(optop--);
        break;
      }
      case dstore_1:
      {
        pi32Vars[2] = *(optop--);
        pi32Vars[1] = *(optop--);
        break;
      }
      case dstore_2:
      {
        pi32Vars[3] = *(optop--);
        pi32Vars[2] = *(optop--);
        break;
      }
      case dstore_3:
      {
        pi32Vars[4] = *(optop--);
        pi32Vars[3] = *(optop--);
        break;
      }
      case astore_0:
      {
	  //	assert(*optop != 0);
	  //	printf("Storing %x in 0\n", *optop);
        pi32Vars[0] = *(optop--);
				break;
      }
      case astore_1:
      {
        pi32Vars[1] = *(optop--);
        break;
      }
      case astore_2:
      {
        pi32Vars[2] = *(optop--);
        break;
      }
      case astore_3:
      {
        pi32Vars[3] = *(optop--);
		  break;
      }
      case iastore:
      {
        optop -= 3;
        if (*(optop + 1))
        {
			 if ((*(optop + 2) < ADEREF((tARREF) *(optop + 1))->i32Number)
			     && (*(optop + 2) >= 0))
			 {
				#ifdef PERSIST
				        ADEREF((tARREF) *(optop + 1))->i32Flags |= PERSIST_Dirty;
			        #endif
				((int32*) ADEREF((tARREF) *(optop + 1))->pvElements)[*(optop + 2)] = *(optop + 3);
			 }
			 else
			 {
			
			     char buf[256];
			     snprintf(buf, 256, "%i", (int) *(optop + 2));
			     SAVEENV();
			     pstCurrFrame = ThrowNamedExceptionWithMessage(env,pstCurrFrame, "java/lang/ArrayIndexOutOfBoundsException", buf);
			     LOADENV();
			 }
		  }
		  else
		  {
       SAVEENV();
		      eprintf("Error storing integer from array, handle %x\n", (int) (optop + 1));
       pstCurrFrame = ThrowNamedException(env,pstCurrFrame, "java/lang/NullPointerException");
       LOADENV();
		  }
		  break;
		}
		case lastore:
		{
		  int32 i32Index;

		  optop -= 4;
		  if (*(optop + 1))
		    {
		      if (*(optop + 2) < ADEREF((tARREF) *(optop + 1))->i32Number)
			{
#ifdef PERSIST
			  ADEREF((tARREF) *(optop + 1))->i32Flags |= PERSIST_Dirty;
#endif
			  i32Index = *(optop + 2);
			  ((int32*) ADEREF((tARREF) *(optop + 1))->pvElements)[i32Index * 2] = *(optop + 3);
			  ((int32*) ADEREF((tARREF) *(optop + 1))->pvElements)[i32Index * 2 + 1] = *(optop + 4);
			}
		      else
			{
			  SAVEENV();
			  pstCurrFrame = ThrowNamedException(env,pstCurrFrame, "java/lang/ArrayIndexOutOfBoundsException");
			  LOADENV();
			}
		    }
		  else
		    {
		      SAVEENV();
		      pstCurrFrame = ThrowNamedException(env,pstCurrFrame, "java/lang/NullPointerException");
		      LOADENV();
		    }
		  break;
		}
		case fastore:
		{
		  optop -= 3;
		  if (*(optop + 1))
		  {
			 if (*(optop + 2) < ADEREF((tARREF) *(optop + 1))->i32Number)
			 {
        #ifdef PERSIST
        ADEREF((tARREF) *(optop + 1))->i32Flags |= PERSIST_Dirty;
        #endif
				((int32*) ADEREF((tARREF) *(optop + 1))->pvElements)[*(optop + 2)] = *(optop + 3);
			 }
			 else
			 {
        SAVEENV();
        pstCurrFrame = ThrowNamedException(env,pstCurrFrame, "java/lang/ArrayIndexOutOfBoundsException");
        LOADENV();
			 }
		  }
		  else
		  {
       SAVEENV();
       pstCurrFrame = ThrowNamedException(env,pstCurrFrame, "java/lang/NullPointerException");
       LOADENV();
		  }
		  break;
		}
		case dastore:
		{
		  optop -= 4;
		  if (*(optop + 1))
		  {
			 if (*(optop + 2) < ADEREF((tARREF) *(optop + 1))->i32Number)
			 {
        #ifdef PERSIST
        ADEREF((tARREF) *(optop + 1))->i32Flags |= PERSIST_Dirty;
        #endif
				((int32*) ADEREF((tARREF) *(optop + 1))->pvElements)[*(optop + 2)] = *(optop + 3);
				((int32*) ADEREF((tARREF) *(optop + 1))->pvElements)[*(optop + 2) + 1] = *(optop + 4);
			 }
			 else
			 {
        SAVEENV();
        pstCurrFrame = ThrowNamedException(env,pstCurrFrame, "java/lang/ArrayIndexOutOfBoundsException");
        LOADENV();
			 }
		  }
		  else
		  {
       SAVEENV();
       pstCurrFrame = ThrowNamedException(env,pstCurrFrame, "java/lang/NullPointerException");
       LOADENV();
		  }
		  break;
		}
		case aastore:
		{
		  optop -= 3;
		  if (*(optop + 1))
		  {
		    assert((ADEREF((tARREF) *(optop + 1))->pstType->uidName[1] == 'L') ||
			   (ADEREF((tARREF) *(optop + 1))->pstType->uidName[1] == '['));

			 if (*(optop + 2) < ADEREF((tARREF) *(optop + 1))->i32Number)
			 {
         #ifdef PERSIST
				 ((int32*) ADEREF((tARREF) *(optop + 1))->pvElements)[*(optop + 2)] = *(optop + 3);
         ADEREF((tARREF) *(optop + 1))->i32Flags |= (PERSIST_Dirty | PERSIST_RefsDirty);
         #ifdef UPDATEBITS
         ADEREF((tARREF) *(optop + 1))->i32UpdateBits |= (1 << *(optop + 2));
         #endif
         #else
				 ((int32*) ADEREF((tARREF) *(optop + 1))->pvElements)[*(optop + 2)] = *(optop + 3);
         #endif
			 }
			 else
			 {
        SAVEENV();
        pstCurrFrame = ThrowNamedException(env,pstCurrFrame, "java/lang/ArrayIndexOutOfBoundsException");
        LOADENV();
			 }
		  }
		  else
		  {
       SAVEENV();
       pstCurrFrame = ThrowNamedException(env,pstCurrFrame, "java/lang/NullPointerException");
       LOADENV();
		  }
		  break;
		}
		case bastore:
		{
		  optop -= 3;
		  if (*(optop + 1))
		  {
			 if ( ( (*(optop + 2)) < ADEREF((tARREF) *(optop + 1))->i32Number)
			     && (*(optop + 2) >= 0) )
			 {
				#ifdef PERSIST
				        ADEREF((tARREF) *(optop + 1))->i32Flags |= PERSIST_Dirty;
			        #endif
					//Should I at least cast this to a char?
				((byte*) ADEREF((tARREF) *(optop + 1))->pvElements)[*(optop + 2)] = (char) *(optop + 3);
			 }
			 else
			 {
        SAVEENV();
        pstCurrFrame = ThrowNamedException(env,pstCurrFrame, "java/lang/ArrayIndexOutOfBoundsException");
        LOADENV();
			 }
		  }
		  else
		  {
       SAVEENV();
       pstCurrFrame = ThrowNamedException(env,pstCurrFrame, "java/lang/NullPointerException");
       LOADENV();
		  }
		  break;
		}
		case castore:
		{
		  optop -= 3;
		  if (*(optop + 1))
		  {
			 if (*(optop + 2) < ADEREF((tARREF) *(optop + 1))->i32Number)
			 {
        #ifdef PERSIST
        ADEREF((tARREF) *(optop + 1))->i32Flags |= PERSIST_Dirty;
        #endif
				((uint16*) ADEREF((tARREF) *(optop + 1))->pvElements)[*(optop + 2)] = *(optop + 3);
			 }
			 else
			 {
        SAVEENV();
        pstCurrFrame = ThrowNamedException(env,pstCurrFrame, "java/lang/ArrayIndexOutOfBoundsException");
        LOADENV();
			 }
			}
		  else
		  {
       SAVEENV();
       pstCurrFrame = ThrowNamedException(env,pstCurrFrame, "java/lang/NullPointerException");
       LOADENV();
		  }
		  break;
		}
		case sastore:
		{
		  optop -= 3;
		  if (*(optop + 1))
		    {
		      if( (*(optop + 2) >= 0) && (*(optop + 2) < ADEREF((tARREF) *(optop + 1))->i32Number))
			 {
#ifdef PERSIST
			   ADEREF((tARREF) *(optop + 1))->i32Flags |= PERSIST_Dirty;
#endif
				((int16*) ADEREF((tARREF) *(optop + 1))->pvElements)[*(optop + 2)] = *(optop + 3);
			 }
			 else
			 {
			   SAVEENV();
			   pstCurrFrame = ThrowNamedException(env,pstCurrFrame, "java/lang/ArrayIndexOutOfBoundsException");
			   LOADENV();
			 }
		    }
		  else
		    {
		      SAVEENV();
		      pstCurrFrame = ThrowNamedException(env,pstCurrFrame, "java/lang/NullPointerException");
		      LOADENV();
		    }
		  break;
		}
