/* This handles the arithmetic instructions, like add,sub and neg.

It also does ior, iand and shifts etc
*/

      case iadd:
      {
        optop--;
        *optop = *optop + *(optop + 1);
        break;
      }
      case ladd: 
      {
	optop -= 2;

	*((long long*) (optop - 1)) = *((long long*) (optop - 1)) + *((long long*) (optop + 1));
	break;
      }
      case fadd:
      {
				union {float f; int32 i;} ui32fConv1;
				union {float f; int32 i;} ui32fConv2;

				optop--;
				ui32fConv1.i = *optop;
				ui32fConv2.i = *(optop + 1);
				ui32fConv1.f += ui32fConv2.f;
				*optop = ui32fConv1.i;
				break;
      }
      case dadd:
      {
				union {double d; int32 i[2];} ui64dConv1;
				union {double d; int32 i[2];} ui64dConv2;

				optop -= 2;
				ui64dConv1.i[0] = *(optop - 1);
				ui64dConv1.i[1] = *optop;
				ui64dConv2.i[0] = *(optop + 1);
				ui64dConv2.i[1] = *(optop + 2);
				ui64dConv1.d += ui64dConv2.d;
				*(optop - 1) = ui64dConv1.i[0];
				*optop = ui64dConv1.i[1];
				break;
			}
      case isub:
      {
        optop--;
        *optop = *optop - *(optop + 1);
        break;
      }
      case lsub:
      {
				optop -= 2;
				
				*((long long*) (optop - 1)) = *((long long*) (optop - 1)) - *((long long*) (optop + 1));
				break;
      }
      case fsub:
      {
				union {float f; int32 i;} ui32fConv1;
				union {float f; int32 i;} ui32fConv2;

				optop--;
				ui32fConv1.i = *optop;
				ui32fConv2.i = *(optop + 1);
				ui32fConv1.f -= ui32fConv2.f;
				*optop = ui32fConv1.i;
				break;
			}
      case dsub:
      {
	/*
				union {double d; int32 i[2];} ui64dConv1;
				union {double d; int32 i[2];} ui64dConv2;

				optop -= 2;
				ui64dConv1.i[0] = *(optop - 1);
				ui64dConv1.i[1] = *optop;
				ui64dConv2.i[0] = *(optop + 1);
				ui64dConv2.i[1] = *(optop + 2);
				ui64dConv1.d -= ui64dConv2.d;
				*(optop - 1) = ui64dConv1.i[0];
				*optop = ui64dConv1.i[1];
				*/
	optop -= 2;
	*((double*) (optop - 1)) = *((double*) (optop - 1)) - *((double*) (optop + 1));
	break;
      }
      case imul:
      {
        optop--;
        *optop = *optop * *(optop + 1);
        break;
      }
      case lmul: 
      {
	optop -= 2;
				
	*((long long*) (optop - 1)) = *((long long*) (optop - 1)) * *((long long*) (optop + 1));
	break;
      }
      case fmul:
      {
	union {float f; int32 i;} ui32fConv1;
	union {float f; int32 i;} ui32fConv2;

	optop--;
	ui32fConv1.i = *optop;
	ui32fConv2.i = *(optop + 1);
	ui32fConv1.f *= ui32fConv2.f;
	*optop = ui32fConv1.i;
	break;
      }
      case dmul:
      {
				union {double d; int32 i[2];} ui64dConv1;
				union {double d; int32 i[2];} ui64dConv2;

				optop -= 2;
				ui64dConv1.i[0] = *(optop - 1);
				ui64dConv1.i[1] = *optop;
				ui64dConv2.i[0] = *(optop + 1);
				ui64dConv2.i[1] = *(optop + 2);
				ui64dConv1.d *= ui64dConv2.d;
				*(optop - 1) = ui64dConv1.i[0];
				*optop = ui64dConv1.i[1];
				break;
			}
			case idiv:
			{
				optop--;
				if (*(optop + 1))
				{
					*optop = *optop / *(optop + 1);
        }
        else
        {
          SAVEENV();
          pstCurrFrame = ThrowNamedException(env, pstCurrFrame, "java/lang/ArithmeticException");
          LOADENV();
        }
        break;
      }
      case ldiv_:
      {
				optop -= 2;
		#ifdef KISSME_LINUX_USER		
				*((long long*) (optop - 1)) = *((long long*) (optop - 1)) / *((long long*) (optop + 1));
#else
   eprintf("ldiv not supported in this kernel\n");
				*((long long*) (optop - 1)) = 0;
#endif
				break;
			}
case fdiv:
{
  union {float f; int32 i;} ui32fConv1;
  union {float f; int32 i;} ui32fConv2;
  
  optop--;
  ui32fConv1.i = *optop;
  ui32fConv2.i = *(optop + 1);
#ifdef KISSME_LINUX_USER
  ui32fConv1.f /= ui32fConv2.f;
#else
   eprintf("fdiv not supported in this kernel\n");
   ui32fConv1.f = 0;
#endif
  *optop = ui32fConv1.i;
  break;
}
case ddiv:
{
  optop -= 2;
#ifdef KISSME_LINUX_USER
  *((double*) (optop - 1)) = *((double*) (optop -1)) / *((double*) (optop + 1));
#else
  eprintf("ddiv not supported in this kernel\n");
  *((double*) (optop - 1)) = 0;
#endif
  break;
}
case imod:
{
  optop--;
  if (*(optop + 1))
    {
      *optop = *optop % *(optop + 1);
    }
  else
    {
      SAVEENV();
      pstCurrFrame = ThrowNamedException(env, pstCurrFrame, "java/lang/ArithmeticException");
      LOADENV();
    }
  break;
}
case lmod:
{
  optop -= 2;
#ifdef KISSME_LINUX_USER				
  *((long long*) (optop - 1)) = *((long long*) (optop - 1)) % *((long long*) (optop + 1));
#else
  eprintf("lmod not supported\n");
  *((long long*) (optop - 1)) = 0;
#endif
  break;
}
case fmod_:
{
#ifdef KISSME_LINUX_USER
  union {float f; int32 i;} ui32fConv1;
  
  optop--;
  ui32fConv1.f = fmod(*optop, *(optop + 1));
  *optop = ui32fConv1.i;
#else
  *optop = 0;
#endif
  break;
}
case dmod:
{
#ifdef KISSME_LINUX_USER
  union {double d; int32 i[2];} ui64dConv1;
  union {double d; int32 i[2];} ui64dConv2;

  optop -= 2;
  ui64dConv1.i[0] = *(optop - 1);
  ui64dConv1.i[1] = *optop;
  ui64dConv2.i[0] = *(optop + 1);
				ui64dConv2.i[1] = *(optop + 2);
				ui64dConv1.d = fmod(ui64dConv1.d, ui64dConv2.d);
				*(optop - 1) = ui64dConv1.i[0];
				*optop = ui64dConv1.i[1];
#else
				*optop = 0;
#endif
				break;
}
case ineg:
{
  *optop = -*optop;
  break;
}
case lneg:
{
  long long* longval = (long long*) (optop - 1);
  *longval = -(*longval);

//  ARITH64_lneg(*(optop-1), *optop, (optop-1), (uint32*)optop);
  break;
      }
      case fneg:
      {
				union {float f; int32 i;} ui32fConv1;

				ui32fConv1.i = *optop;
				ui32fConv1.f = -ui32fConv1.f;
				*optop = ui32fConv1.i;
				break;
			}
			case dneg:
      {
				union {double d; int32 i[2];} ui64dConv1;

				ui64dConv1.i[0] = *(optop - 1);
				ui64dConv1.i[1] = *optop;
				ui64dConv1.d = -ui64dConv1.d;
				*(optop - 1) = ui64dConv1.i[0];
				*optop = ui64dConv1.i[1];
				break;
			}
			case ishl:
			{
			    optop--;
			    *optop = *optop << (*(optop + 1) & 0x1f);  //(is decimal 31)
			    break;
			}
case lshl:
      {
	long long* shiftword = (long long*) (optop - 2);
	uint32 shiftamount = (*optop & 0x3f); //the bottom 6 bits
        *shiftword = (*shiftword << shiftamount);						  
	optop--;
	/*
        optop--;
        ARITH64_lshl(*(optop-1), *optop, *(optop+1), (uint32*)(optop-1), (uint32*)optop);
	*/
        break;
      }
      case ishr:
      {
        optop--;
        *optop = *optop >> (*(optop + 1) & 0x1f); //(is decimal 31)
        break;
      }
      case lshr: 
      {
	long long* shiftword = (long long*) (optop - 2);
	uint32 shiftamount = (*optop & 0x3f); //the bottom 6 bits
	if(*shiftword < 0)
	  {
//	    *shiftword = -1 * ((-(*shiftword)) >> (shiftamount));
	    *shiftword = (*shiftword) >> (shiftamount);
	  }
	else
	  {
	    *shiftword = (*shiftword >> shiftamount);						  
	  } 
	optop--;
        break;
      }
      case iushr:
      {
        optop--;
        *optop = ((unsigned long) *optop) >> (*(optop + 1) & 31);
        break;
      }
      case lushr: 
      {
	unsigned long long* shiftword = (unsigned long long*) (optop - 2);
	uint32 shiftamount = (*optop & 0x3f); //the bottom 6 bits
        *shiftword = (*shiftword >> shiftamount);						  
	optop--;
        break;
      }
      case iand:
      {
        optop--;
        *optop = *optop & *(optop + 1);
        break;
      }
      case land:
      {
	*((long long*) (optop - 3)) = *((long long*) (optop - 3)) & *((long long*) (optop - 1));
        optop -= 2;
//        *optop = *optop & *(optop + 2);
//        *(optop - 1) = *(optop - 1) & *(optop + 1);
        break;
      }
      case ior:
      {
        optop--;
        *optop = *optop | *(optop + 1);
        break;
      }
      case lor:
      {
	*((long long*) (optop - 3)) = *((long long*) (optop - 3)) | *((long long*) (optop - 1));
        optop -= 2;

//        optop -= 2;
//        *optop = *optop | *(optop + 2);
//        *(optop - 1) = *(optop - 1) | *(optop + 1);
        break;
      }
      case ixor:
			{
        optop--;
        *optop = *optop ^ *(optop + 1);
        break;
      }
      case lxor:
      {
	*((long long*) (optop - 3)) = *((long long*) (optop - 3)) ^ *((long long*) (optop - 1));
        optop -= 2;

	/*        optop -= 2;
        *optop = *optop ^ *(optop + 2);
        *(optop - 1) = *(optop - 1) ^ *(optop + 1);
	*/
        break;
      }
      case iinc:
      {
        if (pbPC[1] & 0x80)   /* to see if it's negative */
        {
          pi32Vars[*pbPC] += (pbPC[1] - 256);
        }
        else
        {
          pi32Vars[*pbPC] += pbPC[1];
        }
        pbPC += 2;
        break;
      }
