 /* Routines to manage the old heap */

#include <config.h>

#ifdef GARBAGE2

#ifdef KISSME_LINUX_USER
#include <stdio.h>
#include <assert.h>
#endif

#include "stdtypes.h"


#include "public_methods.h"
#include "bitfield.h"
#include "oldheap.h"
#include "garbage.h"
#include "garbage2.h"
#include "rpot.h"

#include "garbage_defs.h"
#include "interp.h" //for tObject*

#include "../../lib/indigenous/java.lang/Class.h"
int highest_block;


int OLDHEAP_Init(tAllocatorHeap* heap)
{
 int i;

 highest_block = 0;
 //Clean the bitfield for our words
 for(i = (heap->i32OldHeapSize - 1); i >= 0; i--)
   {
     OLD_CLEAR_BIT( i ); //Clear the bit for word i in the old heap
   }
 //We simply indicate that the whole heap is free
 heap->pi32OldHeap[0] = heap->i32OldHeapSize;
 heap->pi32OldHeap[1] = (int32) NULL; //next pointer is NULL
 heap->pi32OldFirstFree = heap->pi32OldHeap;				 
 return 0;
}

/* Allocates space for an object. Allocates i32NumWords of space 
 *
 * Whenever we allocate an object, we mark the first word of that object as used in the bitfield (the word before it is the size)
 */

tOBREF OLDHEAP_AllocObject(tAllocatorHeap* heap, int32 i32NumWords)
{
  tOBREF hHandle;
  int32* pi32TempFS;

  if(i32NumWords < 1)
    {
      assert(1 == 2);
      return NULL;
    }

  hHandle = HANDLES_getFreeHandle( heap );

  if(hHandle == NULL)
    {
      eprintf("No more free handles, gc'ing \n");
      GARBAGE_UNLOCK(heap);
      GARBAGE_NeedGC( heap, i32NumWords );
      GARBAGE_LOCK(heap);

      hHandle = HANDLES_getFreeHandle( heap );

      if(hHandle == NULL)
	{ 
	  eprintf("Still no more free handles, giving up\n");
	  return NULL;
	}
    }

  /* garbage collect if free space is not big enough */
  if (heap->pi32OldFirstFree[0] < i32NumWords)
    {
#ifdef GARBAGE_VERBOSE
      eprintf("Run out of space, must GC (our tid %x %i)\n", (int) sys_current_thread(), (int) sys_current_thread());
#endif

      GARBAGE_UNLOCK(heap);
      GARBAGE_NeedGC( heap, i32NumWords );
      GARBAGE_LOCK(heap);

      if (heap->pi32OldFirstFree[0] < i32NumWords)
	{
#ifdef GARBAGE_VERBOSE
	  eprintf("Still not enough space\n");
#endif
	  return NULL;
	}
    }

  /* store current beginning of free space (will be beginning of new object) */
  pi32TempFS = heap->pi32OldFirstFree;
  /* move beginning of free space to after object */
  heap->pi32OldFirstFree += i32NumWords;
  /* store size of smaller free space */
  heap->pi32OldFirstFree[0] = pi32TempFS[0] - i32NumWords;
  /* store size of new allocated bit */
  pi32TempFS[0] = i32NumWords;

  /* mark this space in the bit field */
  OLD_SET_BIT( ((pi32TempFS + 1) - heap->pi32OldHeap) );

//  eprintf("Marked bit block %x\n", (((pi32TempFS + 1) - heap->pi32OldHeap)) / 32);

  highest_block = (((pi32TempFS + 1) - heap->pi32OldHeap)) / 32;
  *hHandle = (tObject*) (pi32TempFS + 1);
  PDEREF(hHandle)->hHandle = hHandle;

  assert(ALLOCATOR_ISHANDLE(heap,  hHandle ) == 1); //just for debugging
  return hHandle; //pi32TempFS + 1;
}

int OLDHEAP_ISHANDLE(tAllocatorHeap* heap, tOBREF h)
{
  if( HANDLES_InHandleBlock( heap, h ))
    {
//      if(*h == 0)
//	return 1;
      if(  ((int32*) (*h) >= heap->pi32OldHeap) && (((int32*) (*h) < (heap->pi32OldHeap + heap->i32OldHeapSize))))
	return 1;
      else
	return 0;
    }
  else
    return 0;
}

int OLDHEAP_TestBitfield(tAllocatorHeap* heap) 
{
int i = 0;
int word;
for(i = 0; i < 33; i++)
  {
   word = 3008;
   /*  OLD_SET_BIT(word);
  if( IS_OLD_BIT_SET(word))
    {
      eprintf("Test 1 passed\n");
    }
  OLD_CLEAR_BIT(word);
  if( IS_OLD_BIT_SET(word) == 0)
    {
      eprintf("Test 2 passed\n");
    }
    */
  //eprintf("Word is at %i (%x) %i\n", word, heap->pi32Block[word / 32 + heap->i32YoungHeapBFSize], (word) / 32 + heap->i32YoungHeapBFSize);
  OLD_SET_BIT(word + i);
  eprintf("Word is at %i (%x) %i\n", (int) word + i, (int) heap->pi32Block[(word + i) / 32 + heap->i32YoungHeapBFSize], (int) ((word + i) / 32 + heap->i32YoungHeapBFSize));
  }
  word = 0;
  OLD_SET_BIT(word);
  if( IS_OLD_BIT_SET(word))
    {
      eprintf("Test 1 passed\n");
    }
  OLD_CLEAR_BIT(word);
  if( IS_OLD_BIT_SET(word) == 0)
    {
      eprintf("Test 2 passed\n");
    }

  eprintf("Word is at %i (%x) %i\n", word, (int) (heap->pi32Block[word / 32 + heap->i32YoungHeapBFSize]), (int) ((word) / 32 + heap->i32YoungHeapBFSize));
  OLD_SET_BIT(word);
  eprintf("Word is at %i (%x) %i\n", (int) word, (int) (heap->pi32Block[word / 32 + heap->i32YoungHeapBFSize]), (int) ((word) / 32 + heap->i32YoungHeapBFSize));

  return 0;
}

int OLDHEAP_SweepAndCompact(tAllocatorHeap* heap)
{
  int32       i, j;
  int32*      pi32NewTop;
  tObject*    pstOldLoc;     /* object's old location */
  tObject*    pstNewLoc;     /* object's new location */
  int x;
  int iCopySize, iSpaceSize;

#ifdef GARBAGE_VERBOSE
  eprintf("DOING SWEEP AND COMPACT\n");
#endif

  /* set "new top" of compacted heap to base of heap */
  pi32NewTop = heap->pi32OldHeap;

  /* go through bitfield of this heap block */
  for (i = 0; i < (heap->i32OldHeapBFSize + 1); i++)
    {
      /* check if there are any bits set in this int32 */
      if( IS_ANY_OLD_BIT_SET( i * 32 ) )
	{
//	    eprintf("A bit set for block %x\n", i);
	    /* find the set bit(s) */
	    for (j = 0; j < 32; j++)
	      {
		//                  if (heap->pi32Block[i + (heap->i32BFSize - heap->i32OldHeapBFSize)] & (((int32) 1L) << j))
		  if( IS_OLD_BIT_SET( i * 32 + j ))
		    {
		      /* check if it's been marked as reachable  - if so, let it live
			 and unset the reachable flag */
		      assert(i >= 0);
		      assert(j >= 0);
		      assert( pi32NewTop >= heap->pi32OldHeap);
		      assert( pi32NewTop <= heap->pi32OldHeap + heap->i32OldHeapSize);

		      //check the magic flags
#ifdef DEBUG_OBJECT_FOR_GC
			  assert( ((tObject*) &heap->pi32OldHeap[32 * i + j])->magic1 == OMAGIC1);
			  assert( ((tObject*) &heap->pi32OldHeap[32 * i + j])->magic2 == OMAGIC2);
#endif

		      if (heap->pi32OldHeap[32 * i + j] & (GARBAGE_REACHABLE | GARBAGE_REACHABLEFROMRPOT))
			{
			  /* unflag */
                          heap->pi32OldHeap[32 * i + j] &= ~(GARBAGE_REACHABLE | GARBAGE_REACHABLEFROMRPOT);

                          /* check if we need to move this object - we move it if there
                             is space between it and the "new top" of the compacted
                             objects (which should be all cases after the first space
                             has been made) */
                          pstOldLoc = (tObject*) &(heap->pi32OldHeap[32 * i + j]);
			  //eprintf("found live object at %x (%s)\n", pstOldLoc, pstOldLoc->pstType->uidName);
			  assert( (((int32*) pstOldLoc) >= heap->pi32OldHeap) && (((int32*) pstOldLoc) <= (heap->pi32OldHeap + heap->i32OldHeapSize)));
                          if (((int32*) pstOldLoc) - 1 != pi32NewTop)
                            {
                              /* clear bit for old position in bitfield */
			       OLD_CLEAR_BIT( i * 32 + j );
                              /* move to new top */
                              /* quick check to see if they overlap - ie if size of object > size of free space */
                              iCopySize = (((int32*) pstOldLoc) - 1)[0];
			      assert(iCopySize >= 0);
			      assert(iCopySize < heap->i32OldHeapSize);

                              iSpaceSize = ((((int32*) pstOldLoc) - 1) - pi32NewTop);
			      assert(iSpaceSize >= 0);
			      assert(iSpaceSize < heap->i32OldHeapSize);
                              if (iCopySize < iSpaceSize)
                                {
                                  /* no overlap... can use memcpy */
                                  memcpy(pi32NewTop, ((int32*) pstOldLoc) - 1, iCopySize * sizeof(int32));

                                  //test
				      //zero the old image
				      memset( ((int32*) pstOldLoc) - 1, 0, iCopySize * sizeof(int32));
                                }
                              else
                                {
                                  /* otherwise do it manually */
                                  for (x = 0; x < iCopySize; x++)
                                    {
                                      pi32NewTop[x] = (((int32*) pstOldLoc) - 1)[x];
                                      //zero old image
					  (((int32*) pstOldLoc) - 1)[x] = 0;
                                    }
                                }
                              /* set bit for new position in bitfield (+1 coz object starts one slot after newtop coz the size gets stored there) */
 			      OLD_SET_BIT( ((pi32NewTop + 1) - heap->pi32OldHeap)) ;

                              /* store new location for convenience */
                              pstNewLoc = (tObject*) (pi32NewTop + 1);
			      assert( (((int32*) pstNewLoc) >= heap->pi32OldHeap) && (((int32*) pstNewLoc) <= (heap->pi32OldHeap + heap->i32OldHeapSize)));
                              /* change handle */
                              if (pstNewLoc->pid == 0)
                                {
                                  /* only change handle here if it's not persistent - otherwise
                                     its handle is in its RPOT entry and is changed later */
                                  *(pstNewLoc->hHandle) = (tObject*) (pi32NewTop + 1);
                                } else {
				  assert ( 7 == 8);
                                }

                              /* change variable / elements pointer */
                              if ((pstNewLoc->i32Flags & GARBAGE_TYPEMASK) == GARBAGE_OBJECT)
                                {
                                  pstNewLoc->pi32Vars = (int32*) (((byte*) pstNewLoc) + ROUND32BIT(sizeof(tObject)));
                                }
                              else
                                {
                                  ((tArray*) pstNewLoc)->pvElements = (void*) (((byte*) pstNewLoc) + ROUND32BIT(sizeof(tArray)));
                                }

#ifdef PERSIST
                              /* Need to update the object's RPOT entry if it is persistent. We
                                 just remove the old entry and insert the new one */
			      if (pstNewLoc->pid)
				{
				  /*   RPOT_Remove(pstNewLoc->pid);
				       rpotelem = RPOT_Add(pstNewLoc->pid, pstNewLoc);
				       pstNewLoc->hHandle = (tOBREF) rpotelem->la;
				       */
				  assert( 1 == 2);
				}
#endif

			    } //ends check for moving

			      /* change new top by adding size of object that is after it... this
				 might be an object that has just been moved there or it might be
				 an object that was always there (if no objects have been thrown
				 away yet) */
			      assert(pi32NewTop[0] > 0);
			    pi32NewTop += pi32NewTop[0];
			}
		      else
			{
			  /* it's unreachable so we throw it away */
			  /* clear bit in bitfield */
			  OLD_CLEAR_BIT( i * 32 + j );
//			  eprintf("Cleared bit %i in block %x\n", (int) j, (int) i);
			  //			  heap->pi32Block[i + (heap->i32BFSize - heap->i32OldHeapBFSize)] &= ~(((int32) 1L) << j);
			  
			  /* run finalize method if there is one */
			  pstOldLoc = (tObject*) &(heap->pi32OldHeap[32 * i + j]);
			  assert( (((int32*) pstOldLoc) >= heap->pi32OldHeap) && (((int32*) pstOldLoc) <= (heap->pi32OldHeap + heap->i32OldHeapSize)));
			  if(strcmp(pstOldLoc->pstType->uidName, "java/lang/Class") == 0)
			    {
			      tJNIData* pstJNIData;
			      tClassLoaderTuple* tuple;
			      pstJNIData = JNI_getJNIData(sys_current_thread());
			      tuple = CLASS_GetClassStruct(&pstJNIData->functions, pstOldLoc->hHandle);
			      
			      eprintf("GC'ing class object %p for class %s (%p)\n", pstOldLoc->hHandle, tuple->uidName, tuple->classLoader);
			    }
			  //free the condition variable
#ifdef IN_PLACE_CONDITION
#else
sys_condition_destroy(pstOldLoc->condVariable);
#endif
			  pstOldLoc->condVariable = NULL;
#ifdef DEBUG_OBJECT_FOR_GC
			  assert( pstOldLoc->magic1 == OMAGIC1);
			  assert( pstOldLoc->magic2 == OMAGIC2);
#endif

			  //eprintf("Garbage collecting object %p (%s)\n", pstOldLoc->hHandle, pstOldLoc->pstType->uidName);
			  //GARBAGE_VerifyObject( pstTempHB, pstOldLoc );
			  
			  /* write updates to store if we need to */
#ifdef PERSIST
			  /* Stabilise the object that we're throwing away if it's already been
			     promoted (i.e. has a non-NULL PID stored in it. If it is not already
			     persistent then it is not reachable from the root object because it is
			     not reachable from anything in memory. */
			  if (pstOldLoc->pid)
			    {
			      assert( 8 == 9); 
			      RPOT_Stabilise(pstOldLoc);
			      RPOT_Remove(pstOldLoc->pid);
			    }
#endif

			  
			  /* only remove handle if it has no pid, because if it has a pid
			     then it was using the LA field of its RPOT entry as a handle
			     and did not have handle in the handle table */
			  if (pstOldLoc->pid == 0)
			    {
			      /* free the object's handle for reuse */
			      /* The free handle list does not have to be in memory order so we can just
				 add this one to the beginning of the list quickly regardless of where
				 it is in memory */
			      if(heap->hNextFreeHandle)
				{
				  assert( heap->hNextFreeHandle >= (tOBREF) heap->pi32HandleBlock);
				  assert( heap->hNextFreeHandle <= ((tOBREF) (heap->pi32HandleBlock + heap->i32HandleBlockSize)));
				}

			      if( (pstOldLoc->hHandle >= (tOBREF) heap->pi32HandleBlock)
				  && (pstOldLoc->hHandle <= ((tOBREF) (heap->pi32HandleBlock + heap->i32HandleBlockSize))))
				  {
				      *((tOBREF*) pstOldLoc->hHandle) = heap->hNextFreeHandle;
				      heap->hNextFreeHandle = pstOldLoc->hHandle;
				  }
			      assert( heap->hNextFreeHandle >= (tOBREF) heap->pi32HandleBlock);
			      assert( heap->hNextFreeHandle <= ((tOBREF) (heap->pi32HandleBlock + heap->i32HandleBlockSize)));
			    }
			}
		    }
	      }
	  }
    }

heap->pi32OldFirstFree = pi32NewTop;
pi32NewTop[0] = &(heap->pi32OldHeap[heap->i32OldHeapSize - 1]) - pi32NewTop;
pi32NewTop[1] = (int) NULL;

//try and manually zero all the data above NewTop
{
  int32* pointer = pi32NewTop + 1; 
  while(pointer < (heap->pi32OldHeap + heap->i32OldHeapSize))
    {
      *pointer++ = 0;
    }
}
assert(pi32NewTop[0] >= 0);
#ifdef GARBAGE_VERBOSE
eprintf("FINISHED SWEEP AND COMPACT\n");
#endif

return 0;
}



#endif
