#include "kinterface.h"
#include "kimplementation.h"

#ifndef __allocator_heap__
#define __allocator_heap__
/* The JVM never manipulates this structure, it just has to keep a reference to it */

typedef struct tallocatorheap {

  int32* pi32Block;		//Pointer to the big block containing the BF, young heap and old heap
  int32 i32BlockSize;		//Total size of block in words
  int32 i32BFSize;		//Number of words in Bitfield
  int32* pi32YoungHeap;		//Start of the young heap
  int32 i32YoungHeapSize;	//Size of young heap in words
  int32 i32YoungHeapBFSize;	//number of words used in the BF for the young heap

  int32* pi32OldHeap;		//Start of old heap
  int32 i32OldHeapSize;		//Size of old heap in words
  int32 i32OldHeapBFSize;	//number of words used in the BF for the old heap

  int32* pi32OldFirstFree;	//Address of first free space in Old heap

  int32* pi32HandleBlock;	//Pointer to block of handles
  int32 i32HandleBlockSize;	//Size of handle block in words
  tOBREF hNextFreeHandle;	//Pointer to next free handle

  int iDuringGC;		//Flag to indicate if we are busy GCing

  /* Status of heap */
  tMutex* youngMutex;
  tMutex* oldMutex;

  /* Status of heap */
  tCondVariable* gc_point_cond;
  tCondVariable* gc_resume_cond;

  tMutex* gc_wait_mutex;
  tMutex* gc_resume_mutex;

 int threadsPresent; //We record how many threads are present in the GC point
 int threadsRequired; //We record how many threads need to be present in the GC point

  volatile int wantGC;
  volatile int garbageThreadReady; //the garbage thread is ready to be signalled (only set once)
  volatile kuint garbageFinished; //There is no more GC thread

} tAllocatorHeap;

#endif
