/*
 * Copyright (C) 2001, John Leuner.
 *
 * This file is part of the kissme/teaseme project, which in turn is part of the JOS project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2,
 * or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <config.h>

#include "wrappers.h"

#include "garbage.h"
#include "garbage2.h"

#ifdef KISSME_LINUX_KERNEL
#include <asm/semaphore.h>
#include <linux/vmalloc.h>
#endif

#ifdef KISSME_LINUX_USER
#include <stdio.h>
#include <pthread.h>
#endif

#include "stdtypes.h"
#include "interp.h"
#include "classfil.h"
#include "cplist.h"

#include "threadex.h"
#include "garbage.h"
#include "garbage2.h"

#include "global.h"

#ifdef PERSIST
#include "rpot.h"
#endif

#ifndef GARBAGE
#error GARBAGE must be defined when compiling garbage.c
#endif

#include "threads_native.h"

extern int INTERP_DebugOn;

/* local prototypes */

tAllocatorHeap* GARBAGE_Init(void);

Uid uidFinalizePtr;
Uid uidFinalizeSigPtr;

#ifdef RPOTREFS
#define ISHANDLE(x) ((((((int32*) (x)) <= pstHeap->pi32HighestHandle) && (((int32*) (x)) >= pstHeap->pi32LowestHandle))) || (RPOT_InRPOT((void*) (x))) ? 1 : 0)
#else
#define ISHANDLE(x) (((((int32*) (x)) <= pstHeap->pi32HighestHandle) && (((int32*) (x)) >= pstHeap->pi32LowestHandle)) ? 1 : 0)
#endif

#define HEAPBOUND(x) (((((int32*) (x)) <= pstHeap->pi32HeapHighestPoint) && (((int32*) (x)) >= pstHeap->pi32HeapLowestPoint)) ? 1 : 0)

/* procedures */

int32 GARBAGE_INITIALHANDLENUM = 200000; //100000;
int32 GARBAGE_FREEMEM_NUMER = 1;
int32 GARBAGE_FREEMEM_DENOM = 4;
int32 GARBAGE_NUMDEFFRAMES = 10;
int32 GARBAGE_NUMDEFREACH = 3;


/* Sat Jan 29 20:36:39 SAST 2000 - Jewel
 
   Removed a whole lot of code here that was #ifdef'ed PJSLREAL
 */


void static PrintHeapBlocks(tHeapBlock* iter)
{

      eprintf("-------->\nHeap size: %i (words)\nHeap address: %p\nBF Size: %i (words)\nBF address: %x\nFirstFree: %x\nNumber of handles: %i\nAddress of first free handle: %x\nNext block %x\n", (int) iter->i32HeapSize, iter->pi32Heap, (int) iter->i32BFSize, (int) iter->pi32BitField, (int) iter->pi32FirstFree, (int) iter->i32NumHandles, (int) iter->hFirstFreeHandle, (int) iter->pstNext);
      eprintf( "<-------\n");
}

#ifdef ALLOCATOR
void GARBAGE_LOCK(void* pstHeap)
{
  sys_mutex_lock( ((tAllocatorHeap*) pstHeap)->youngMutex);
  sys_mutex_lock( ((tAllocatorHeap*) pstHeap)->oldMutex);
}

void GARBAGE_UNLOCK(void* pstHeap)
{
  sys_mutex_unlock( ((tAllocatorHeap*) pstHeap)->youngMutex);
  sys_mutex_unlock( ((tAllocatorHeap*) pstHeap)->oldMutex);
}

tAllocatorHeap* allocHeap = NULL;

int GARBAGE_getNumFreeWords(JNIEnv* env, tAllocatorHeap* pstHeap)
{
  return ALLOCATOR_getNumFreeWords( (*env)->getHeap() );
}

int GARBAGE_getNumTotalWords(JNIEnv* env, tAllocatorHeap* pstHeap)
{
  return ALLOCATOR_getNumTotalWords( (*env)->getHeap() );
}

int GARBAGE_InHeap(JNIEnv* env, tOBREF obj)
{
  return ALLOCATOR_ISHANDLE( (*env)->getHeap(), obj );
}

int GARBAGE_InSpecifiedHeap(tAllocatorHeap* pstHeap, tOBREF obj)
{
  return ALLOCATOR_ISHANDLE( pstHeap, obj );
}

void GARBAGE_gc(tAllocatorHeap* pstHeap)
{
  int result = ALLOCATOR_gc( pstHeap );
  if(result)
    {
      eprintf("Garbage failed with code %i\n", result);
    }
  return;
}

/* Acquire the mutex before doing gc, for the new GC stuff */

void GARBAGE_lock_and_gc(tAllocatorHeap* pstHeap)
{
  GARBAGE_LOCK(pstHeap);
  GARBAGE_gc(pstHeap);
  GARBAGE_UNLOCK(pstHeap);
}

tOBREF GARBAGE_Malloc(int32        i32Size /* @parm Size of memory required in bytes */, tAllocatorHeap* pstHeap)
{
  tOBREF      hPtr;

  GARBAGE_LOCK(pstHeap);

  /* round required size up to multiple of 4 bytes and keep it expressed in
     a quantity of int32s instead of in bytes... add one to store the size
     of the used block */
  i32Size = ((i32Size + 3) / 4) + 1;


  hPtr = OLDHEAP_AllocObject(pstHeap, i32Size);

  GARBAGE_UNLOCK(pstHeap);

  return hPtr;
  }

void GARBAGE_Finish(tAllocatorHeap* pstHeap )
{
//Stop the garbage thread
    GARBAGE2_Finish(pstHeap);
}

#endif

/*
 * @doc FUNC
 * @func
 * This function is used to initialise the heap. 
 *
 */


tAllocatorHeap* GARBAGE_Init
(
  void
)
{

#ifdef ALLOCATOR 
  tAllocatorHeap* ret;
  ret = ALLOCATOR_Init();
  if(allocHeap == NULL)
    allocHeap = ret;
#ifdef GARBAGE_VERBOSE
  eprintf("Here we are at Init\n");
#endif
  GARBAGE2_Init(ret);
  return ret;
#endif
}

