/*
 * @doc MODULE
 * @module arith64.h |
 *
 * Prototypes of functions for 64-bit integer arithmetic.
 *
 */

#ifndef __ARITH64_H__
#define __ARITH64_H__

#include "stdtypes.h"

void ARITH64_lshl(uint32, uint32, int32, uint32*, uint32*);
void ARITH64_lshr(int32, uint32, int32, int32*, uint32*);
void ARITH64_lushr(uint32, uint32, int32, uint32*, uint32*);
void ARITH64_ladd(int32, uint32, int32, uint32, int32*, uint32*, uint32*);
void ARITH64_lneg(int32, uint32, int32*, uint32*);
void ARITH64_lsub(int32, uint32, int32, uint32, int32*, uint32*, uint32*);
void ARITH64_lmul(uint32, uint32, uint32, uint32, uint32*, uint32*);
void ARITH64_ldiv(int32, uint32, int32, uint32, int32 *, uint32 *);
void ARITH64_lmod(int32, uint32, int32, uint32, int32 *, uint32 *);
int ARITH64_cmp(int32 i32Hi1, uint32 u32Lo1, int32 i32Hi2, uint32 u32Lo2);
double ARITH64_double(int32 hi, uint32 lo);

#endif

