#include <pthread.h>
#include <signal.h>
#include <sys/mman.h>
#include <stdio.h>
#include <assert.h>


#include <limits.h>    /* for PAGESIZE */
       #ifndef PAGESIZE
       #define PAGESIZE 4096
       #endif
         

//We want to investigate how mprotect and SIGSEGV work

int FAULT_ADDRESS = 0xa0000000;

//Evil thread
int violator_thread(void* arg)
{
  int j = 0, i = 0;
  fprintf(stderr, "Violator thread started\n");
  for(i = 0; i < 100000;i++)
    {
      j = i + j;
    }
  fprintf(stderr, "Looped %i times, j is %i\n", i, j);
  fprintf(stderr, "Reading address %x\n", FAULT_ADDRESS);
  i = *((int*) FAULT_ADDRESS);
  fprintf(stderr, "Ending violater thread\n");
}

static int finished = 0;

int seg_handler(int arg)
{
  fprintf(stderr, "SIGSEGV handler %x \n", arg);
  mprotect( FAULT_ADDRESS, 4, PROT_READ | PROT_WRITE);
  finished = 1;
  return 0;
}

int thread_1(int arg)
{
    int start = 0;
    while(1)
	{
	    printf("thread_1: %i\n", start++);
	    usleep(1000);
	}
}       

int thread_2(int arg)
{
    int start = 0;
    while(1)
	{
	    printf("thread_2: %i\n", start++);
	    usleep(1000);
	}
}       



int main(int argc, char** argv)
{
  int result;
  pthread_t one_t;
  pthread_t two_t;

  pthread_create(&one_t, NULL, &thread_1, NULL);
  pthread_create(&two_t, NULL, &thread_2, NULL);

  pthread_kill( one_t, SIGSTOP);
  pthread_kill( two_t, SIGSTOP);
  sleep(5);
  pthread_kill( one_t, SIGCONT);
  pthread_kill( two_t, SIGCONT);
  sleep(5);
}






int oldmain(int argc, char** argv)
{
  int result;
  pthread_t violator_t;
  char* mem_block;
  char* p;

  signal(SIGSEGV, &seg_handler);

  mem_block = malloc( 4096 );
  assert(mem_block);
  FAULT_ADDRESS = mem_block;

  /* Align to a multiple of PAGESIZE, assumed to be a power of two */
  p = mem_block;
  p = (char *)(((int) p + PAGESIZE-1) & ~(PAGESIZE-1));
	            
  FAULT_ADDRESS = p;
  result = mprotect( p, 4 , PROT_NONE);
  if(result)
    perror("Couldn't protect page");
  assert(result == 0);

  pthread_create(&violator_t, NULL, &violator_thread, NULL);
  pthread_join(&violator_t, NULL);
  while(!finished)
    {

    }
}



