#include <config.h>

#ifndef GARBAGE_GENERATIONAL

/*
 * native methods for the plava.PStore class.
 *
 */

#ifndef GARBAGE
#error GARBAGE must be defined for PStore
#endif

/*#ifndef PERSIST
#error PERSIST must be defined for PStore
#endif*/
#ifdef PERSIST

/* just for NULL */
#include <stdlib.h>
#include <stdio.h>

#include "garbage.h"
#include "jni.h"
#include "cplist.h"

#include "store.h"
#include "rpot.h"


 /*
  public native void stabiliseAll();
 */

//Not static
void plava_PStore_stabiliseAll
(
  JNIEnv* env,   /* JNI environment */
  jobject obj    /* target object */
)
{
  RPOT_StabiliseAll();
  //  RPOT_PrintTable();
}
 


jobject plava_PStore_nativeGetRootObject
(
  JNIEnv* env,   /* JNI environment */
  jclass thisClass
)
{
  /* fault in the root object and return its LA */

 
  PID pid;

#ifdef TRACESTORE
  fprintf(stderr, " Calling STORE_GetRootPID\n");
#endif

  pid = STORE_GetRootPID();

#ifdef TRACESTORE
  fprintf(stderr, " STORE_GetRootPID returned %x\n", pid);
#endif
  if (pid)
  {
    return RPOT_FaultObject(pid);
  }
  else
  {
#ifdef TRACESTORE
  fprintf(stderr, " Calling STORE_GetRootPID, but there is no root PID\n");
#endif
    return NULL;
  }
 
}

void plava_PStore_nativeSetRootObject
(
  JNIEnv* env,   /* JNI environment */
  jclass thisclass, //A static method
  jobject obj
)
{

  PID pid;
#ifdef TRACESTORE
  fprintf(stderr, "in nativeSetRootObject, doing STORE_NewObject\n");
#endif


    pid = RPOT_PromoteObject( DEREF(obj)); //STORE_NewObject(sizeof(int32) * ((int32*) DEREF(obj))[-1]);

  //  pid = STORE_NewObject(sizeof(int32) * ((int32*) DEREF(obj))[-1]);
    /*  DEREF(obj)->pid = pid;
  SETFLAG(DEREF(obj), PERSIST_Dirty);
  SETFLAG(DEREF(obj), GARBAGE_PERSISTENT);
  RPOT_Add(pid, DEREF(obj));
    */
#ifdef TRACESTORE
  fprintf(stderr, "in nativeSetRootObject, doing STORE_SetRootPID %x\n", pid);
#endif

  STORE_SetRootPID(pid);

}





#endif


#endif
