class ICMP extends Protocol
{
  private IP ip;

  ICMP(IP ip)
  {
    protocolNumber=0x1;
    next=null;
    this.ip=ip;
  }

  public void Handle(Packet p)
  {
    System.out.println("ICMP Received");
    ICMPPacket icmpp=new ICMPPacket(p);
    System.out.println("ICMP  "+icmpp.toString());
    if (icmpp.wrapper==null) { System.out.println("Null wrapper!");}
    if (icmpp.type==icmpp.TYPE_ECHORQ)
    {
      System.out.println("Sending ECHO REPLY ...");
      ICMPPacket rp = icmpp.reply();
      IPAddr dest=((IPPacket)icmpp.wrapper).src;
      System.out.println("REP "+rp.toString());
      System.out.println("Calling IP.send()");
      ip.send(dest,rp);
    }
  }
};
