#ifdef RAW_NETWORKING
#ifndef USEOSKIT

/*********************************
 * Native Method Implementations *
 *********************************/

#include <jni.h>
#include "EtherHostDriver.h"
#include <stdio.h>

#include <sys/socket.h>
#include <features.h>  
#if __GLIBC__ >= 2 && __GLIBC_MINOR >= 1
#include <netpacket/packet.h>
#include <net/ethernet.h>    
#else
#include <asm/types.h>
#include <linux/if_packet.h>
#include <linux/if_ether.h>  
#endif
#include <linux/ip.h>
#include <linux/tcp.h>
#include <net/if.h>
#include <sys/ioctl.h>

int packet_socket;
char name[16];

JNIEXPORT jint JNICALL Java_EtherHostDriver_read
  (JNIEnv *env, jobject obj, jbyteArray arr, jint nr)
{
  int size;
  jsize len = (*env)->GetArrayLength(env,arr);
  jbyte *array = (*env)->GetByteArrayElements(env, arr, 0);
  /*---array is the buffer to fill with packet data---*/
  /* NOTE: this call will block, don't panic :-)      */
  size = read(packet_socket,array,len);
  /*--------------------------------------------------*/
  (*env)->ReleaseByteArrayElements(env,arr,array,0);
  return size;
}

JNIEXPORT jint JNICALL Java_EtherHostDriver_write
  (JNIEnv *env, jobject obj, jbyteArray arr, jint nr)
{
  int size;
  jsize len = (*env)->GetArrayLength(env,arr);
  jbyte *array = (*env)->GetByteArrayElements(env, arr, 0);
  /*---array is the buffer to write to the raw socket---*/
  size = write(packet_socket,array,len);
  /*--------------------------------------------------*/
  (*env)->ReleaseByteArrayElements(env,arr,array,0);
  return size;
}
                                                                      /* DO NOT EDIT THIS FILE - it is machine generated */
JNIEXPORT jint JNICALL Java_EtherHostDriver_init
  (JNIEnv *env, jobject obj, jstring intf)
{
    struct sockaddr_ll sa;
    struct ifreq ifr;

    const char* ifname = (*env)->GetStringUTFChars(env,intf,0);

    printf("Setting up SOCK_RAW.\n");
    packet_socket = socket(PF_PACKET, SOCK_RAW, htons(ETH_P_ALL));
    if (packet_socket == -1) { printf ("Trouble!\n"); return -1;}
    
    strcpy(ifr.ifr_name,ifname);
    strcpy(name,ifname);
    if (ioctl(packet_socket,SIOCGIFINDEX,&ifr) == -1) {printf("Trouble with GIFINDEX\n");}
    sa.sll_ifindex=ifr.ifr_ifindex;
    sa.sll_family=AF_PACKET;
    sa.sll_protocol=htons(ETH_P_ALL);
    sa.sll_pkttype=PACKET_HOST;
    if (bind(packet_socket,(struct sockaddr *) &sa, sizeof(sa)) !=0) {printf("jdhfjhf\n"); return -1;}
    
    printf("SOCK_RAW handle obtained.\n");
    (*env)->ReleaseStringUTFChars(env, intf, ifname);    

    return 0;
}

JNIEXPORT void JNICALL Java_EtherHostDriver_getHW
  (JNIEnv *env, jobject obj, jbyteArray arr)
{
  jsize len = (*env)->GetArrayLength(env,arr);
  jbyte *array = (*env)->GetByteArrayElements(env, arr, 0);
  struct ifreq ifr;
  strcpy(ifr.ifr_name,name);
  printf("1");
  if (ioctl(packet_socket,SIOCGIFHWADDR,&ifr) == -1) {printf("Trouble with GIFHWADDR\n");}
  printf("1");
  memcpy(array,ifr.ifr_hwaddr.sa_data,6);
  printf("1");
  (*env)->ReleaseByteArrayElements(env,arr,array,0);
}




#endif
#endif
