/*
 * Copyright (C) 2001, John Leuner.
 *
 * This file is part of the kissme/teaseme project, which in turn is part of the JOS project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2,
 * or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <config.h>
/*
 * native stuff for java.lang.Runtime
 *
 */

#ifdef KISSME_LINUX_USER
#include <stdlib.h>
#endif
#include <string.h>


#include "jni.h"
#include "newobject.h"
#include "interp_methods.h"
#include "garbage.h"
#ifdef DLOPEN
  #include <dlfcn.h>
#endif

#include <assert.h>

#ifdef DEBUG
#include <stdio.h>
#endif

#include "jni.h"
#include "interp_methods.h"

#ifdef PERSIST
#include "rpot.h"
#endif

#include "java_lang_Runtime.h"

/*
    private synchronized native String initializeLinkerInternal();
    private native String buildLibName(String pathname, String filename);

    // Helper for load and loadLibrary 
    private native boolean loadFileInternal(String filename);
 
     * Runs the garbage collector.
 
    public native void gc();
    public native void runFinalization();
*/

void Java_java_lang_Runtime_runFinalizersOnExitInternal(JNIEnv* env,jobject obj, jboolean val)
{

  return;
}

void Java_java_lang_Runtime_runFinalization(JNIEnv* env,jobject obj)
{

  return;
}

#include <unistd.h>
#include <stdio.h>



/* Fork and run the process 

   Return a UnixProcess object which has the streams set up to the child's input/output/error.
 */
jobject Java_java_lang_Runtime_execInternal(
JNIEnv* env,
jobject obj,
 jarray arglist, jarray environment)
{
    jobject process;
    jclass processClazz;
    jmethodID processCons;

    int num_args = 0;
    int num_env = 0;
    int i = 0;
    int file_descriptors[6];

    if(arglist)
	num_args = (*env)->GetArrayLength(env, arglist);

    if(environment)
	num_env = (*env)->GetArrayLength(env, environment);

    processClazz = (*env)->FindClass(env,"java/lang/UnixProcess");
    assert(processClazz);
    processCons = (*env)->GetMethodID(env, processClazz, "<init>", "()V");
    assert(processCons);
    process = (*env)->NewObject(env, processClazz, processCons);
    assert(process);
    {
    //We construct an array of char* which are the args

    char** args = (char**) sys_malloc( sizeof(char*) * (num_args + 1));

    assert(args);
    //Now each arg comes from the array
    //The first arg is the path

    for(i = 0; i < (num_args);i++)
	{
	  char* tmp;
	    jstring thestring = (*env)->GetObjectArrayElement(env, arglist, i);

	    args[i] = (char*) sys_malloc( (*env)->GetStringLength(env, thestring));
	    assert(args[i]);

	    tmp = INTERP_AscizFromString(env, thestring);
	    if(tmp)
	      {
		strcpy(args[i], tmp);
		//sys_free(tmp); XXX
	      }
	    else
	      strcpy(args[i], "");
	}
    args[num_args] = NULL;

    {
	int nfd = 0;
	int err;
	pid_t newpid;
	#define IN_IN           0
	#define IN_OUT          1
	#define OUT_IN          2
	#define OUT_OUT         3
	#define ERR_IN          4
	#define ERR_OUT         5  

	/* Create the pipes to communicate with the child */
	/* Make sure fds get closed if we can't create all pipes */
	for (nfd = 0; nfd < 6; nfd += 2) {
                  err = pipe(file_descriptors + nfd);
		  if (err == -1) {
		      close(file_descriptors[0]);
		      close(file_descriptors[1]);
		      close(file_descriptors[2]);
		      close(file_descriptors[3]);
		      close(file_descriptors[4]);
		      close(file_descriptors[5]);


		    //Raise Exception
		    fprintf(stderr, "Error making pipes for child\n");
		    return NULL;
		  }
	}       

	newpid = fork();
	if(newpid == 0) //Then we are the child
	    {
               /* set stdin, stdout, and stderr up from the pipes */
               dup2(file_descriptors[IN_IN], 0);
               dup2(file_descriptors[OUT_OUT], 1);
               dup2(file_descriptors[ERR_OUT], 2); 

	       if(execvp(args[0], args) == -1)
		   {
		       exit(1);
		   }
	    }
	else if(newpid == -1)
	    {
		/* Error */
                /* Close all pipe fds */
                close(file_descriptors[0]);
                close(file_descriptors[1]);
                close(file_descriptors[2]);
                close(file_descriptors[3]);
                close(file_descriptors[4]);
                close(file_descriptors[5]);
	    }
	else
	    {
		/* Parent */
		/* Construct the FileDescriptors for those we do need */
		jobject fd1 = INTERP_NewObjectFromName(env, "java/io/FileDescriptor");
		jobject fd2 = INTERP_NewObjectFromName(env, "java/io/FileDescriptor");
		jobject fd3 = INTERP_NewObjectFromName(env, "java/io/FileDescriptor");
		
		jclass fdClass = (*env)->GetObjectClass(env, fd1);
		jfieldID fid = (*env)->GetFieldID(env, fdClass, "native_fd", "I");
		
		assert(fid);

		(*env)->SetIntField(env, fd1, fid, file_descriptors[IN_OUT]);
		(*env)->SetIntField(env, fd2, fid, file_descriptors[OUT_IN]);
		(*env)->SetIntField(env, fd3, fid, file_descriptors[ERR_IN]);

		/* Now create the streams and set the pid*/
		{
		    jclass unixPClass = (*env)->GetObjectClass(env, process);
		    jmethodID mid = (*env)->GetMethodID(env, unixPClass, "makeStreams", "(Ljava/io/FileDescriptor;Ljava/io/FileDescriptor;Ljava/io/FileDescriptor;)V");
		    jfieldID fid = (*env)->GetFieldID(env, unixPClass, "pid", "I");
		    
		    assert(mid);
		    assert(fid);

		    (*env)->CallVoidMethod(env, process, mid, fd1, fd2, fd3);
		    (*env)->SetIntField(env, process, fid, newpid);
		}
               /* close the fds we won't need */
                close(file_descriptors[IN_IN]);
                close(file_descriptors[OUT_OUT]);
                close(file_descriptors[ERR_OUT]);
	    }
	}
    }    
    //    fprintf(stderr, "Returning %x\n", process);
    return process;
}



// static native String getLibraryPath();            
jstring Java_java_lang_Runtime_getLibraryPath(JNIEnv* env,
jclass class)
{
    return INTERP_NewStringFromAsciz(env, ".");
}

void Java_java_lang_Runtime_gc(JNIEnv* env,
jobject obj
)
{
    //    GARBAGE_gc();
    return;
}

jobject Java_java_lang_Runtime_initializeLinkerInternal(
JNIEnv* env,
jobject obj
)
{
    #ifdef DEBUG
     fprintf(stderr, "java_lang_Runtime_intializeLinkerInternal ...\n");
    #endif


    return INTERP_NewStringFromAsciz(env, "");
}


// native String nativeGetLibname(String pathname, String libname); 

jobject Java_java_lang_Runtime_nativeGetLibname(
JNIEnv* env,
jobject obj,
jobject pathname, 
jobject filename)
{
  char* pathstr = INTERP_AscizFromString(env, pathname);
  char* filestr = INTERP_AscizFromString(env, filename);
  char newName[512];
 
    #ifdef DEBUG
    fprintf(stderr, "java_lang_Runtime_nativeGetLibname %s %s...\n", pathstr, filestr);
    #endif

    strcpy(newName, "./lib");
    strcat(newName, filestr);
    strcat(newName, ".so");
    sys_free(pathstr);
    sys_free(filestr);
    return INTERP_NewStringFromAsciz(env, newName);
}

jint Java_java_lang_Runtime_nativeLoad(
JNIEnv* env,
jobject obj,
jobject filename
)
{
 #ifdef DLOPEN
     char * str = INTERP_AscizFromString(env, filename);

     //   #ifdef DEBUG
    fprintf(stderr, "java_lang_Runtime_nativeLoad %s...\n", str);
    //    return ;
    //   #endif
   
    assert( JNI_NumberLoadedLibraries < 20);

    JNI_DynLoadedLibraries[ JNI_NumberLoadedLibraries ] = dlopen( str, RTLD_LAZY);

    if( JNI_DynLoadedLibraries[ JNI_NumberLoadedLibraries ] == NULL )
	{
	  fprintf(stderr, "Failed to load %s\n", str);
	  fprintf(stderr, "%s", dlerror());
    return JNI_TRUE;
//	    return JNI_FALSE;
	}
    assert( JNI_DynLoadedLibraries[ JNI_NumberLoadedLibraries ] );
    JNI_NumberLoadedLibraries++;
    sys_free(str);
   #endif
    
    return JNI_TRUE;
}


//{"java/lang/Runtime", "traceInstructions", "(Z)V", (void*) Java_java_lang_Runtime_traceInstructions }, 
void Java_java_lang_Runtime_traceInstructions(JNIEnv* env, jclass clazz, jboolean flag)
{

}

//{"java/lang/Runtime", "traceMethodCalls", "(Z)V", (void*) Java_java_lang_Runtime_traceMethodCalls }, 
void Java_java_lang_Runtime_traceMethodCalls(JNIEnv* env, jclass clazz, jboolean flag)
{

}

void Java_java_lang_Runtime_exitInternal
(
  JNIEnv* env,
  jobject ob,
  jint value
)
{
    exit( shutdown_machine(NULL, 1, value));
}


jlong Java_java_lang_Runtime_freeMemory(  JNIEnv* env,
  jobject object)
{
  return GARBAGE_getNumFreeWords(env, (*env)->getHeap()) * 4;
}

jlong Java_java_lang_Runtime_totalMemory(  JNIEnv* env,
  jobject object)
{
  return GARBAGE_getNumTotalWords(env, (*env)->getHeap()) * 4;
}
