#include <config.h> 
/* 
 * @doc MODULE 
 * @module Class.c | 
 * 
 * This file contains native methods for both the Class and ClassLoader classes. 
 * 
 */ 
 
/* 
 * @doc TOPIC 
 * @topic Class Objects | 
 * 
 * When classes are used by Java programs, they are used in the form of Class 
 * objects. This is different to how they are represented internally in the 
 * virtual machine, so when a Class object is needed, we have to create one 
 * as a wrapper around the virtual machine's internal tClass structure. 
 * 
 * The Class object has a private field, classStruct, that stores a pointer to 
 * the tClass structure that the object represents. In turn, the tClass struct 
 * has a pointer, pstClassObject, that will point to the Class object that 
 * represents it if one exists. When a class object is made, it and its 
 * corresponding tClass struct are set to point to one another. When a class 
 * object is needed, a check is first done on the tClass struct to see if 
 * pstClassObject has been set. It it has been set then the Class object to 
 * which it points is used. If it is NULL then a new Class object must be 
 * created. 
 * 
 * Because Class objects are just normal objects, they might be garbage 
 * collected when they are no longer reachable. If this happens, the 
 * pstClassObject pointer in its corresponding tClass structure will be 
 * pointing to garbage (no pun intended). Because of this, the Class class has 
 * a native finalize() method that sets pstClassObject in its tClass struct to 
 * NULL. Then if a Class object for that class is needed again, a new one will 
 * be created. 
 * 
 */ 
 
/* 
  Old methods 
  Native code for java.lang.Class 
 
  class java.lang.Class 
  { 
    private Class(); 
    public static native Class forName(String className) throws ClassNotFoundException; 
    public native Object newInstance(); 
    public native String getName(); 
    public native Class getSuperclass(); 
    public native Class getInterfaces(); 
    public native ClassLoader getClassLoader(); 
    public native boolean isInterface(); 
    public String toString(); 
  } 
 
*/ 
 
#include <stdio.h> 
 
/* New native methods From classpath  
 
//internal 
    private static native void _initC(); 
    protec 
ted native void finalize(); 
	public native String getName(); 
	public native boolean isInterface(); 
	public native Class getSuperclass(); 
	public native Class[] getInterfaces(); 
	public native ClassLoader getClassLoader(); 
	public static native Class forName(String name) throws ClassNotFoundException; 
	public native boolean isInstance(Object o); 
	public native boolean isAssignableFrom(Class c); 
	public native boolean isPrimitive(); 
	public native int getModifiers(); 
	public native Class getDeclaringClass(); 
	public native Class[] getClasses(); 
	public native Class[] getDeclaredClasses() throws SecurityException; 
	public native Constructor getConstructor(Class[] args) throws NoSuchMethodException, SecurityException; 
	public native Constructor getDeclaredConstructor(Class[] args) throws NoSuchMethodException, SecurityException; 
	public native Constructor[] getConstructors() throws SecurityException; 
	public native Constructor[] getDeclaredConstructors() throws SecurityException; 
	public native Method getMethod(String name, Class[] args) throws NoSuchMethodException, SecurityException; 
	public native Method[] getMethods() throws SecurityException; 
	public native Method[] getDeclaredMethods() throws SecurityException; 
	public native Field getField(String name) throws NoSuchFieldException, SecurityException; 
	public native Field getDeclaredField(String name) throws NoSuchFieldException, SecurityException; 
	public native Field[] getFields() throws SecurityException; 
	public native Field[] getDeclaredFields() throws SecurityException; 
 */ 
#include <assert.h> 
#include <stdio.h> 
#include <string.h> 
 
#include "jni.h" 
#include "interp.h" 
#include "interp_methods.h" 
#include "cplist.h" 
#include "jutils.h" 
#include "classfil.h" 
#include "classfile_methods.h" 
#include "newobject.h"
 
#include "global.h" 
 
#include "classex.h" 
#include "VMClassLoader.h" 
#include "uid.h" 

#include "sys_linux_host/wrappers.h"

#include "Class.h"
#include "java_lang_Class.h"
#include "Class_Reflection.h"

extern tClassLoaderTuple* pstClassType; // this can be globally used to get the type for class
extern tOBREF OOMExceptionObject;
 
static struct tclassoffsets 
{ 
  int iClassLoader; 
  int iClassStruct; 
} stClassOffsets; 
 
#define SETCLASSLOADER(obj, i) ((DEREF(obj)->pi32Vars[stClassOffsets.iClassLoader]) = (int32) (i)) 
#define SETCLASSSTRUCT(obj, i) ((DEREF(obj)->pi32Vars[stClassOffsets.iClassStruct]) = (int32) (i)) 
 
#define GETCLASSLOADER(obj)    ((tOBREF) (DEREF(obj)->pi32Vars[stClassOffsets.iClassLoader])) 
#define GETCLASSSTRUCT(obj)    ((tClassLoaderTuple*) (DEREF(obj)->pi32Vars[stClassOffsets.iClassStruct])) 
 
 
#ifdef PRELOAD 
#define SETSTRUCTOBJPTR(cla, obj) {if ((cla)->bPreloaded) \ 
                                   { \ 
                                     INTERP_ppstGlobalClassObjects[(cla)->i32ClassObjectOffset] = (obj); \ 
                                   } \ 
                                   else \ 
                                   { \ 
                                     (cla)->pstClassObject = (obj); \ 
                                   } \ 
                                  } 
#else 
#define SETSTRUCTOBJPTR(cla, obj) ((cla)->classObject = (obj)); 
#endif 
 
#ifdef PRELOAD 
#define GETSTRUCTOBJPTR(cla) ((cla)->bPreloaded ? \ 
                               INTERP_ppstGlobalClassObjects[(cla)->i32ClassObjectOffset] : \ 
                               (cla)->classObject) 
 
#else 
#define GETSTRUCTOBJPTR(cla) ((cla)->classObject) 
#endif 
 
//Jewel 
void CLASS_SetClassStruct(jclass object, tClassLoaderTuple* point) 
{ 
    SETCLASSSTRUCT(object,point); 
} 
 
tClassLoaderTuple* CLASS_GetClassStruct(JNIEnv* env, jclass clazz) 
{ 
   return GETCLASSSTRUCT(clazz); 
} 

void CLASS_SetClassLoader(jclass object, tOBREF point) 
{ 
    SETCLASSLOADER(object,point); 
} 
 
 
/* 
 * @doc NATFUNC 
 * @func 
 * Implementation of: private static native void initC(); 
 * 
 * Initialises the C variables in the Class class. 
 * 
 */ 
 
void Java_java_lang_Class__1initC 
( 
  JNIEnv* env, 
  jclass class 
) 
{ 
  tClassLoaderTuple* pstClassClass; 
 
  //  fprintf(stderr, "Class initC, CALLING YOUR NUMBER\n"); 
 if(pstClassType == NULL)
   pstClassClass = CLASSFILE_FindOrLoad(env, "java/lang/Class", NULL);
 else
  pstClassClass = pstClassType; //CLASSFILE_FindOrLoad(env, "java/lang/Class"); 
 
  //  printf("Got java/lang/Class\n"); 
 
 
  stClassOffsets.iClassLoader = CLASSFILE_InstFieldOffset(env, pstClassClass, "_classLoader")->u16Offset; 
  stClassOffsets.iClassStruct = CLASSFILE_InstFieldOffset(env, pstClassClass, "_classStruct")->u16Offset; 
 
 
  //  printf("Class initC finished\n"); 
} 
 
 
/* 
 * @doc NATFUNC 
 * @func 
 * Implementation of: public native String getName(); 
 * 
 
 * 
 * Hmm let's use a static buffer here, but then that's not exactly thread-safe? 
 * 
 
 * Returns the name of this class. 
 * 
 */ 
 
static char str_buffer[4096]; 
 
jobject Java_java_lang_Class_getName 
( 
  JNIEnv* env, 
  jobject obj 
) 
{ 
  tClassLoaderTuple* pstClass = GETCLASSSTRUCT(obj); 
  jobject ret; 
   int i; 
//   fprintf(stderr, "Returing name for class %s\n", pstClass->uidName); 

  strcpy(str_buffer, pstClass->uidName); 
  for( i = 0; i < strlen(str_buffer);i++) 
      if(str_buffer[i] == '/') 
	  str_buffer[i] = '.'; 
 
  ret = INTERP_NewStringFromAsciz(env, str_buffer); 
  return ret; 
} 
 
 
/* 
 * @doc NATFUNC 
 * @func 
 * Implementation of: public native boolean isInterface(); 
 * 
 * Returns true if this class is an interface class, false otherwise. 
 * 
 */ 
 
jboolean Java_java_lang_Class_isInterface 
( 
  JNIEnv* env, 
  jobject obj 
) 
{ 
  if (GETCLASSSTRUCT(obj)->pstClass->u16AccessFlags & ACC_INTERFACE) 
  { 
    return JNI_TRUE; 
  } 
  else 
  { 
    return JNI_FALSE; 
  } 
} 
 
/* 
 * @doc NATFUNC 
 * @func 
 * Implementation of: public native Class getSuperclass(); 
 * 
 * Returns the class object of this class's superclass. 
 * 
 */ 
 
jclass Java_java_lang_Class_getSuperclass 
( 
  JNIEnv* env, 
  jobject obj 
) 
{ 
  tOBREF pstSuperObject; 
  tClassLoaderTuple*  pstSuperClass; 
 
  pstSuperClass = GETCLASSSTRUCT(obj)->pstClass->pstSuperClass; 
 
  if(pstSuperClass == 0) 
      return NULL; 
 
  if (GETSTRUCTOBJPTR(pstSuperClass)) 
  { 
    return GETSTRUCTOBJPTR(pstSuperClass); 
  } 
  else 
  { 
    pstSuperObject = INTERP_NewObjectFromName(env, "java/lang/Class"); 
    SETCLASSSTRUCT(pstSuperObject, pstSuperClass); 
    SETSTRUCTOBJPTR(pstSuperClass, pstSuperObject); 
    return pstSuperObject; 
  } 
} 
 
 
/* 
 * @doc NATFUNC 
 * @func 
 * Implementation of: public native Class getInterfaces()[]; 
 * 
 * Returns an array containing the class structures of this class's interfaces. 
 * 
 */ 
 
jarray Java_java_lang_Class_getInterfaces 
( 
  JNIEnv* env, 
  jobject obj 
) 
{ 
  tOBREF pstTempObject; 
  tClassLoaderTuple*  pstClass = GETCLASSSTRUCT(obj); 
  tClassLoaderTuple*  pstInterface; 
  tARREF  pstInterfaceArray; 
 
  int i; 
 
  if (pstClass->pstClass->u16InterfacesCount == 0) 
  { 
    pstInterfaceArray = (*env)->NewObjectArray(env, 0, (*env)->FindClass(env, "java/lang/Class"), NULL);
  } 
  else 
  { 
    pstInterfaceArray = (*env)->NewObjectArray(env, pstClass->pstClass->u16InterfacesCount, (*env)->FindClass(env, "java/lang/Class"), NULL);
//    pstInterfaceArray = INTERP_NewArray(T_OBJECT, pstClass->u16InterfacesCount, "[Ljava/lang/Object"); 

    for (i = 0; i < pstClass->pstClass->u16InterfacesCount; i++) 
    { 
      pstInterface = pstClass->pstClass->ppstInterfaces[i]; 
      pstTempObject = INTERP_NewObjectFromName(env, "java/lang/Class"); 
      SETCLASSSTRUCT(pstTempObject, pstInterface); 
      SETSTRUCTOBJPTR(pstInterface, pstTempObject); 
      (*env)->SetObjectArrayElement(env, pstInterfaceArray, i, pstTempObject);
    } 
  } 
  return pstInterfaceArray; 
} 
 
/* 
 * @doc NATFUNC 
 * @func 
 * Implementation of: public native ClassLoader getClassLoader(); 
 * 
 * Returns this class's classloader. 
 * 
 */ 
 
jobject Java_java_lang_Class_getClassLoader 
( 
  JNIEnv* env, 
  jobject obj 
) 
{ 
  return GETCLASSLOADER(obj); 
} 
 
 
 
/*New methods for classpath natives */ 
 
//	public native boolean isInstance(Object o); 
 
jboolean Java_java_lang_Class_isInstance 
( 
  JNIEnv* env, 
  jobject clazz, 
  jobject obj) 
{ 
  tClassLoaderTuple* desiredClass;
  tClassLoaderTuple* suppliedClass;

  desiredClass = GETCLASSSTRUCT(clazz); 
 
  if(obj == NULL)
    return JNI_FALSE; //NULL object is not an instanceof of anything?

  suppliedClass = ODEREF(obj)->pstType;

  if( INTERP_CheckCast(env, desiredClass, suppliedClass) == 1)
    {
      return JNI_TRUE;
    }
  return JNI_FALSE;
} 
 
 
jboolean Java_java_lang_Class_isAssignableFrom(  JNIEnv* env,  jclass clazz,  jclass clazz2) { 
 
  return (*env)->IsAssignableFrom(env, clazz, clazz2); 
} 
 
//This is NOT static  
 
/* Takes a java.lang.Class object and returns true if it represents a primitive type 
 *
 * This could be made faster with a helper method from VMClassLoader
 * (another alternative is an ACC_PRIMITIVE check!)
 *
 */ 
 
jboolean Java_java_lang_Class_isPrimitive( JNIEnv* env,  jobject clazz) { 
 
    jclass clazzClazz; 
    jfieldID fieldID; 
    tClassLoaderTuple* compClass; 
 
    clazzClazz = (*env)->GetObjectClass(env, clazz); 
    fieldID = (*env)->GetFieldID(env, clazzClazz, "_classStruct", "I"); 
    assert(fieldID); 
     
    compClass = (tClassLoaderTuple*) (*env)->GetIntField(env, clazz, fieldID); 
     
    //    assert(5 == 6); 
    if(strcmp(compClass->uidName, "float") == 0) 
	{ 
	    return 1; 
	} 
    else if(strcmp(compClass->uidName, "boolean") == 0) 
	{ 
	    return 1; 
	} 
    else if(strcmp(compClass->uidName, "int") == 0) 	{ 
	    return 1; 
	} 
    else if(strcmp(compClass->uidName, "short") == 0) 
	{ 
	    return 1; 
	} 
    else if(strcmp(compClass->uidName, "char") == 0) 
	{ 
	    return 1; 
	} 
    else if(strcmp(compClass->uidName, "long") == 0) 
	{ 
	    return 1; 
	} 
    else if(strcmp(compClass->uidName, "byte") == 0) 
	{ 
	    return 1; 
	} 
    else if(strcmp(compClass->uidName, "double") == 0) 
	{ 
	    return 1; 
	} 
    else if(strcmp(compClass->uidName, "void") == 0) 
	{ 
	    return 1; 
	} 
    return 0; 
} 
 
jint Java_java_lang_Class_getModifiers( JNIEnv* env,  jclass clazz) { 
 
    jclass clazzClazz; 
    jfieldID fieldID; 
    tClassLoaderTuple* compClass; 
 
    clazzClazz = (*env)->GetObjectClass(env, clazz); 
    fieldID = (*env)->GetFieldID(env, clazzClazz, "_classStruct", "I"); 
    assert(fieldID); 
 
    compClass = (tClassLoaderTuple*) (*env)->GetIntField(env, clazz, fieldID); 
    assert(compClass); 
 
    return compClass->pstClass->u16AccessFlags; //XXX is this right?, perhaps we should mask some out? 
} 
 
jclass Java_java_lang_Class_getDeclaringClass( JNIEnv* env,  jclass clazz) { 
 
    return NULL; 
} 
 
jobjectArray Java_java_lang_Class_getClasses( JNIEnv* env,  jclass clazz) { 
	#ifndef USEOSKIT 
    assert(1 == 2); 
#endif 
    return NULL; 
} 
jobjectArray Java_java_lang_Class_getDeclaredClasses( JNIEnv* env,  jclass clazz) { 
	#ifndef USEOSKIT 
    assert(1 == 2); 
#endif 
    return NULL; 
} 



 
 
/* John Leuner oct 99 
 
   Loops through a signature throwing away items until it has counted index items. 
 
   Then it checks the type specified by that item and returns the relevant jclass. 
 
 */ 
 
 
 
 
 
 


 
/* 
 * @doc NATFUNC 
 * @func 
 * Implementation of: public native Object newInstance(); 
 * 
 * Returns an instance of this class. 
 * 
 */ 
 
jobject Java_java_lang_Class_newInstance 
( 
  JNIEnv* env, 
  jobject obj 
) 
{ 
    jclass clazz = obj; 
    jmethodID mid; 
 
    if(clazz) 
	{ 
	    //now construct it 
	    mid = (*env)->GetMethodID(env, obj, "<init>", "()V"); 
	    if(mid) 
		{ 
		    tOBREF newobj = (*env)->NewObject(env, clazz, mid); 
		    return newobj; 
		} 
	    else 
		{ 
		    (*env)->ThrowNew(env, (*env)->FindClass(env, "java/lang/InstantiationException"), "no  noarg constructor"); 
		} 
	} 
    else 
	{ 
	    (*env)->ThrowNew(env, (*env)->FindClass(env, "java/lang/InstantiationException"), "no such type"); 
	} 
  return NULL; 
} 
 
 
/* 
 * @doc NATFUNC 
 * @func 
 * Implementation of: protected native void finalize(); 
 * 
 * This is called when the class is about to be garbage collected. It sets 
 * the pstClassObject field of this class's C class structure to NULL, 
 * indicating that it no longer has a class object. 
 * 
 */ 
 
void Java_java_lang_Class_finalize 
( 
  JNIEnv* env, 
  jobject obj 
) 
{ 
  SETSTRUCTOBJPTR(GETCLASSSTRUCT(obj), NULL); 
} 
 
/* 
 * @doc FUNC 
 * @func 
 * Returns the class object representing the class of the specified object. A 
 * new class object is created if one does not already exist. 
 * 
 */ 
  
tOBREF CLASS_GetClass 
( 
  JNIEnv* env,
  tOBREF pstObject   /* @parm Object of which to get Class object */ 
) 
{ 
  tClassLoaderTuple* pstClass; 
  
  pstClass = DEREF(pstObject)->pstType; 
  return CLASS_MakeClassObject(env, pstClass);
  /*
  loader = pstClass->classLoader;
 
  if (pstClass->classObject) 
  { 
    SETCLASSLOADER(pstClass->classObject, loader); 
    return pstClass->classObject; 
  } 
  else 
  { 
    pstClass->classObject = INTERP_NewObjectFromName(env, "java/lang/Class"); 
    SETCLASSSTRUCT(pstClass->classObject, pstClass); 
    SETCLASSLOADER(pstClass->classObject, loader); 
    return pstClass->classObject; 
  } 
  */
} 

/* 
 * @doc FUNC 
 * @func 
 * Returns the class object representing the class of the specified object. A 
 * new class object is created if one does not already exist. 
 * 
 */ 
 
tOBREF CLASS_GetClassFromStruct 
( 
  JNIEnv* env,
  tClassLoaderTuple* pstClass  /* @parm Class structure for which to return an object */ 
) 
{ 
  return CLASS_MakeClassObject(env, pstClass);
  /*  if (pstClass->classObject) 
  { 
    return pstClass->classObject; 
  } 
  else 
  { 
    pstClass->classObject = INTERP_NewObjectFromName(env, "java/lang/Class"); 
    SETCLASSSTRUCT(pstClass->classObject, pstClass); 
    return pstClass->classObject; 
  }*/ 
} 
 
