package kissme_test;

import java.util.Random;

public class RandomTest {

  int counter = 0;
    public void check( int a , int b )  throws ControlException
    {
      check( a == b, counter + " failed");
    }
   public void check( String a , String b )  throws ControlException
    {
      check( a.equals(b), counter + " string is string \"" + a + "\" and \"" + b + "\"");
    }
   public void check( long a , long b )  throws ControlException
    {
      check( a == b, counter + " long is long " + a + " and " + b);
    }
   public void check( double a , double b )  throws ControlException
    {
      check( Math.abs(a - b) > 0.02, counter + " double is double " + a + " and " + b);
    }
    public void check( boolean arg, String method ) throws ControlException
    {
      counter++;
	if(!arg)
	    throw new ControlException(method + " failed ");
    }

    public static long callme(long a, long b)
    {
	if( (a + b) < 50)
	    return (a+b);
	else
	    return callme( a+b, b);
    }

    public RandomTest() throws ControlException
    { 
      RandomTest harness = this;
      Random rand;

      rand = new Random(122760);
      harness.check (rand.nextInt(), -1524104671);

      long l;
      harness.check (l = rand.nextLong(), 2785759620113032781L);
      
      double d = 0.0;

      harness.check (d = rand.nextDouble(), 0.8173322904425151);

      harness.check (rand.nextFloat(), 0.8239248);

      byte[] b = new byte[0];
      rand.nextBytes(b);
      harness.check (rand.nextInt(), -899478426);

      rand = new Random(122760);
      rand.nextInt();
      rand.nextLong();
      rand.nextDouble();
      rand.nextFloat();
      b = new byte[3];
      rand.nextBytes(b);
      harness.check (b[0], 102);
      harness.check (b[1], 12);
      harness.check (b[2], 99);
      harness.check (rand.nextInt(), -1550323395);
    }
    public static void main(String[] argv) throws ControlException
    {
      	new RandomTest();
    }


}
