package java.awt;

import java.awt.event.InputEvent;
import java.util.Vector;
import java.util.Enumeration;

/* This class receives messages from the input thread and decides how propagate them to the relevant
component
*/

class EventManager {

  private Vector windows; //we keep a list of all the windows, should only be 1

  public void addTopLevelWindow(Window w)
  {
    windows.addElement(w);
  }

  public EventManager()
  {
    windows = new Vector();
  }
  
  public boolean handleInputEvent(InputEvent ie)
  {
    Debug.println("in EventManager.handleInputEvent " + ie);
    Enumeration e = windows.elements();
    while(e.hasMoreElements())
      {
	Component c = (Component) e.nextElement();
	Debug.println("in EventManager.handleInputEvent, component  " + c);
	if( c.getBounds().contains(ie.getPoint()))
	  {
	    c.handleInputEvent(ie);
	    return true;
	  }
      }
    return false;
  }
}

