package kissme.vm.loaders;

public class JavaClassLoader {

  /* These must be kept in sync with those found in the C source */

  public static final int JAR_LOADER_TYPE = 1;
  public static final int ZIP_LOADER_TYPE = 2;
  public static final int HTTP_LOADER_TYPE = 3;

  /**This method creates a loader appropriate to the loader type and tries to load the specified class
   *
   *
   *
   */
  private static byte[] getClassData(String className, String loaderPath, int loader_type)
  {
    switch(loader_type)
      {
      case JAR_LOADER_TYPE:
	{
	  return JarClassLoader.getClassData(className, loaderPath);
	}
      case ZIP_LOADER_TYPE:
	{
	  return ZipClassLoader.getClassData(className, loaderPath);
	}
      case HTTP_LOADER_TYPE:
	{
	  return null;
	}
      }
    throw new IllegalArgumentException("Bad loader type passed to kissme.vm.loaders.JavaClassLoader: " + loader_type);
  }
}

