#ifndef KP_CHART_H_
#define KP_CHART_H_

#include <gdk/gdk.h>
#include <gtk/gtkvbox.h>

#define KP_CHART_ITEMS_MAX      64
#define KP_CHART_GROUPS_MAX     8

enum
{
  GRAPH_TYPE_BARS = 0,
  GRAPH_TYPE_LINES = 1,
  GRAPH_TYPE_STACK_BARS = 2
};

#define KP_TYPE_CHART (kp_chart_get_type())
#define KP_CHART(object) (G_TYPE_CHECK_INSTANCE_CAST ((object), KP_TYPE_CHART, KPChart))
#define KP_CHART_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KP_TYPE_CHART, KPChartClass))
#define KP_IS_CHART(object) (G_TYPE_CHECK_INSTANCE_TYPE ((object), KP_TYPE_CHART))
#define KP_IS_CHART_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KP_TYPE_CHART))
#define KP_CHART_GET_CLASS(object) (G_TYPE_INSTANCE_GET_CLASS ((object), KP_TYPE_CHART, KPChartClass))

typedef struct _KPChart KPChart;
typedef struct _KPChartClass KPChartClass;

struct _KPChart
{
  GtkWidget       parent;
  gpointer        private_data;
};

struct _KPChartClass
{
  GtkWidgetClass  parent_class;

  void            (*kp_chart) (KPChart * kp_chart);
};

typedef enum {
  KP_CHART_TITLE_MONTH,
  KP_CHART_TITLE_WEEKDAY
} KPChartStockTitle;

typedef enum {
  KP_CHART_UNIT_RAW,
  KP_CHART_UNIT_MS,
} KPChartDataUnit;

GType           kp_chart_get_type                (void);
GtkWidget      *kp_chart_new                     (void);

void            kp_chart_set_size                (KPChart *chart,
                                                  gint groups,
                                                  gint items);
void            kp_chart_set                     (KPChart *chart,
                                                  gdouble **data);
void            kp_chart_set_type                (KPChart *,
                                                  gint);
void            kp_chart_set_title               (KPChart *chart,
                                                  const gchar *title);
void            kp_chart_set_group               (KPChart *,
                                                  gint,
                                                  gdouble *);
void            kp_chart_set_group_title         (KPChart *chart,
                                                  guint group,
                                                  const gchar *title);
void            kp_chart_set_group_titles        (KPChart *chart,
                                                  gint groups,
                                                  gchar **titles);
void            kp_chart_set_n_items             (KPChart *chart, guint n);
void            kp_chart_set_n_groups            (KPChart *chart, guint n);
guint           kp_chart_get_n_items             (KPChart *chart);
guint           kp_chart_get_n_groups            (KPChart *chart);

/* Planning */
void            kp_chart_set_param_to_chart      (KPChart *chart,
                                                  const gchar *param);
void            kp_chart_set_chart_mode          (KPChart *chart,
                                                  KPTrainingLogDataMode mode);
void            kp_chart_set_item_title_max_len  (KPChart *chart,
                                                  guint len);
void            kp_chart_set_item_title          (KPChart *chart,
                                                  guint item,
                                                  const gchar *title);
gboolean        kp_chart_set_item_stock_title    (KPChart *chart,
                                                  guint item,
                                                  KPChartStockTitle title,
                                                  guint value);
gboolean        kp_chart_set_item_title_int      (KPChart *chart,
                                                  guint item,
                                                  gint value);
void            kp_chart_set_data_unit           (KPChart *chart,
                                                  KPChartDataUnit unit);
void            kp_chart_update                  (KPChart *chart);

#endif /* KP_CHART_H_ */
