/***************************************************************************
 *   Copyright (C) 2003 by Sylvain Joyeux                                  *
 *   sylvain.joyeux@m4x.org                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#include "parsers.h"

#include <kuserprofile.h>

#include <kio/slavebase.h>
#include <qhtmlstream.h>
#include <qregexp.h>

#include <stdlib.h>

namespace Parsers
{
	static void print_czstring(KIO::SlaveBase& slave, const char* data, int len)
  {
    QByteArray nonull;
    nonull.setRawData(data, len);
    slave.data(nonull);
    nonull.resetRawData(data, len);
  }
  void operator << (KIO::SlaveBase& slave, const QCString& string)
  { print_czstring(slave, string.data(), string.size() - 1); }
  void operator << (KIO::SlaveBase& slave, const QString& string)
  { slave << string.utf8(); }
  void operator << (KIO::SlaveBase& slave, const char* string)
  { print_czstring(slave, string, strlen(string)); }



  Parser::Parser( ) {}
  Parser::~Parser( ) {}

  void Parser::attribute_begin(QHtmlStream& stream, const QString& text)
  {
    stream
      << block("tr") << endl
        << block("td") << param("class") << "attname" << data()
          << text
        << close() << endl
        << block("td");
  }
  void Parser::attribute_end(QHtmlStream& stream)
  { stream << close() << endl << close(); }

// 	void Parser::operator ( )( KIO::SlaveBase * /*slave*/,
//   	const QString & /*tag*/, const QString & /*value*/ )
// 	{}

  QString mangle_version(QString version)
  { return "version_" + version.replace(QRegExp("[-:\\.\\+]"), QString("_")); }

  bool hasPkgManager( )
  {
    // Check if there is an program which can handle
    // application/x-pkgmanager commands
    KService::Ptr service = KServiceTypeProfile::preferredService("application/x-pkgmanager", "Application");
    return (service != 0);
  }

}



