#!/bin/sh

usage()
{
	# Title
	echo "Title: FFMPEG Dual Pass DVD-Video"

	# Usable?
	which ffmpeg > /dev/null
	if [ $? -eq 0 ]; then
		which mplex >/dev/null
		[ $? -eq 0 ] && echo Status: Active || echo Status: Inactive
	else
		echo Status: Inactive
	fi

	# Type
	echo Flags: double-pass file-producer

	# Profiles
	echo "Profile: Standard VOB"
	echo "Profile: Widescreen VOB"
	which dvdauthor > /dev/null
	if [ $? -eq 0 ]; then
		echo "Profile: Standard DVD-Video directory (All only)"
		echo "Profile: Widescreen DVD-Video directory (All only)"
	fi
}

execute()
{
	# Arguments
	normalisation="$1"
	length="$2"
	profile="$3"
	file="$4"
	smil_file="$5"
	pass="$6"
	[ "x$file" = "x" ] && file="kino_export_"`date +%Y-%m-%d_%H.%M.%S`
	file="`dirname \"$4\"`/`basename \"$4\"`"

	# Determine info arguments
	frame_rate=`[ "$normalisation" = "pal" ] && echo 25 || echo 29.97`
	audio_format=`[ "$normalisation" = "pal" ] && echo mp2 || echo ac3`
	audio_bitrate=`[ "$normalisation" = "pal" ] && echo 224 || echo 192`

	# Build path to extract_chapters Perl script
	get_chapters="`dirname $0`/extract_chapters"

	# Prepare temporary files
	M2V="$file.m2v"
	AC3="$file.ac3"
	LOG="$file"

	# Run the command
	case "$profile" in
		"0" )
			if [ $pass -eq "1" ]; then
				ffmpeg -v 0 -f dv -i pipe: -f rawvideo -pix_fmt yuv420p pipe: \
				-vn -f $audio_format -ac 2 -ab $audio_bitrate -ar 48000 -y "$AC3" | \
				ffmpeg -v 0 -f rawvideo -pix_fmt yuv420p -s "$normalisation" -r "$normalisation" -i pipe: \
				-an -target dvd -f mpeg1video -maxrate 8000 -ildct -ilme -aspect 4:3 -pass 1 -passlogfile "$LOG" -y "$M2V"
			else
				if [ $pass -eq "2" ]; then
					ffmpeg -v 0 -f dv -i pipe: -an -f rawvideo -pix_fmt yuv420p pipe: | \
					ffmpeg -v 0 -f rawvideo -pix_fmt yuv420p -s "$normalisation" -r "$normalisation" -i pipe: \
					-an -target dvd -f mpeg1video -maxrate 8000 -ildct -ilme -aspect 4:3 -pass 2 -passlogfile "$LOG" -y "$M2V"
					mplex -v 0 -f 8 -o "$file".vob "$M2V" "$AC3"
					rm -f "$M2V" "$AC3" "$LOG-0.log"
				fi
			fi
			;;
		"1" )
			if [ $pass -eq "1" ]; then
				ffmpeg -v 0 -f dv -i pipe: -f rawvideo -pix_fmt yuv420p pipe: \
				-vn -f $audio_format -ac 2 -ab $audio_bitrate -ar 48000 -y "$AC3" | \
				ffmpeg -v 0 -f rawvideo -pix_fmt yuv420p -s "$normalisation" -r "$normalisation" -i pipe: \
				-an -target dvd -f mpeg1video -maxrate 8000 -ildct -ilme -aspect 16:9 -pass 1 -passlogfile "$LOG" -y "$M2V"
			else
				if [ $pass -eq "2" ]; then
					ffmpeg -v 0 -f dv -i pipe: -an -f rawvideo -pix_fmt yuv420p pipe: | \
					ffmpeg -v 0 -f rawvideo -pix_fmt yuv420p -s "$normalisation" -r "$normalisation" -i pipe: \
					-an -target dvd -f mpeg1video -maxrate 8000 -ildct -ilme -aspect 16:9 -pass 2 -passlogfile "$LOG" -y "$M2V"
					mplex -v 0 -f 8 -o "$file".vob "$M2V" "$AC3"
					rm -f "$M2V" "$AC3" "$LOG-0.log"
				fi
			fi
			;;
		"2" )
			if [ $pass -eq "1" ]; then
				ffmpeg -v 0 -f dv -i pipe: -f rawvideo -pix_fmt yuv420p pipe: \
				-vn -f $audio_format -ac 2 -ab $audio_bitrate -ar 48000 -y "$AC3" | \
				ffmpeg -v 0 -f rawvideo -pix_fmt yuv420p -s "$normalisation" -r "$normalisation" -i pipe: \
				-an -target dvd -f mpeg1video -maxrate 8000 -ildct -ilme -aspect 4:3 -pass 1 -passlogfile "$LOG" -y "$M2V"
			else
				if [ $pass -eq "2" ]; then
					VOB=`mktemp -u $file.XXXXXX`
					mkfifo "$VOB"
					rm -rf "$file"
					ffmpeg -v 0 -f dv -i pipe: -an -f rawvideo -pix_fmt yuv420p pipe: | \
					ffmpeg -v 0 -f rawvideo -pix_fmt yuv420p -s "$normalisation" -r "$normalisation" -i pipe: \
					-an -target dvd -f mpeg1video -maxrate 8000 -ildct -ilme -aspect 4:3 -pass 2 -passlogfile "$LOG" -y "$M2V"
					mplex -v 0 -f 8 -o "$VOB" "$M2V" "$AC3" &
					dvdauthor -o "$file" --chapters="`$get_chapters -f $frame_rate -x $smil_file`" "$VOB"
					dvdauthor -o "$file" -T
					rm -f "$VOB"
					rm -f "$M2V" "$AC3" "$LOG-0.log"
				fi
			fi
			;;
		"3" )
			if [ $pass -eq "1" ]; then
				ffmpeg -v 0 -f dv -i pipe: -f rawvideo -pix_fmt yuv420p pipe: \
				-vn -f $audio_format -ac 2 -ab $audio_bitrate -ar 48000 -y "$AC3" | \
				ffmpeg -v 0 -f rawvideo -pix_fmt yuv420p -s "$normalisation" -r "$normalisation" -i pipe: \
				-an -target dvd -f mpeg1video -maxrate 8000 -ildct -ilme -aspect 16:9 -pass 1 -passlogfile "$LOG" -y "$M2V"
			else
				if [ $pass -eq "2" ]; then
					VOB=`mktemp -u $file.XXXXXX`
					mkfifo "$VOB"
					rm -rf "$file"
					ffmpeg -v 0 -f dv -i pipe: -an -f rawvideo -pix_fmt yuv420p pipe: | \
					ffmpeg -v 0 -f rawvideo -pix_fmt yuv420p -s "$normalisation" -r "$normalisation" -i pipe: \
					-an -target dvd -f mpeg1video -maxrate 8000 -ildct -ilme -aspect 16:9 -pass 2 -passlogfile "$LOG" -y "$M2V"
					mplex -v 0 -f 8 -o "$VOB" "$M2V" "$AC3" &
					dvdauthor -o "$file" --chapters="`$get_chapters -f $frame_rate -x $smil_file`" "$VOB"
					dvdauthor -o "$file" -T
					rm -f "$VOB"
					rm -f "$M2V" "$AC3" "$LOG-0.log"
				fi
			fi
			;;
	esac
}

[ "$1" = "--usage" ] || [ -z "$1" ] && usage "$@" || execute "$@"
