/*
 * Copyright (C) 2000 Arne Schirmacher <arne@schirmacher.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _PLAYLIST_H
#define _PLAYLIST_H

// C includes

#include <libxml/xmlmemory.h>
#include <libxml/parser.h>

// C++ includes

#include <map>
using std::map;

// forward declarations

class Frame;
class AVIFile;

struct ltstr
{
    bool operator()(const char* s1, const char* s2) const
    {
        return strcmp(s1, s2) < 0;
    }
};

/** The PlayList class handles a collection of movie files.
    */

class PlayList
{
public:
    PlayList();
    PlayList(const PlayList&);
    PlayList& operator=(const PlayList&);
    ~PlayList();

    int GetNumFrames() const;
    char* GetFileNameOfFrame(int frameNum) const;
    bool GetFrame(int frameNum, Frame &frame);
    int FindStartOfScene(int frameNum) const;
    int FindEndOfScene(int frameNum) const;
    void AutoSplit(int first, int last);
    void SplitSceneBefore(int frameNum);
    bool GetPlayList(int first, int last, PlayList &playlist) const;
    bool InsertPlayList(PlayList &playlist, int before);
    bool Delete(int first, int last);
    void LoadAVI(char *filename);
    bool LoadPlayList(char *filename);
    bool SavePlayList(char *filename);
    void CleanPlayList(xmlNodePtr node);

private:
    xmlDocPtr doc;
    map<const char*, AVIFile, ltstr> filemap;
};

#endif
