/***************************************************************************
                                debugwindow.h
                             -------------------
    begin                : Sunday Jan 27 2001
    copyright            : (C) 2001 Benjamin Meyer 
    email                : benjamin@csh.rit.edu
 ***************************************************************************/

#ifndef KINKATTADEBUGWINDOW_H
#define KINKATTADEBUGWINDOW_H

#include <kinkattaplugin.h>

class Configure;
class QMultiLineEdit;

/**
 * This plugin will display debug info.
 * @author Benjamin Meyer
 */

class DebugWindow : public KinkattaPlugin {

Q_OBJECT
	
public:
  /// Constructor.
  DebugWindow(QWidget *parent=0, const char *name=0);
  
public slots:
  
  /// After this plugin has been initialized this function is called.
  virtual void initPlugin();

  /// Get the configure widget for this plugin
  QWidget *configure( QWidget *parent );

  /// Debug window
  QMultiLineEdit *debugWindow;

private slots:
  /// When there is new debug information it is parsed and then displayed
  void debugDataIn(QString data);

  /// The user wishes to see a window, create one if we don't have one
  void showDebugWindow();

  /// When the debug window is distroyed
  void debugWindowDistroyed();

private:
  /// The Configure widget.
  Configure *configureWidget;

};

#endif

// debugwindow.h

