/***************************************************************************
                              buddytimecard.cpp 
                           -------------------
    begin                : Sunday Jan 27 2002
    copyright            : (C) 2001 Benjamin Meyer
    email                : benjamin@csh.rit.edu
 ***************************************************************************/

#include "buddytimecard.h"
#include "configure.h"
#include <qcheckbox.h>
#include <qdir.h>
#include "taim.h"
#include "preferences.h"
#include <qmessagebox.h>
#include <qdatetime.h>

extern "C"
{
  void* create_plugin()
  {
    return new BuddyTimeCard;
  }
};

/**
 * Constructor.  Initializes the plugin info and settings.
 * @param parent the parent widget
 * @param name the name of this widget
 */
BuddyTimeCard::BuddyTimeCard(QWidget *parent, const char *name) : KinkattaPlugin( parent,name ){
  info.Name = "Buddy Time Card";
  info.Author = "Benjamin Meyer";
  info.Version = "1.00";
  info.HomePage = "http://kinkatta.sourceforge.net/";

  configureWidget = NULL;
}

BuddyTimeCard::~BuddyTimeCard(){
  if (logOpen)
    logFile.close();
}

/**
 * Reads in the settings.
 */
void BuddyTimeCard::initPlugin(){
  // Read Settings.
  QString DirStr = QDir::homeDirPath() + "/.kinkatta/plugins/buddytimecard.settings" ;
  Preferences prefs(DirStr, info.Name, info.Version);
  loggingEnabled = prefs.getBool("loggingEnabled", false);
  applyConfigure();
  
  connect(connection, SIGNAL(userSignedOn(QString)), this, SLOT(buddySignedOn(QString)));
  connect(connection, SIGNAL(userSignedOff(QString)), this, SLOT(buddySignedOff(QString)));
}
 
/**
 * Creates the configure widget if there isn't one.
 * @param parent the parent widget for the configure widget if one needs to be made.
 * @return QWidget the configure widget for this plugin.
 */
QWidget *BuddyTimeCard::configure( QWidget *parent ){
  if ( configureWidget == NULL ){
    configureWidget = new Configure(parent, "Buddy Time Card Configure window.");
    configureWidget->enableTimeTracker->setChecked(loggingEnabled);
  }
  return configureWidget;
}	

/**
 * Gets the current value of the settings from the configure widget.
 */
void BuddyTimeCard::applyConfigure(){
  if( configureWidget != NULL ) {
    loggingEnabled = configureWidget->enableTimeTracker->isChecked();
  }

  if( loggingEnabled ){
    QString fileNamePath = QDir::homeDirPath() + "/.kinkatta/logs/sign_on_off.log";
    logFile.setName(fileNamePath);

    QDir newDir("/dev/null");
    QString d = QDir::homeDirPath() + "/.kinkatta";
    if( !QFile::exists(d) )
      newDir.mkdir(d, true);
    d = QDir::homeDirPath() + "/.kinkatta/logs/";
    if( !QFile::exists(d) )
      newDir.mkdir(d, true);
    if( QFile::exists(d) ){
      if (logFile.open( IO_WriteOnly | IO_Append ) == true){
        logOpen = true;
        logStream.setDevice(&logFile);
      }
      else
        QMessageBox::critical(0, "Kinkatta", QString("Unable to open ") + fileNamePath + " for appending.", "OK");
    }
  }
  else{
    if (logOpen){
      logOpen = false;
      logFile.close();
    }
  }

}

/**
 * Save the round number in the settings.
 */
void BuddyTimeCard::saveSettings(){
  QString DirStr = QDir::homeDirPath() + "/.kinkatta/plugins/buddytimecard.settings" ;
  QFile::remove(DirStr);
  Preferences prefs(DirStr, info.Name, info.Version);
  prefs.setBool("loggingEnabled", loggingEnabled);
  prefs.flush();
}

/**
 * Log this buddy as signing off
 * @param buddy The name of the buddy that is signing off
 */
void BuddyTimeCard::buddySignedOff( QString buddy ){
  if(loggingEnabled){
    QString date = ((QDate::currentDate ()).toString());
    QString CurrentTime = QTime::currentTime().toString();
    logStream << date << " " << CurrentTime << " : " << buddy << " Signed Off." << endl;
    logFile.flush();
  }
}

/**
 * Log this buddy as signing on
 * @param buddy The name of the buddy that is signing on
 */
void BuddyTimeCard::buddySignedOn( QString buddy ){
  if(loggingEnabled){
    QString date = ((QDate::currentDate ()).toString());
    QString CurrentTime = QTime::currentTime().toString();
    logStream << date << " " << CurrentTime << " : " << buddy << " Signed On." << endl;
    logFile.flush();
  }
}

// buddytimecard.cpp

