/***************************************************************************
                                rot13.cpp 
                           -------------------
    begin                : Tuesday Jan 31 2001
    copyright            : (C) 2001 Benjamin Meyer
    email                : benjamin@csh.rit.edu
 ***************************************************************************/


#include "kinkattagameplugin.h"

/**
 * Constructor
 */
KinkattaGamePlugin::KinkattaGamePlugin(QWidget *parent, const char *name, QString gamename) : KinkattaPlugin( parent,name ){
  gameName = gamename;
}

/**
 * Does nothing.
 */
KinkattaGamePlugin::~KinkattaGamePlugin(){
}

/**
 * Does nothing.
 */
void KinkattaGamePlugin::initPlugin(){
}
 
void KinkattaGamePlugin::inChatMessage( QString message, QString buddy, bool isAuto  ){
  unsigned int length = gameName.length();
  QString toStartAGame = (QString("/") + gameName);
  if( message.contains(toStartAGame)){
    QString s = "start";
    move(s, buddy);
    return;
  }
  if( message.length() > length ){
    if( message.left(length) == gameName ){
      qDebug("Found a message for this game");
      message = message.mid(length+1,message.length()-(2+length));
      move(message, buddy);
      return;
    }
  }
  emit ( goingInChatMessage( message, buddy, isAuto ) );
}

void KinkattaGamePlugin::outChatMessage( QString message, QString buddy, bool isAuto, bool endIdleNess  ){
  QString toStartAGame = (QString("/") + gameName);
  if( message.contains(toStartAGame)){
    // Start a new game.
    if(this->startGame(buddy)){
      // We just started a new game.
      game *thisGame = findGame( buddy );
      if( thisGame != NULL ){
        // We go first.
        thisGame->gameInProgress = true;
        thisGame->myTurn = true;
      }
    }
    return;
  }
  // They should be able to send out stuff just fine.
  emit ( goingOutChatMessage( message, buddy, isAuto, endIdleNess ) );
}

/**
 *
 *
 */
game *KinkattaGamePlugin::findGame(QString buddy){
  game *g = games.first();
  while( g != NULL){
    if( g->buddy == buddy)
      break;
    g = games.next();
  }
  return g;
}

void KinkattaGamePlugin::move(QString &theMove, QString buddy){
  // start
  if( theMove == "start"){
    game *thisGame = findGame( buddy );
    if( thisGame != NULL ){
      thisGame->gameInProgress = true;
    }
    else{
      // Ask the user if they want to play a game.
      startGame(buddy);
      game *thisGame = findGame( buddy );
      if(thisGame){
        thisGame->gameInProgress = true;
      } 
    }
    return;
  }
  // end
  if( theMove == "end"){
    this->endGame(buddy);
    return;
  }
  // error
  if( theMove.left(5) == "error"){
    // QMessageBox.
    qDebug(theMove.latin1());
    return;
  }

  qDebug(theMove.latin1());
}

bool KinkattaGamePlugin::startGame(QString buddy){
  game *newGame = findGame( buddy );
  if( !newGame )
    newGame = new game();
  
  newGame->myTurn = false;
  newGame->board = NULL;
  newGame->gameInProgress = false;
  newGame->buddy = buddy;
  games.append(newGame);
  qDebug("We want to start a game");
  QString message = gameName + "(start)";
  emit ( goingOutChatMessage( message, buddy, false, true ) );
  // Start timer and watch for it.
}

void KinkattaGamePlugin::endGame(QString buddy){

}

// kinkattagaimplugin.cpp

