/***************************************************************************
                              appointmentimp.h
                             -------------------
    begin                : Tuesday Nov 12 2001
    copyright            : (C) 2001 Benjamin Meyer 
    email                : benjamin@csh.rit.edu
 ***************************************************************************/

#ifndef APPOINTMENTIMP_H 
#define APPOINTMENTIMP_H

#include "appointment.h"
#include <qstring.h>

/**
  *@author Benjamin Meyer
  */
struct appointment{
  QString message;
  int startHour;
  int startMinute;
  int endHour;
  int endMinute;
  int day;
};

/**
 * A dialog that allows you to edit an appointment.
 * @author Benjamin Meyer
 */
class AppointmentImp : public Appointment {

Q_OBJECT

signals:

  /// Ok button was pressed.
  void updateAppointment( appointment *a );

  /// Cancle button was pressed.
  void cancelAppointment( appointment *a );

public:

  /// Constructor
  AppointmentImp(QWidget *parent=0, const char *name=0);

  /// Deconstructor
  ~AppointmentImp();

  /// Set the current appointment equal to newA
  void setAppointment( appointment *newA );
  
private slots:
  /// Ok button clicked.
  void okClicked();

  /// Cancel button clicked.
  void cancelClicked();

private:
  /// The internal appointment that we are editing.
  appointment *a;

};

#endif

// appointmentimp.h

