/***************************************************************************
                              buddylistwindow.h
                             -------------------
    begin                : Sun Feb 13 2000
    copyright            : (C) 2000 by Benjamin Meyer
    email                : benjamin@csh.rit.edu
 ***************************************************************************/

#ifndef BUDDYLISTWINDOW_H
#define BUDDYLISTWINDOW_H

#include <qwidget.h>

#include <qdict.h>
#include <qlist.h>
#include <kmainwindow.h>

#include "setup.h"
#include "newawaymessage.h"
#include "tbuddylist.h"
#include "newpounceimp.h"
#include <kaboutkde.h>

class Chat;
class KHelpMenu;
class KMenuBar;
class KPopupMenu;
class QPushButton;
class KAction;
class KActionMenu;
class KActionSeparator;
class QTextStream;
class QFile;

class TAim;
class AwayMessage;
class ChatRoom;
class ChatWindow;
class KinkattaListView;
class Options;
class PluginsImp;

/**
 * @author Benjamin Meyer
 */

class BuddyListWindowItem; 

/**
 * The main window that displays the buddies.  Edit/IM etc.
 * @author Benjamin Meyer
 */
class BuddyListWindow : public KMainWindow  {
  Q_OBJECT

  signals:
    void updateIfIsBuddy(QString, bool);
    void updateChatSettings();

    void updateChatColorSettings();
    void updateChatFontSettings();
    void updateChatSoundSettings();

    void sendMessageChat(QString buddy, QString message, bool, bool);
    void sendMessageRoom(int room, QString message);
    void creatingChatWindow(Chat *chatWindow);
    void distroyingChatWindow(Chat *chatWindow);
    void creatingChatRoom(ChatRoom *chatWindow);
    void distroyingChatRoom(ChatRoom *chatWindow);


    //this is mainly so that the dock widget can be notified when we go
    //away/come back
    void dock_statusChanged(int);
    //this is so the dockWidget can show a little message when a buddy signs
    //on/off.
    void dock_buddySignedOn(TBuddy *);
    void dock_buddySignedOff(TBuddy *);

public:
  /// Constructor   
  BuddyListWindow(QWidget *parent=0, const char *name=0);
  /// Deconstructor
  ~BuddyListWindow();

    void closeExistingChatwindows();
    void resizeEvent ( QResizeEvent *e );
    bool awayRightNow;
    QValueList<QString *> signedOff;
    QValueList<QString *> signedOn;
    QValueList<QString *> awayMessageSent;
    void clearPostConnections(void);
    toolTipData AmIATip(const QPoint & p);
    KPopupMenu *_AwayMenu;

private:
    // internal vars
    settings_t *i_aimSettings;
    TAim *connection;
    bool viewAll;
    bool autoResizing;
    bool sendingPounce;	
    bool muteSoundForUs;  //whether or not to play sounds.  used at signon.
    bool loadingTheList;
    int empty1;
    int empty2;
    QPoint globalPosition;

    // ChatRoom handling 
    ChatRoom *getAChatRoom(const int roomNumber, QString roomName = "");
    bool chatRoom_isThereARoom(const int roomNumber);
    QDict<ChatRoom> chatRooms;

    // Away status
    QString awayMessage;
		
    // internal functions
    void addTreeBuddy(TBuddy *buddy, QString folder, int folder_size);

    void initWindow();
    void initMenuBar();
    void initViewAllSetting();
    void loadTreeBuddy(TBuddy *buddyInfo);
    void autoResize();
			 	
    KPopupMenu *_FileMenu;
    KPopupMenu *_ViewMenu;
    KPopupMenu *_PounceMenu;
    KPopupMenu *_PounceDelete;
    int id_buddyList;
    KAction *id_folderEdit;
    KAction *id_folderRemove;
    KMenuBar *_menuBar;
   
  KActionMenu *buddyMenu;
  KAction *buddy_getInfo;
  KAction *buddy_remove;
  KAction *buddy_editName;
  KAction *buddy_editAlias;
  KAction *buddy_openLogs;
  KAction *buddy_editSound;
    
  KActionMenu *buddyRightClickMenu;
  KActionMenu *folderRightClickMenu;
  KActionSeparator *menuSeparator;

    // ChatWindow handling
    ChatWindow *messageWindow(const QString &name);
    QDict<ChatWindow> messageWindows;
    QList<ChatWindow> sentAwayMessageToWindow;

    void importConfig(QString fileName);
    void importXmlConfig(QString fileName);
    void importConfigAlias(QString fileName);

    QDict<pounce> pounceMessages;

  protected:
    void mouseReleaseEvent(QMouseEvent* event);
    void closeEvent(QCloseEvent *);
    QPixmap *createBuddyPixmapWithIcon(QPixmap, int, QColor, QColor, QString);
		
    KinkattaListView *treeList;
    QPushButton *chatButton;
    QPushButton *infoButton;
    QPushButton *awayButton;

    AwayMessage *awayWidget;
    PluginsImp *pluginsDialog;
    Options *optionsDialog;

  public slots:
    void saveAimSettings();
    void loggedIn();
    void rightClickInTree(QListViewItem *item, const QPoint &point, int);
    void buddyChanged(int number);
    void settingsChanged();
    void initOptions();
    void loadList();

    void away_BackForReal();
    void away_Back();
    bool away_isAwayRightNow();
    void away_setAwayMessageNow( QString message );

    void receivedIM(QString message, QString name, bool isAuto);
    void initChatSettings();

    void loadRecurringPounces();
    
private slots:
  void endMutePeriod();
  /// Restore and show the main window
  void showKinkatta();

  /// Save the position of the main widget and hide it
  void hideKinkatta();

  void savePounce();
    void showOptions();
    void showPlugins();
    void postBuddySignoff();
    void postBuddySignon();
    void moveBuddy(QListViewItem* buddy, QListViewItem* folder);
    void aboutToShowFileMenu();
    void DoubleClicked();
    void TreeSelected(QListViewItem* selected);
    void folderExpanded(QListViewItem*item);
    void folderCollapsed(QListViewItem*item);

    void changePassword();
    void slotAddBuddy();
    void slotAddBuddy(QString buddy);
    void slotRemoveBuddy();
    void slotAddFolder();
    void slotRemoveFolder();
    void slotRemoveFolder(QString group);
    void slotOpenLogs();
    void slotEditBuddy();
    void slotEditAlias();
    void buddySignedOn(QString buddy);
    void changeBuddyName();
    void viewLastOn();
    void viewIdle();
    void ChangeViewAllSetting();
    void slotRemoveBuddy(QString name);

    void slotGetBuddyInfo();
    void slotGetBuddyInfo(QString name);
    void slotBuddyInfoRecieved(QString);

    void editSoundConfig();
    void setSoundConfig(pounce newPounce);

    void postAwayMessageSent();
    void initAwayList();
    void away_ShowAwayList();
    void away_SetAutoAway();
    void away_AddAwayMessage();
    void away_makeAwayNow(QString name);
    void away_Update(QString text);
    void away_GoAway(int);

    void chat_sendImOut(QString message, QString contactName);

    void chatWindow_sendAutoIM(QString contactName, QString message);
    void chatWindow_ChatWithBuddy(QString contactName);
    void chatWindow_ChatWithBuddy();
    void chatWindow_RemoveWindow(QString contactName);
    void chatWindow_BlockBuddy(QString contactName);
    void chatWindow_WarnBuddy(QString contactName);
    void chatWindow_SendWarning(QString contactName, bool isAnonymous);

    void chatRoom_JoinButton();
    void chatRoom_Joined( int roomNumber, QString roomName );
    void chatRoom_In( int roomNumber, QString contactName, bool whisper, QString message );
    void chatRoom_UpdateBuddy( int roomNumber, bool newStatus, QString contactName );
    void chatRoom_Invite( QString roomName, int roomNumber, QString sender, QString message);
    void chatRoom_ShowInvite( int roomNumber );
    void chatRoom_Left( int roomNumber );
    void chatRoom_RemoveWindow( QString roomNumber );
    void chatRoom_sendImOut( QString message, QString roomNumber );


    void slotImportFromGaim();
    void slotImportFromKinkatta();
    void slotImportFromTik();
    void slotImportFromAim();
    void slotImportFromKit();
    void slotExportBuddyList();

    void pounce_SlotAddDialog();
    void pounce_SlotAddDialogWithBuddy();
    void pounce_SlotAddDialogWithBuddyName(QString);
    void pounce_Edit(int menuId);
    void pounce_SlotAdd(pounce newPounce);
    void pounce_DeleteMenuAboutToShow();
    void pounce_CheckSignOn(QString buddyName);
    void pounce_CheckReturnAway(QString buddyName);
    void pounce_CheckReturnIdle(QString buddyName);
    void pounce_Activate(QString buddyName);
    void pounce_SlotRemove(int deleteMenuNumber);
    void pounce_UpdateMenu();

};

#endif

// buddylistwindow.h

