/***************************************************************************
                             buddylistwindow.cpp
                             -------------------
    begin                : Sun Feb 13 2000
    copyright            : (C) 2000 by Benjamin Meyer
    email                : ben@meyerhome.net
 ***************************************************************************/

#include "application.h"
#include "chat.h"
#include "buddylistwindow.h"
#include "kinkattalistview.h"
#include "kinkattatextbrowser.h"
#include "kitpasswordchanger.h"
#include "chatroominviteimp.h"
#include "soundconfigureimp.h"
#include "awaymessage.h"
#include "info.h"
#include "chatwindow.h"
#include "chatroom.h"
#include "pluginsimp.h"
#include "options.h"
#include "login.h"
#include "taim.h"
#include "kinkattadock.h"
#include <qfile.h>
#include <qtextstream.h>
#include <qdict.h>
#include <qtooltip.h>
#include <qcursor.h>
#include <kfiledialog.h>
#include <qtooltip.h>
#include <qmessagebox.h>
#include <qtimer.h>
#include <qpixmap.h>
#include <qregexp.h>
#include <qbitmap.h>
#include <qinputdialog.h>
#include <qapplication.h>
#include <qheader.h>
#include <qpushbutton.h>
#include <kpopupmenu.h>
#include <kiconloader.h>
#include <kmenubar.h>
#include <unistd.h>
#include <kedittoolbar.h>
#include <klocale.h>
#include <kaction.h>
#include <kwin.h>
#include <kstdaction.h>
// for system()
#include <stdlib.h>

#define SOUND_MUTE_ON_LOGIN_TIME 20

#define DEFAULT_AWAYWIDGET_HEIGHT 170

//These delays are in seconds!!
#define POST_BUDDY_SIGNOFF_DELAY 10
#define POST_BUDDY_SIGNON_DELAY 10
#define POST_AWAY_MESSAGE_SENT_DELAY 300
#define POST_GET_AWAY_MESSAGE 3

#define NEW_AWAY_MESSAGE_MENU_ID 99

#define TWINDOW_AIM_SANITY_CHECK if(connection->getStatus() == TAIM_OFFLINE) {\
   QMessageBox::critical(0, QString("Kinkatta"), QString("You are not online."));\
   return; }

/**
 * Initializes settings.
 * @param parent the parent widget
 * @param name the name of this widget
 */
BuddyListWindow::BuddyListWindow(QWidget *parent, const char *name ) : KMainWindow(parent,name){
  setup::instance()->read();

  viewAll = true;
  empty1 = -1;
  sendingPounce = false;
  autoResizing = false;
  awayRightNow = false;
  muteSoundForUs = false;
  optionsDialog = NULL;
  i_aimSettings = setup::settings();
  
  connection = new TAim(this, "Connection");
  
  pluginsDialog = new PluginsImp(this, "Plugin Dialog");
  pluginsDialog->setPointers( this, connection );
  pluginsDialog->setIcon(SmallIcon("kinkatta"));

  Login *loginDialog = kApp->loginWindow;
  loginDialog->setNetworkObject(connection);
  kApp->showLoginWindow();
  resize(260,150);
  this->setMinimumSize(160,150);

  connect(loginDialog, SIGNAL(showOptions()), this, SLOT(showOptions()));
  connect(loginDialog, SIGNAL(showPlugins()), this, SLOT(showPlugins()));
  connect(loginDialog, SIGNAL(destroyed()), qApp, SLOT(quit()));

  loadingTheList = false;
  pounceMessages.setAutoDelete( TRUE );

  connect(connection, SIGNAL(userInfoReceived(QString)), this, SLOT(slotBuddyInfoRecieved(QString)));
  //connect(connection, SIGNAL(IMReceived(QString, QString, bool)), this, SLOT(receivedIM(QString, QString, bool)));
  connect(connection, SIGNAL(buddyChanged(int)), this, SLOT(buddyChanged(int)));
  connect(connection, SIGNAL(userSignedOn(QString)), this, SLOT(buddySignedOn(QString)));
  connect(connection, SIGNAL(userNotAway(QString)), this, SLOT(pounce_CheckReturnAway(QString)));
  connect(connection, SIGNAL(reloadList()), this, SLOT(loadList()));
  connect(connection, SIGNAL(userNotIdle(QString)), this, SLOT(pounce_CheckReturnIdle(QString)));
  connect(connection, SIGNAL(idleTimeReached()), this, SLOT(away_SetAutoAway()));

  connect(connection, SIGNAL(chat_joined(int, QString)), this, SLOT(chatRoom_Joined(int, QString)));
  connect(connection, SIGNAL(chat_in(int, QString, bool, QString)), this, SLOT(chatRoom_In(int, QString, bool, QString)));
  connect(connection, SIGNAL(chat_updateBuddy(int, bool, QString)), this, SLOT(chatRoom_UpdateBuddy(int, bool, QString)));
  connect(connection, SIGNAL(chat_invite(QString, int, QString, QString)), this, SLOT(chatRoom_Invite(QString, int, QString, QString)));
  connect(connection, SIGNAL(chat_left(int)), this, SLOT( chatRoom_Left(int)));

  buddyMenu = new KActionMenu( i18n( "&Buddy" ), actionCollection(), "buddy_menu" );
  buddy_getInfo = new KAction(i18n("&Get Buddy Info"), CTRL+Key_I, this,
    SLOT(slotGetBuddyInfo()), actionCollection(), "buddy_getInfo" );
  buddyMenu->insert(buddy_getInfo);
  buddy_remove = new KAction(i18n("&Remove Buddy..."), 0, this,
     SLOT(slotRemoveBuddy()), actionCollection(), "buddy_remove" );
  buddyMenu->insert(buddy_remove);
  buddy_editName = new KAction(i18n("&Edit Name"), 0, this,
     SLOT(slotEditBuddy()), actionCollection(), "buddy_editName" );
  buddyMenu->insert(buddy_editName);
  buddy_editAlias = new KAction(i18n("&Edit Alias"), 0, this,
     SLOT(slotEditAlias()), actionCollection(), "buddy_editAlias" );
  buddyMenu->insert(buddy_editAlias);
  buddy_openLogs = new KAction(i18n("&Open Logs Folder"), 0, this,
     SLOT(slotOpenLogs()), actionCollection(), "buddy_openLogs" );
  buddyMenu->insert(buddy_openLogs);
  buddy_editSound = new KAction(i18n("Edit &Sound"), 0, this,
     SLOT(editSoundConfig()), actionCollection(), "buddy_editSound" );
  buddyMenu->insert(buddy_editSound);
  
  KAction *folderAddBuddy = new KAction(i18n("&Add Buddy..."), 0, this, SLOT(slotAddBuddy()), actionCollection(), "folder_addBuddy" );
  KAction *folderAddFolder = new KAction(i18n("Add &Folder"), 0, this, SLOT(slotAddFolder()), actionCollection(), "folder_addFolder" );
  id_folderRemove = new KAction(i18n("&Remove Folder..."), 0, this, SLOT(slotRemoveFolder()), actionCollection(), "folder_removeFolder" );
  id_folderEdit = new KAction(i18n("&Edit Name"), 0, this, SLOT(slotEditBuddy()), actionCollection(), "folder_editName" );

  (void)new KAction(i18n("&Gaim..."), 0, this, SLOT(slotImportFromGaim()), actionCollection(), "import_gaim" );
  (void)new KAction(i18n("&Kit..."), 0, this, SLOT(slotImportFromKit()), actionCollection(), "import_kit" );
  (void)new KAction(i18n("&Tik..."), 0, this, SLOT(slotImportFromTik()), actionCollection(), "import_tik" );
  (void)new KAction(i18n("&Aim..."), 0, this, SLOT(slotImportFromAim()), actionCollection(), "import_aim" );
  (void)new KAction(i18n("&Kinkatta..."), 0, this, SLOT(slotImportFromKinkatta()), actionCollection(), "import_kinkatta" );
  (void)new KAction(i18n("&Export..."), CTRL+Key_E, this, SLOT(slotExportBuddyList()), actionCollection(), "export" );
  
  (void)new KAction(i18n("&Options..."), CTRL+Key_O, this, SLOT(showOptions()), actionCollection(), "options" );
  (void)new KAction(i18n("&Plugins..."), CTRL+Key_P, this, SLOT(showPlugins()), actionCollection(), "plugins");
  KAction *newInstantMesage = new KAction(i18n("&New Instant Message..."), CTRL+Key_N, this, SLOT(chatWindow_ChatWithBuddy()), actionCollection(), "new_im");
  (void)new KAction(i18n("&Join Chat Room..."), CTRL+Key_J, this, SLOT(chatRoom_JoinButton()), actionCollection(), "join_chatroom" );
  (void)new KAction(i18n("&Log Off"), CTRL+Key_L, kApp->loginWindow, SLOT(logOff()), actionCollection(), "log_off" );

  KStdAction::quit(qApp, SLOT(quit() ), actionCollection(), "quit");

  // Insert
  KActionMenu *away_menu = new KActionMenu( i18n( "&Away" ), actionCollection(), "tools_away" );
  _AwayMenu = away_menu->popupMenu();
  away_menu->setDelayed(false);
  KActionMenu *view_menu = new KActionMenu( i18n( "&View" ), actionCollection(), "tools_view" );
  _ViewMenu = view_menu->popupMenu();
  view_menu->setDelayed(false);
  KActionMenu *pounce_menu = new KActionMenu( i18n( "&Pounce" ), actionCollection(), "tools_pounce" );
  _PounceMenu = pounce_menu->popupMenu();
  pounce_menu->setDelayed(false);

  menuSeparator = new KActionSeparator( actionCollection(), "seperator" );

  buddyRightClickMenu = new KActionMenu( "", actionCollection(), "buddy_right_click_menu" );
  buddyRightClickMenu->insert(newInstantMesage);
  buddyRightClickMenu->insert(buddy_getInfo);
  buddyRightClickMenu->insert(buddy_remove);
  buddyRightClickMenu->insert(buddy_openLogs);
  buddyRightClickMenu->insert(buddy_editSound);
  buddyRightClickMenu->insert(buddy_editName);
  buddyRightClickMenu->insert(buddy_editAlias);
  buddyRightClickMenu->insert(menuSeparator);
  buddyRightClickMenu->insert(view_menu);

  folderRightClickMenu = new KActionMenu( "", actionCollection(), "folder_right_click_menu" );
  folderRightClickMenu->insert(folderAddBuddy);
  folderRightClickMenu->insert(menuSeparator);
  folderRightClickMenu->insert(folderAddFolder);
  folderRightClickMenu->insert(id_folderRemove);
  folderRightClickMenu->insert(menuSeparator);
  folderRightClickMenu->insert(id_folderEdit);
  folderRightClickMenu->insert(menuSeparator);
  folderRightClickMenu->insert(view_menu);

  //KStdAction::configureToolbars(this, SLOT(showOptions() ), actionCollection(), "configuretoolbars");
  (void)new KAction(i18n("&Change Password..."), 0, this, SLOT(changePassword()), actionCollection(), "tools_change_password" );
  
  //KActionMenu *buddy_menu = new KActionMenu( i18n("&Buddy"), actionCollection(),  "buddy_menu" );

  createGUI("mainwindowui.rc");

  //KAction *buddy_menu = action("buddy_menu" );
  //_BuddyMenu =(KPopupMenu *)guiFactory()->container("buddy_menu", this);
  //if(buddy_menu == NULL)
  //  qDebug("nothing here"); 
  //else
  //buddy_menu->insertItem(SmallIcon("history"),"&Open Logs folder", this, SLOT(slotOpenLogs()));
  _FileMenu =(KPopupMenu *)guiFactory()->container("program_menu", this);

  // Create the menu
  _PounceDelete = new KPopupMenu(this, "PounceDelete");
  connect(_PounceMenu, SIGNAL(aboutToShow()), this, SLOT(pounce_DeleteMenuAboutToShow()));
  //_BuddyMenu = new KPopupMenu(this, "Buddy");
  // The menu bar for the menus
  _menuBar = menuBar();

  initMenuBar();

  initWindow();
  connect(_AwayMenu, SIGNAL(activated(int)), this, SLOT(away_GoAway(int)));
  connect(treeList->buddyEdit, SIGNAL(returnPressed()), this, SLOT(changeBuddyName()));
  connect(treeList, SIGNAL(removeBuddy(QString)), this, SLOT(slotRemoveBuddy(QString)));
  connect(treeList, SIGNAL(removeFolder(QString)), this, SLOT(slotRemoveFolder(QString)));

  messageWindows.setAutoDelete(false);

  DockWidget *dockWidget = new DockWidget(this, "dockWidget");
  connect(dockWidget, SIGNAL(showKinkattaConfig()), this, SLOT(showOptions()));
  connect(dockWidget, SIGNAL(showKinkattaPlugins()), this, SLOT(showPlugins()));
  connect(connection, SIGNAL(statusChanged(int)), dockWidget, SLOT(connectionChanged(int)));
  connect(this, SIGNAL(dock_statusChanged(int)), dockWidget, SLOT(connectionChanged(int)));
  connect(this, SIGNAL(dock_buddySignedOn(TBuddy *)), dockWidget, SLOT(buddySignedOn(TBuddy *)));
  connect(this, SIGNAL(dock_buddySignedOff(TBuddy *)), dockWidget, SLOT(buddySignedOff(TBuddy *)));
  connect(dockWidget, SIGNAL(backClicked()), this, SLOT(away_BackForReal()));
  connect(dockWidget, SIGNAL(tryToConnect()), kApp->loginWindow, SLOT(tryToConnect()));
  connect(dockWidget, SIGNAL(logoff()), kApp->loginWindow, SLOT(logOff()));
  connect(dockWidget, SIGNAL(exitKinkatta()), qApp, SLOT(quit()));
  connect(dockWidget, SIGNAL(showKinkatta()), this, SLOT(showKinkatta()));
  connect(dockWidget, SIGNAL(hideKinkatta()), this, SLOT(hideKinkatta()));
  dockWidget->awayMenu = _AwayMenu;
  dockWidget->show();
}

/**
 * Deconstructor
 */
BuddyListWindow::~BuddyListWindow(){
  i_aimSettings->xSize = this->width();
  i_aimSettings->ySize = this->height();
  saveAimSettings();
}

/**
 * Save the current settings to file.
 * Occurs when settings are changed (i.e. login and setup)
 */
void BuddyListWindow::saveAimSettings(){
  //QString conf;
  setup::instance()->save();
  if (connection->getStatus() != TAIM_OFFLINE){
    connection->setUserInfo( setup::instance()->readProfile( setup::settings()->login_name) );

    setup::instance()->saveBuddyList( setup::settings()->login_name,
      &(connection->buddyList()), &(connection->permitList()),
      &(connection->denyList()), connection->permissions() );
    
    //pluginDialog->saveSettings();
  }
  settingsChanged();
}

/**
 * Once the network is connected to aol this function is called.  It sets up
 * the window size, starts the mute time and any other on login options.
 */
void BuddyListWindow::loggedIn(){
  int x = (setup::settings()->xSize);
  int y = (setup::settings()->ySize);
  if ( (x > 120)	&& (y > 250) && (x < 1000) && (y < 2500) ){
    resize(x,y);
  }
  else
    resize(200,310);

  qApp->processEvents();

  if (setup::settings()->main_mute_on_login == true){
    muteSoundForUs = TRUE;
    QTimer::singleShot( SOUND_MUTE_ON_LOGIN_TIME*1000, this, SLOT(endMutePeriod()));
  }
  loadList();
  loadRecurringPounces();
  if(awayRightNow == true)
    away_BackForReal();
  initOptions();
  saveAimSettings();
}

/**
 * When signed on the option to turn off the sound would call a 10 second
 * timer that would in turn call this to turn it back on.
 */
void BuddyListWindow::endMutePeriod(){
  muteSoundForUs = FALSE;
}

/**
 * Init anything in the main window that would change.
 */
void BuddyListWindow::initOptions(){
  // Check Away status
  if(awayRightNow == true){
    away_Back();
  }

  // No Icons option
  if (i_aimSettings->main_noIcons == true){
    if (chatButton->isHidden() == false){
      chatButton->hide();
      awayButton->hide();
      infoButton->hide();
      resize(this->width(), this->height()-1);
    }
  }
  else{
    if (chatButton->isHidden() == true){
      chatButton->show();
      awayButton->show();
      infoButton->show();
      resize(this->width(), this->height()-1);
    }
  }

  setSoundCommand(i_aimSettings->sound_file_command);

  // Idle format option
  if (i_aimSettings->main_idleLayout == 1)
    connection->idleStringWColon = true;
  else
    connection->idleStringWColon = false;
  // X11 autoaway idle options
  connection->useX11forIdle = i_aimSettings->main_useX11ForIdle;
  connection->idleTimeBeforeSignal = i_aimSettings->away_auto_delay_minutes;

  // update buddylist Online font
  QFont tempFont;
  tempFont = i_aimSettings->buddylistFontSettings->buddylist_OnlineFont;
  treeList->setFont(tempFont);

  // Reload list for any other changes.
  loadList();
}

/**
 * init for the main objects, button, tree
 */
void BuddyListWindow::initWindow(){
  treeList= new KinkattaListView(this,"NoName");
  treeList->setGeometry(5,100,130,210);

  // set buddy list font to the default "Online" font as selected by the user.
  QFont tempFont;
  tempFont = i_aimSettings->buddylistFontSettings->buddylist_OnlineFont;
  treeList->setFont(tempFont);

  treeList->addColumn("Screen Name", -1);
  //treeList->setBackgroundPixmap(QPixmap("/home/ben/background.gif"));
  connect( treeList, SIGNAL(moveItem(QListViewItem *, QListViewItem *)), this, SLOT(moveBuddy(QListViewItem *, QListViewItem *)));
  connect( treeList, SIGNAL(expanded (QListViewItem *)), this, SLOT(folderExpanded (QListViewItem *)));
  connect( treeList, SIGNAL(collapsed(QListViewItem *)), this, SLOT(folderCollapsed(QListViewItem *)));

  connect( treeList, SIGNAL(doubleClicked(QListViewItem *)), this, SLOT(TreeSelected(QListViewItem *)) );
  connect( treeList, SIGNAL(returnPressed(QListViewItem *)), this, SLOT(TreeSelected(QListViewItem *)) );
  connect( treeList, SIGNAL(rightButtonClicked(QListViewItem *, const QPoint &, int)), this, SLOT(rightClickInTree(QListViewItem *, const QPoint &, int)) );

  chatButton= new QPushButton(this,"NoName");
  chatButton->setGeometry(5,315,40,40);
  chatButton->setPixmap(BarIcon("chat_big"));
  QToolTip::add(chatButton,"Chat");

  infoButton= new QPushButton(this,"NoName");
  infoButton->setGeometry(95,315,40,40);
  infoButton->setPixmap(BarIcon("info_big"));

  QToolTip::add(infoButton,"Get Buddy Info");

  awayButton= new QPushButton(this,"NoName");
  awayButton->setGeometry(50,315,40,40);
  awayButton->setPixmap(BarIcon("away_big"));
  QToolTip::add(awayButton,"Away");

  connect(_PounceDelete, SIGNAL(activated(int)), this, SLOT(pounce_SlotRemove(int)));
  connect(_PounceMenu, SIGNAL(activated(int)), this, SLOT(pounce_Edit(int)));
  // The Three Button Connections.
  connect(chatButton, SIGNAL(clicked()), this, SLOT(chatWindow_ChatWithBuddy()));
  connect(awayButton, SIGNAL(pressed()), this, SLOT(away_ShowAwayList()));
  connect(infoButton, SIGNAL(clicked()), this, SLOT(slotGetBuddyInfo()));

  awayWidget = new AwayMessage(this, "AwayDialogBox");
  connect(awayWidget, SIGNAL(backClicked()), this, SLOT(away_BackForReal()));
  connect(awayWidget, SIGNAL(update(QString)), this, SLOT(away_Update(QString)));
  awayWidget->hide();
}

/**
 * Builds the menu bars
 */
void BuddyListWindow::initMenuBar(){
  connect(_FileMenu, SIGNAL(aboutToShow()), this, SLOT(aboutToShowFileMenu()));
  initAwayList();
  initViewAllSetting();
  _PounceMenu->clear();
  _PounceMenu->insertItem("&Add pounce...", this, SLOT(pounce_SlotAddDialog()), CTRL+Key_A);
  _PounceMenu->insertItem("&Remove pounce", _PounceDelete);
  _PounceMenu->insertSeparator();
}

/**
 * Show the options dialog.  Create it if it isn't already there.
 */
void BuddyListWindow::showOptions(){
  if ( optionsDialog == NULL ) {
    optionsDialog = new Options(0, "options dialog", connection);
    optionsDialog->setIcon(SmallIcon("kinkatta"));
    connect(optionsDialog, SIGNAL(dataUpdated()), this, SLOT(saveAimSettings()));
    optionsDialog->updateData();
    optionsDialog->show();
  } else {
    /* If we get here, then the optionsDialog != NULL, which means it has
     * already been allocated/connected up, so we can just updateData, and
     * show() it.
     */
    optionsDialog->updateData();
    optionsDialog->show();
  }
}

/**
 * Show the plugins dialog.
 */
void BuddyListWindow::showPlugins(){
  pluginsDialog->show();
}

/**
 * Hide the window.  Program/Quit must be called.
 */
void BuddyListWindow::closeEvent(QCloseEvent *) {
  hideKinkatta();
}

/**
 * A buddy has been moved from one folder to another.  Move it. :)
 */
void BuddyListWindow::moveBuddy(QListViewItem* buddy, QListViewItem* folder){
  if (buddy != NULL && folder != NULL){
    TBuddyList list = connection->buddyList();
    int folderNumber = list.getNumGroup(((BuddyListWindowItem*)folder)->name);
    list.setGroup(list.getNum(((BuddyListWindowItem*)buddy)->name),folderNumber);
    connection->setBuddyList(list);
    loadList();
  }
}

/**
 * Loads the ViewAll settings.
 */
void BuddyListWindow::initViewAllSetting(){
  _ViewMenu->clear();
  _ViewMenu->setCheckable(true);
  if (viewAll == true){
    viewAll = false;
    _ViewMenu->insertItem("&All Buddies", this, SLOT(ChangeViewAllSetting()),0,1);
  }
  else{
    viewAll = true;
    _ViewMenu->insertItem("&On-Line Buddies", this, SLOT(ChangeViewAllSetting()),0,1);
  }
  _ViewMenu->insertItem("&LastOn", this, SLOT(viewLastOn()),0,2);
  _ViewMenu->insertItem("&Idle", this, SLOT(viewIdle()),0,3);
  _ViewMenu->setItemChecked(2,i_aimSettings->main_showLastOn);
  _ViewMenu->setItemChecked(3,i_aimSettings->main_showIdle);
}

/**
 * Changes the ViewAll setting and updates the list
 */
void BuddyListWindow::ChangeViewAllSetting(){
  initViewAllSetting();
  loadList();
}

/**
 * Turn on/off the LastOn colume
 */
void BuddyListWindow::viewLastOn(){
  if (i_aimSettings->main_showLastOn == true)
    i_aimSettings->main_showLastOn = false;
  else
    i_aimSettings->main_showLastOn = true;
  _ViewMenu->setItemChecked(2,i_aimSettings->main_showLastOn);
  loadList();
}

/**
 * Turn on/off the idle colume
 */
void BuddyListWindow::viewIdle(){
  if (i_aimSettings->main_showIdle == true)
    i_aimSettings->main_showIdle = false;
  else
    i_aimSettings->main_showIdle = true;
  _ViewMenu->setItemChecked(3,i_aimSettings->main_showIdle);
  loadList();
}

/**
 * The tooltip from the kinkattaviewlist calls this function to see if it should
 * display a tooltip or not.
 */
toolTipData BuddyListWindow::AmIATip(const QPoint & p){
  QPoint cur = p;
  QListViewItem * item  = treeList->itemAt ( cur );
  if (!item  || treeList->checkIfFolder(item) == true){
    toolTipData r;
    r.cords = QRect(0,0,-1,-1);
    return r;
  }
  toolTipData r;

  const QString name = ((BuddyListWindowItem*)item)->name;
  TBuddyList list = connection->buddyList();
  TBuddy *buddy = list.getByNum(list.getNum(name));

  QDateTime dateTime;
  dateTime.setTime_t( buddy->signonTime );
  QDateTime current = QDateTime::currentDateTime();
  int diff = dateTime.secsTo(current);

  int days = 0;
  int minutes = 0;
  int hours = 0;

  if (diff > 60)
    minutes = diff/60;

  if (minutes > 60){
    hours = minutes/60;
    minutes = minutes%60;
  }
  if (hours > 24){
    days = hours/24;
    hours = hours%24;
  }
  QString onlineTime;
  if (days > 0)
    onlineTime = QString("%1 days %2 hours %3 minutes").arg(days).arg(hours).arg(minutes);
  else
    if (hours > 0)
      onlineTime = QString("%1 hours %2 minutes").arg(hours).arg(minutes);
	else{
    if (minutes > 1)
      onlineTime = QString("%2 minutes").arg(minutes);
    else
      onlineTime = "< 1 minute.";
  }
  if (buddy->status != TAIM_ONLINE){
    onlineTime = "Signed Off";
  }

  QString idleTime = buddy->idleTimeString;
  if (idleTime.length() == 0)
    idleTime = "0";
    r.tip = QString("Name: ") + buddy->name + "\n" +
	"Alias: " + buddy->alias + "\n" +
	 "Idle Time: " + idleTime + "\n" +
	 "Online Time: " + onlineTime + "\n" +
         "Last On: " + buddy->lastOnString;
  r.cords = treeList->itemRect(item);
  return r;
}

/**
 * The function will parse through all the names and put them up on the Tree
 */
void BuddyListWindow::loadList() {
  if(connection->getStatus() == TAIM_OFFLINE)
    return;

  //if ( loadingTheList == true)
  // return;

	loadingTheList = true;

	treeList->clear();

  // remove all columns
  while((treeList->header())->count() > 1)
    treeList->removeColumn(1);

  if(connection->getStatus() == TAIM_OFFLINE) return;
  // we're online, so get going...

  // add columns as necessary, and headers
  if ((i_aimSettings->main_showIdle) == true)
    treeList->addColumn("Idle", -1);
  if ((i_aimSettings->main_showLastOn) == true)
    treeList->addColumn("Last On", -1);

	if (i_aimSettings->main_noHeader == true)
	  (treeList->header())->hide();
	else
		(treeList->header())->show();

  // get list to use...
  TBuddyList list = connection->buddyList();
  // Set the user list to be the same as

  // Add the groups
  QString groupName = "";
	for (int i=0; i < list.getCountGroup(); i++) {
		groupName = list.getNameGroup(i);
    BuddyListWindowItem *groupItem = new BuddyListWindowItem (treeList, groupName + "(0/0)");
    groupItem->name = groupName;
    groupItem->setPixmap(0, SmallIcon("folder_open"));
    groupItem->setExpandable(true);
    // Add all the buddies in this group
    for (int i2=0; i2 < list.getCount(); i2++) {
      TBuddy *tempBuddy = list.getByNum(i2);
      if (tempBuddy != NULL){
        // Go through the budies seeing if they are in the group.
        if (tempBuddy->group == i){
          if (tempBuddy->status == TAIM_ONLINE || viewAll == true){
						const TBuddyGroup *gc = list.getByNumG(tempBuddy->group);
					  if(gc) addTreeBuddy(tempBuddy, groupName, gc->size);
					}
				}
			}
    }
    if (groupItem->childCount() == 0){
      const TBuddyGroup *gc = list.getByNumG(i);
      QString size = QString("%1/%2").arg(groupItem->childCount()).arg(gc->size);
      groupItem->setText(0,groupItem->name + " (" + size + ")");
    }
    groupItem->setOpen(true);
  }
  if (list.getCountGroup() == 0){
    list.addGroup(QString("Buddies"));
    // Update server & local list
    connection->setBuddyList(list);
    viewAll = true;
    initViewAllSetting();
    // Add the folder to the gui and bring up the edit box on it.
    BuddyListWindowItem *groupItem = new BuddyListWindowItem (treeList, "Buddies (0/0)");
    groupItem->name = "Buddies";
    groupItem->setPixmap(0, SmallIcon("folder_open"));
    groupItem->setExpandable(true);
    //treeList->setCurrentItem(groupItem);
  }
  if (treeList->currentItem() == 0)
    treeList->setCurrentItem(treeList->firstChild());
  autoResize();
  loadingTheList = false;
}

/**
 * This function will add a buddy to a folder.
 */
void BuddyListWindow::addTreeBuddy(TBuddy *buddy, QString folder, int folder_size){
  BuddyListWindowItem *parent = (BuddyListWindowItem*)(treeList->firstChild());
	// Find the buddy in the tree
  while( parent != 0 ){
    if( ((BuddyListWindowItem*)(parent))->name == folder ){
	    QString alias = buddy->alias;
      QString buddyName = buddy->name;
	  	if (alias.length() == 0)
	    	alias = buddyName;
			BuddyListWindowItem *buddyItem = new BuddyListWindowItem(parent, QString(""));
			if (alias != buddyName)
			  buddyItem->setText(0, QString("@") + alias);
			else
			  buddyItem->setText(0, buddyName);
			buddyItem->name = buddyName;
			loadTreeBuddy(buddy);

			// Add number to group.
			QString size = QString("%1/%2").arg(parent->childCount()).arg(folder_size);
			parent->setText(0,parent->name + " (" + size + ")");
			break;
		}
  	parent = (BuddyListWindowItem*)(parent->nextSibling());
  }
}

/**
 * This function will fill the tree from the current buddy
 */
void BuddyListWindow::loadTreeBuddy(TBuddy *buddyInfo){
  if(connection->getStatus() == TAIM_OFFLINE)
    return;

  BuddyListWindowItem *parent = (BuddyListWindowItem*)(treeList->firstChild());
  BuddyListWindowItem *item = 0;
  BuddyListWindowItem *item2 = 0;

  // Check if it is a folder.
  if(parent == 0)
    return;

  // Find the buddy in the tree
  while( parent != 0 ){
    item = (BuddyListWindowItem*)parent->firstChild();
    while( item != 0 ){
      if( ((BuddyListWindowItem*)(item))->name == buddyInfo->name ){
	      item2 = (BuddyListWindowItem*)item;
  	    break;
      }
      item = (BuddyListWindowItem*)(item->nextSibling());
    }
    parent = (BuddyListWindowItem*)(parent->nextSibling());
  }

  if (item2 == 0 ){
    // The buddy must have just signed on.
    if (buddyInfo->status != TAIM_ONLINE && viewAll == false)
      return;

    TBuddyList list = connection->buddyList();
    const TBuddyGroup *gc = list.getByNumG(buddyInfo->group);
    if(gc) addTreeBuddy(buddyInfo, list.getNameGroup(buddyInfo->group), gc->size);
    // Check to see if there is a sound configure on this buddy.
	  pounce *p = pounceMessages[ QString("*sc") + buddyInfo->name ];
    if(p){
      if (p->ignoreSettings || (i_aimSettings->SoundMode == 0) &&
      (i_aimSettings->sound_enable_login == true) ){
        kApp->playFile(p->signOnSound);
				return;
			}
    }
    if((i_aimSettings->SoundMode == 1) &&
      (i_aimSettings->sound_enable_login == true) && !muteSoundForUs){
     	kApp->beep();
    }
    if((i_aimSettings->SoundMode == 0) &&
      (i_aimSettings->sound_enable_login == true) && !muteSoundForUs){
       kApp->playFile(i_aimSettings->sound_file_login);
    }
    return;
  }

  // We have a buddy
  if (i_aimSettings->main_showIdle == true){
    if (treeList->columnText(1) == "Idle")
 	    item2->setText(1,buddyInfo->idleTimeString);
    if (treeList->columnText(2) == "Idle")
	    item2->setText(2,buddyInfo->idleTimeString);
  }
  if (i_aimSettings->main_showLastOn == true){
    if (treeList->columnText(2) == "Last On")
      item2->setText(2,buddyInfo->lastOnString);
    if (treeList->columnText(1) == "Last On")
      item2->setText(1,buddyInfo->lastOnString);
  }

  // Set the icon
  QPixmap icon;
  if (buddyInfo->status !=  TAIM_ONLINE){
    ((BuddyListWindowItem *)item2)->setDecoration(BuddyListWindowItem::Offline);
    icon = SmallIcon("connect_no");
  }
  else{
    if (buddyInfo->signedOn == 1){
      icon =  SmallIcon("connect_established");
      ((BuddyListWindowItem *)item2)->setDecoration(BuddyListWindowItem::SignOn);
    }
  else{
    switch(buddyInfo->userClass){
        case TOC_USER_ADMIN:
          icon = SmallIcon("buddy_admin");
          break;
        case TOC_USER_AOL:
          icon = SmallIcon("buddy_aol");
          break;
        case TOC_USER_UNCONFIRMED:
          icon = SmallIcon("buddy_unknown");
          break;
        case TOC_USER_NORMAL:
          icon = SmallIcon("buddy_oscar");
          break;
        case TOC_USER_AWAY:
          icon = SmallIcon("buddy_away");
          break;
        default:
          icon = SmallIcon("buddy_unknown");
          break;
      }
			((BuddyListWindowItem *)item2)->setDecoration(BuddyListWindowItem::Online);
    }
  }
	QString buddyName = tocNormalize(buddyInfo->name);
  const pounce *pounceStruct = pounceMessages[ buddyName ];
	if(pounceStruct){
		// Create pixmap that has the same qualities as the current icon.
		QPixmap iconPounce(16,16,-1);
		iconPounce.setMask(*(icon.mask()));
		bitBlt(&iconPounce, 0,0, &icon,0,0,16,16,Qt::CopyROP, false);

		// get top mask
		QBitmap iconMask(16,16,-1);
		const QBitmap *CiconMask = iconPounce.mask();
		bitBlt(&iconMask, 0,0, CiconMask,0,0,16,16,Qt::CopyROP, false);

		// Get bottom mask
		QPixmap pounceIcon = SmallIcon("list_pounce");
		const QBitmap *pounceIconMask = pounceIcon.mask();
		bitBlt(&iconMask, 0,0, pounceIconMask, 0,0,16,16,Qt::OrROP, false);

		// Set new mask onto the new icon
		const QBitmap fm = iconMask;
		iconPounce.setMask(fm);

		// Copy new icon onto old icon.
		bitBlt(&iconPounce, 0,0, &pounceIcon, 0,0,16,16,Qt::CopyROP, false);

		item2->setPixmap(0, iconPounce);
	}
	else{
		item2->setPixmap(0, icon);
	}
}

/**
 * This will close all the existing open chatwindows.
 */
void BuddyListWindow::closeExistingChatwindows(){
  QDictIterator<ChatWindow> it( messageWindows );
  ChatWindow *cw;

  while( it.current() ){
    cw = messageWindows[ it.currentKey() ];
    if(cw)
      delete cw;
    messageWindows.remove( it.currentKey() );
    ++it;
  }
}

/**
 * This will clean up all the connections to the post* slots, and the
 * QValueLists
 */
void BuddyListWindow::clearPostConnections(void){
	QValueList<QString *>::Iterator it;

	for(it = signedOff.begin(); it != signedOff.end(); ++it){
		delete (*it);
	}
	signedOff.clear();

	for(it = signedOn.begin(); it != signedOn.end(); ++it){
		delete (*it);
	}
	signedOn.clear();

	for(it = awayMessageSent.begin(); it != awayMessageSent.end(); ++it){
		delete (*it);
	}
	awayMessageSent.clear();

	//disconnect the signals. does this disconnect the singleShots too??
	disconnect( this, SLOT(postBuddySignoff()) );
	disconnect( this, SLOT(postBuddySignon()) );
}

/**
 * Removes a buddy from the tree.  Called a little bit after they sign off.
 */
void BuddyListWindow::postBuddySignoff( ){
  QString *bud = 0;
  if( signedOff.count() != 0)
  bud = signedOff.first();

  if(!bud)
    return;

  // If the buddy is actually on then don't remove him.
  TBuddyList list = connection->buddyList();
  int num = list.getNum(*bud);
  if (num == -1)
    return;
  TBuddy *buddy = list.getByNum(num);
  // Only remove him if he is not online right now
  if (buddy->status != TAIM_ONLINE){
    if(!viewAll){ //remove the item from view only if we're not in view-All mode
      QListViewItemIterator it( treeList );
      for ( ; it.current(); it++ ){
        QString cName = ((BuddyListWindowItem*)it.current())->name;
	      if( cName == *bud ){
	        if(it.current()->parent()){

						TBuddy *b = list.getByNum( list.getNum(cName));
						if (b != NULL){
						  const TBuddyGroup *gc = list.getByNumG(b->group);
						  // Remove a number to group.
						  QString size = QString("%1/%2").arg( it.current()->parent()->childCount()-1 ) .arg(gc->size);
							it.current()->parent()->setText(0,((BuddyListWindowItem*)it.current()->parent())->name + " (" + size + ")");
						}
						else
							qDebug("Can't find buddy");

						it.current()->parent()->removeItem( it.current() );

	        }
	        break;
	      }
	    }
  	}
	}

  if (signedOff.isEmpty() != true){
    signedOff.remove( signedOff.begin() );
  }

  //dont leak memory:
  if(bud){
    delete bud;
  }
}

/**
 * Changes the icon of a buddy from just signed on to something else.
 */
void BuddyListWindow::postBuddySignon( ){
  QString *bud = 0;
  if( signedOn.count() != 0)
    bud = signedOn.first();

  if(!bud)
    return;

  TBuddyList list = connection->buddyList();
  int num = list.getNum(*bud);
  if (num == -1)
    return;

  TBuddy *buddy = list.getByNum(num);
  if (buddy){
    buddy->signedOn = 0;
    loadTreeBuddy(buddy);
    // Why do we do this?
    connection->setBuddyList(list);
  }
   if (signedOn.isEmpty() != true){
    signedOn.remove( signedOn.begin() );
  }

  //dont leak memory:
  if(bud){
    delete bud;
  }
}

/**
 * When a folder is expanded give it the open icon
 */
void BuddyListWindow::folderExpanded ( QListViewItem* item ){
  item->setPixmap(0, SmallIcon("folder_open"));
}

/**
 * When a folder is closed give it the closed icon
 */
void BuddyListWindow::folderCollapsed ( QListViewItem* item ){
  item->setPixmap(0, SmallIcon("folder_blue"));
}

/**
 * The server will update a buddy
 */
void BuddyListWindow::buddyChanged(int number){
  TBuddyList list = connection->buddyList();
  TBuddy *bud = list.getByNum(number);
  loadTreeBuddy(bud);
  // If signed off tell chat window and play sound if needed
  if (bud->status !=  TAIM_ONLINE){
    // Check to see if there is a sound configure on this buddy.
    pounce *p = pounceMessages[ QString("*sc") + bud->name ];
    bool playedSound = false;
    if(p){
      if (p->ignoreSettings || (i_aimSettings->SoundMode == 0) &&
      (i_aimSettings->sound_enable_logout == true) ){
        kApp->playFile(p->signOffSound);
        playedSound = true;
      }
    }
    if (playedSound == false) {
			if((i_aimSettings->SoundMode == 1) &&
       	(i_aimSettings->sound_enable_logout == true) && !muteSoundForUs){
      	kApp->beep();
    	}
    	if((i_aimSettings->SoundMode == 0) &&
       	(i_aimSettings->sound_enable_logout == true) && !muteSoundForUs){
      	 kApp->playFile(i_aimSettings->sound_file_logout);
      }
    }
    QString ChatWindowName = i_aimSettings->login_name + tocNormalize(bud->name);
    ChatWindow *targetWindow = messageWindows[ ChatWindowName ];
    if(targetWindow)
      targetWindow->contactSignedOff();

    //add to the signedOff users list
    signedOff += new QString(bud->name);
    // Timer to remove item
    QTimer::singleShot( POST_BUDDY_SIGNOFF_DELAY *1000, this, SLOT(postBuddySignoff()));

    //Inform the dock popup:
		emit dock_buddySignedOff(bud);
 
    autoResize();
  }

}

/**
 * Buddy Just signed on tell any chat window that need to know
 */
void BuddyListWindow::buddySignedOn(QString buddy){
  QString ChatWindowName = i_aimSettings->login_name + tocNormalize(buddy);
  ChatWindow *targetWindow = messageWindows[ ChatWindowName ];
  if(targetWindow)
    targetWindow->contactSignedOn();

  TBuddyList list = connection->buddyList();
  TBuddy *bud = list.getByNum(list.getNum(buddy));
  if (bud){
    bud->signedOn = 1;
    loadTreeBuddy(bud);
    signedOn += new QString(buddy);
    QTimer::singleShot( POST_BUDDY_SIGNON_DELAY *1000, this, SLOT(postBuddySignon()));
    // Why do we do this?
    connection->setBuddyList(list);

    //Inform the dock popup:
    emit dock_buddySignedOn(bud);
  }
  pounce_CheckSignOn(buddy);
  autoResize();
}

/**
 * Item in tree was selected/double clicked.  Open chat window
 */
void BuddyListWindow::DoubleClicked(){
  if (treeList->currentItem() == 0)
    treeList->setCurrentItem(treeList->firstChild());
  TreeSelected(treeList->selectedItem());
}

/**
 * Item in tree was selected/double clicked.  Open chat window
 */
void BuddyListWindow::TreeSelected(QListViewItem* selected){
  //qDebug("TreeSelected Called.");
  
  // If somehow we got a NULL just return
  if (selected == NULL)
     return;
  bool oldwindow = false;
  // If not a folder
  if (treeList->checkIfFolder(selected) == false){
    const QString buddyName = ((BuddyListWindowItem*)selected)->name;
    // check for window already exists
    if (messageWindows [i_aimSettings->login_name + tocNormalize(buddyName)] != NULL) {
	oldwindow = true;
    };
    ChatWindow *targetWindow = messageWindow(buddyName);
    // if this window was already there...then bring it up...
    if (oldwindow) {
        QRect thisGeometry = targetWindow->frameGeometry();
	targetWindow->hide();
        targetWindow->setGeometry(thisGeometry.x(), thisGeometry.y(), targetWindow->width(), targetWindow->height());
        targetWindow->show();
    };
    if (targetWindow != 0)
      targetWindow->show();
  } else {
    // if it is a folder...
    // KListView is not automatically doing this on double-click...
    if (selected->isOpen())
	selected->setOpen(false);
    else
	selected->setOpen(true);
  }
}

/**
 * Settings changed tell things to update
 */
void BuddyListWindow::settingsChanged(){
  if(connection->getStatus() == TAIM_OFFLINE)
    return;

  initOptions();
  emit (updateChatSettings());
  emit (updateChatColorSettings());
  emit (updateChatFontSettings());
  emit (updateChatSoundSettings());
  initAwayList();
}

/**
 * Add a buddy to the list
 */
void BuddyListWindow::slotAddBuddy(){
  //Make sure a folder exists and is selected
  if (treeList->currentItem() == 0)
    treeList->setCurrentItem(treeList->firstChild());
  if(!treeList->selectedItem())
  {
    QMessageBox::warning( 0, "Kinkatta - Add Buddy",
      "Please select a folder",
      "OK", /*"Quit",*/ 0,
      0, 1 );
    return;
  }
  QString name;
  bool ok = FALSE;
  QString text;

  #if QT_VERSION < 300
  text = QInputDialog::getText( tr( "Kinkatta - Enter Buddy's Name" ), tr( "Please enter the buddy's name" ), QString::null, &ok, this );
  #else
  text = QInputDialog::getText( tr( "Kinkatta - Enter Buddy's Name" ), tr( "Please enter the buddy's name" ), QLineEdit::Normal, QString::null, &ok, this );
  #endif
  if ( ok && !text.isEmpty() )
    slotAddBuddy(text);// user entered something and pressed ok
  else
    return	;// user entered nothing or pressed cancel
}

/**
 * Add a buddy to the list (buddyName)
 * @param buddyName buddyName to add
 */
void BuddyListWindow::slotAddBuddy(QString buddyName){
  TBuddyList list = connection->buddyList();
  int groupNumber = 0;
  BuddyListWindowItem *cItem = (BuddyListWindowItem*)(treeList->selectedItem());
  // If window is highlighted get group number.
  if ( cItem != NULL){
    if (treeList->checkIfFolder(cItem) == true){
      groupNumber = list.getNumGroup(cItem->name);
    }
    else{
      //get parent
      BuddyListWindowItem *parent = (BuddyListWindowItem*)(cItem->parent());
      groupNumber = list.getNumGroup(parent->name);
    }
  }

  // Update server
  TBuddy *edited = new TBuddy();
  edited->name = buddyName;
  edited->group = groupNumber;
  edited->status = TAIM_OFFLINE;
  edited->userClass = 0;
  edited->signonTime = 0;
  edited->evil = 0;
  edited->idleTime = 0;
  edited->userClass = 0;
  edited->signonTime = 0;
  edited->evil = 0;
  edited->lastOn = 0;
  edited->lastOnString = "";
  edited->idleTimeString = "";
  list.add(edited);
  connection->setBuddyList(list);
  loadList();
  delete edited;

  emit updateIfIsBuddy(buddyName, true);
  saveAimSettings();
}

/**
 * Removes a buddy from the list
 * Gets currently selected buddy and calls slotRemoveBuddy(name)
 */
void BuddyListWindow::slotRemoveBuddy(){
  QString name = treeList->currentName();
  slotRemoveBuddy(name);
  saveAimSettings();
}

/**
 * Remove the buddy from the current list
 * @Peram name - Name of the buddy that is to be removed
 */
void BuddyListWindow::slotRemoveBuddy(QString name){
  int answer = QMessageBox::warning(0, "Kinkatta - Remove Buddy",
    "Do you wish to remove this buddy from your buddylist?",
    "Yes", "Cancel", 0,1);
  if (!answer){
    TBuddyList list = connection->buddyList();
    list.del(list.getNum(name));
    connection->setBuddyList(list);
    loadList();
    emit updateIfIsBuddy(name, false);
  }
}

/**
 * Add a new folder to the list.
 */
void BuddyListWindow::slotAddFolder(){
  // Get current list
  TBuddyList list = connection->buddyList();
  list.addGroup(QString("NewFolder"));
  // Update server list
  connection->setBuddyList(list);
  viewAll = true;
  initViewAllSetting();
  // Add the folder to the gui and bring up the edit box on it.
  BuddyListWindowItem *groupItem = new BuddyListWindowItem (treeList, "NewFolder (0/0)");
  groupItem->setPixmap(0, SmallIcon("folder_open"));
  groupItem->name = "NewFolder";
	treeList->setCurrentItem(groupItem);
  slotEditBuddy();
  treeList->setSorting(0,1);
  treeList->sort();
  saveAimSettings();
}

/**
 * Remove the current selected folder
 */
void BuddyListWindow::slotRemoveFolder(){
  if( treeList->currentItem() )
    slotRemoveFolder( treeList->currentName() );
}

/**
 * Remove the passed folder
 * @param group the name of the group that we wish to remove.
 */
void BuddyListWindow::slotRemoveFolder(QString group){
  int answer = QMessageBox::warning(this, "Kinkatta - Remove Folder",
    "Do you wish to remove this folder from your buddylist?\nAll buddies in the folder will be lost.",
    "Yes", "Cancel", 0,1);
  if (!answer){
    TBuddyList list = connection->buddyList();
    list.delGroup(list.getNumGroup( group ));
    connection->setBuddyList(list);
    loadList();
  }
  saveAimSettings();
}

/**
 * Get information button clicked, get current highlighted name and get info
 */
void BuddyListWindow::slotGetBuddyInfo(){
  TWINDOW_AIM_SANITY_CHECK;
  if (treeList->currentItem() == 0)
    treeList->setCurrentItem(treeList->firstChild());
  if( treeList->currentItem() == NULL)
    return;

  const QString name = treeList->currentName();
  if (treeList->checkIfFolder(treeList->currentItem()) == false){
    slotGetBuddyInfo( name );
  }
  else{
    bool ok = FALSE;
    QString text;

  #if QT_VERSION < 300
  text = QInputDialog::getText( i18n( "Kinkatta - Enter Buddy's Name" ), i18n( "Please enter the buddy's name" ), QString::null, &ok, this );
  #else
  text = QInputDialog::getText( i18n( "Kinkatta - Enter Buddy's Name" ), i18n( "Please enter the buddy's name" ), QLineEdit::Normal, QString::null, &ok, this );
  #endif

    if ( ok && !text.isEmpty() )
      slotGetBuddyInfo( text );
  }
}

/**
 * Get Information on a user
 * @param name buddy to get information on.
 */
void BuddyListWindow::slotGetBuddyInfo(QString name){
  TWINDOW_AIM_SANITY_CHECK;
  if(awayRightNow == true)
    away_Back();
  connection->requestUserInfo( name );
}

/**
 * Info has been recieved
 * @Peram string - The info that was recieved
 */
void BuddyListWindow::slotBuddyInfoRecieved(QString string){
  Info *infoBox = new Info(0, "infoBox");
  infoBox->user = i_aimSettings->login_name;
  infoBox->addToWindow(string);
  infoBox->setCaption("Kinkatta - Information");
  infoBox->setIcon(SmallIcon("kinkatta"));
  infoBox->show();
}

/**
 * Bring up the edit box on the currently selected user.
 */
void BuddyListWindow::slotEditBuddy(){
  QString name = "";
  BuddyListWindowItem *cItem = treeList->currentItem();
  name = cItem->name;

  treeList->buddyEdit->setText("");
  treeList->buddyEdit->setText(name);

  QRect r = treeList->itemRect(cItem);
  int x = r.x()+35;
  if (treeList->checkIfFolder(cItem) == true)
    x = x - 19;
  int y = r.y();
  int width = treeList->columnWidth(0)-x;
  int height = r.height();

  treeList->buddyEdit->setGeometry(x,y,width,height);
  treeList->moveChild(treeList->buddyEdit,x,y);
  treeList->buddyEdit->setMinimumSize(width,height);
  treeList->buddyEdit->setMaximumSize(width,height);

  // Showing it will give it focus
  treeList->buddyEdit->focus = 0;
  treeList->buddyEdit->alias = false;
  treeList->buddyEdit->show();
  treeList->buddyEdit->setFocus();
  treeList->buddyEdit->setSelection(0,treeList->buddyEdit->maxLength());
}

/**
 * Bring up the edit box on the currently selected user.
 */
void BuddyListWindow::slotEditAlias(){
  QString name = "";
  BuddyListWindowItem *cItem = treeList->currentItem();
  if (treeList->checkIfFolder(cItem)){
    // Folders don't have aliases
    return;
  }
  name = cItem->text(0);
  // Remove @
  if (name != cItem->name)
    name = name.mid(1, name.length()-1);

  treeList->buddyEdit->setText("");
  treeList->buddyEdit->setText(name);

  QRect r = treeList->itemRect(cItem);
  int x = r.x()+35;
  int y = r.y();
  int width = treeList->columnWidth(0)-x;
  int height = r.height();

  treeList->buddyEdit->setGeometry(x,y,width,height);
  treeList->moveChild(treeList->buddyEdit,x,y);
  treeList->buddyEdit->setMinimumSize(width,height);
  treeList->buddyEdit->setMaximumSize(width,height);

  // Showing it will give it focus
  treeList->buddyEdit->focus = 0;
  treeList->buddyEdit->alias = true;
  treeList->buddyEdit->show();
  treeList->buddyEdit->setFocus();
  treeList->buddyEdit->setSelection(0,treeList->buddyEdit->maxLength());
}

/**
 * Once the edit window is gone update the name
 */
void BuddyListWindow::changeBuddyName(){
  BuddyListWindowItem *cItem = treeList->currentItem();
  QString oldName = "";
  QString realName = "";

  if ( cItem == NULL)
    return;
  
  realName = cItem->name;
  if (treeList->buddyEdit->alias == true){
    oldName = cItem->text(0);
    if (oldName != realName)
      oldName = oldName.mid(1, oldName.length()-1);
  }
  else
    oldName = realName;

  QString newName = treeList->buddyEdit->text();

  // Update List
  TBuddyList list = connection->buddyList();
  if (treeList->checkIfFolder(cItem) == true){
    list.renameGroup( oldName, newName );
    connection->setBuddyList(list);
    loadList();
  }
  else{
    TBuddy *edited = list.getByNum(list.getNum(realName));
    if (edited){
      if (treeList->buddyEdit->alias == true)
        edited->alias = newName;
      else
        edited->name = newName;
        connection->setBuddyList(list);
        loadList();
      }
  }
  
  treeList->buddyEdit->hide();
  saveAimSettings();
}

/**
 * The tree was clicked with the right mouse button, open  the menu.
 * @param pos location to show the menu
 */
void BuddyListWindow::rightClickInTree(QListViewItem *, const QPoint &pos, int){
  if (treeList->currentItem() == 0)
    treeList->setCurrentItem(treeList->firstChild());
  if(treeList->currentItem() == NULL)
    return;

  QListViewItem *selected = treeList->currentItem();
  if (treeList->checkIfFolder(selected))
    folderRightClickMenu->popupMenu()->exec(pos);
  else
    buddyRightClickMenu->popupMenu()->exec(pos);
}

/**
 * Open buddies logs in netscape
 */
void BuddyListWindow::slotOpenLogs(){
  QString buddy = treeList->currentName();
  buddy = buddy.lower();
  QDir newDir("/dev/null");
  // Make sure the dir is there
  newDir.mkdir(QDir::homeDirPath() + "/." + QString(APP_LOWERCASE_NAME), true);
  newDir.mkdir(QDir::homeDirPath() + "/." + QString(APP_LOWERCASE_NAME) + "/logs/", true);
  QString logDirStr = QDir::homeDirPath() + "/." + APP_LOWERCASE_NAME + "/logs/" + buddy + "/";

  newDir.mkdir(logDirStr,true);

  QDir logDir(logDirStr);

  // If there is only 1 log file and its [buddy].log, I bet they want that
  if ( (logDir.count() == 3 ) && QFile( logDirStr + buddy + ".log" ).exists() )
    logDirStr += buddy + ".log";

  kApp->invokeBrowser( logDirStr );
}

/**
 * We're about to show the file menu, so set the appropriate items in the buddy
 * popup menu and the folder popup menu activated or inactivated.
 */
void BuddyListWindow::aboutToShowFileMenu(){
  QListViewItem *selected = treeList->selectedItem();
  if(!selected){
    id_folderEdit->setEnabled(false);
    id_folderRemove->setEnabled(false);
    buddyMenu->setEnabled(false);
    //_FileMenu->setItemEnabled(id_buddyList, FALSE);
    return;
  }

  if( treeList->checkIfFolder(selected) ){
    id_folderEdit->setEnabled(true);
    id_folderRemove->setEnabled(true);
    buddyMenu->setEnabled(false);
    //_FileMenu->setItemEnabled(id_buddyList, FALSE);
  } else { //not a folder
    id_folderEdit->setEnabled(false);
    id_folderRemove->setEnabled(false);
    buddyMenu->setEnabled(true);
    //_FileMenu->setItemEnabled(id_buddyList, TRUE);
  }
}

/**
 * Brings up the Menu when the right mouse is clicked.
 * @param event mouse event.
 */
void BuddyListWindow::mouseReleaseEvent(QMouseEvent* event){
  if (event->button() == RightButton){
    _AwayMenu->hide();
  }
}

/**
 * Bring up the dialog to change the users password, connect to network
 */
void BuddyListWindow::changePassword(){
  KitPasswordChanger dlg;
  dlg.setOldPassword(i_aimSettings->login_password);
   dlg.setIcon(SmallIcon("kinkatta"));
  if(dlg.exec()) {
    connection->changePassword(dlg.oldPassword(), dlg.newPassword());
    // newPassword = dlg.newPassword();
  }
}



/**
 * Resizes the object in the window, when the window is resized.
 */
void BuddyListWindow::resizeEvent ( QResizeEvent* e) {
  int moveDown = setup::settings()->main_moveDown;
  if ( setup::settings()->main_loginMoveLeft == true){
    setGeometry(geometry().x() - frameGeometry().x(), (geometry().y()-frameGeometry().y())+moveDown,
                width(),height());
  }
  if ( i_aimSettings->main_loginMoveRight == true){
    // length of the desktop
    int desktopWidth = (KApplication::desktop())->width();
    //int wmSideWidth = (desktopWidth - frameGeometry().x() - width())/2;
    int wmSideWidth = (frameGeometry().width() - width())/2;
    setGeometry( desktopWidth - width() - wmSideWidth,
                 (this->geometry().y() - this->frameGeometry().y()) + moveDown,
                 width(),height());

  }


  //QWidget::resizeEvent(e);
  //this->setWidth((e->size()).width());
  //this->setHeight((e->size()).height());
  int mid = this->width()/2;

  if(awayRightNow == false){
    if (i_aimSettings->main_noIcons == true){
       treeList->setGeometry (0, menuBar()->height(), this->width(), this->height()-28);
    }
    else{
      treeList->setGeometry (0, menuBar()->height(), this->width(), this->height()-75);
      chatButton->setGeometry (mid-65, this->height()-45, 40, 40);
      awayButton->setGeometry (mid-20, this->height()-45, 40, 40);
      infoButton->setGeometry (mid+25, this->height()-45, 40, 40);
    }
  }
  else { //awayRightNow == true
    if (i_aimSettings->main_noIcons == true){
      treeList->setGeometry (0, menuBar()->height(), this->width(), this->height()-28-DEFAULT_AWAYWIDGET_HEIGHT);
      awayWidget->setGeometry(0, this->height()-DEFAULT_AWAYWIDGET_HEIGHT, treeList->width(), DEFAULT_AWAYWIDGET_HEIGHT);
    }
    else{
     treeList->setGeometry (0, menuBar()->height(), this->width(), (this->height()-75-DEFAULT_AWAYWIDGET_HEIGHT));
     chatButton->setGeometry (mid-65, this->height()-45-DEFAULT_AWAYWIDGET_HEIGHT, 40, 40);
     awayButton->setGeometry (mid-20, this->height()-45-DEFAULT_AWAYWIDGET_HEIGHT, 40, 40);
     infoButton->setGeometry (mid+25, this->height()-45-DEFAULT_AWAYWIDGET_HEIGHT, 40, 40);
     awayWidget->setGeometry (0, this->height()-DEFAULT_AWAYWIDGET_HEIGHT, this->width(), DEFAULT_AWAYWIDGET_HEIGHT);
    }
  }
}


/**
 * Automaticly resizes the object in the window to increase/shrink for the new buddies.
 */
void BuddyListWindow::autoResize(){
  if(autoResizing == true){
    return;
  }

  //  return;
  if (i_aimSettings->main_resizeHeight == false && i_aimSettings->main_resizeWidth == false ){
    autoResizing = false;
    return;
  }
  
  autoResizing = true;
 
  // If it is off then we are still in this loop and exit.
  if (treeList->vScrollBarMode() == QScrollView::AlwaysOff ||
      treeList->vScrollBarMode() == QScrollView::AlwaysOff ){
     autoResizing = false;
     return;
  }

  if (treeList->vScrollBarMode() == QScrollView::Auto &&
      treeList->vScrollBarMode() == QScrollView::Auto ){
    treeList->setVScrollBarMode(QScrollView::AlwaysOff);
    treeList->setHScrollBarMode(QScrollView::AlwaysOff);
    qApp->processEvents();
  }
  else{
    autoResizing = false;
    return;
  }
 
  bool greaterThenMaxHeight = false;

  if (i_aimSettings->main_resizeHeight == true){
    int newHeight;
    newHeight = this->height()+(treeList->contentsHeight() - treeList->visibleHeight());
    newHeight += treeList->header()->height();

    int diff =  newHeight - (treeList->height());
    //if( treeList->horizontalScrollBar()->isVisible() == true )
    //  newHeight += treeList->horizontalScrollBar()->height();
    
    if ( diff > 0 ){
      if ( newHeight > i_aimSettings->main_resizeHeightMin && newHeight < i_aimSettings->main_resizeHeightMax )
        resize(this->width(), newHeight );
      else
        greaterThenMaxHeight = true;
    }
  }

  if (i_aimSettings->main_resizeWidth == true){
    // Outside mesh
    int width = 10;
    if (greaterThenMaxHeight == true){
      width += 15; //treeList->verticalScrollBar()->width();
    }
    // headers
    int numberOfHeaders = (treeList->header())->count();
    for (int i = numberOfHeaders; i > 0; i--)
      width += treeList->columnWidth(i-1);
    // Add frame boarder
    width += treeList->lineWidth()*2+2;
    
    //if( treeList->verticalScrollBar()->isVisible() == true )
    //  newHeight += treeList->verticalScrollBar()->width();

    if ( width != treeList->width() ){
      if (width > i_aimSettings->main_resizeWidthMin && width < i_aimSettings->main_resizeWidthMax){
        //qDebug(QString("%1").arg(width).latin1());
        if(width > 140)
          resize(width, this->height());
      }
    }
  }

  if (treeList->vScrollBarMode() != QScrollView::Auto &&
      treeList->vScrollBarMode() != QScrollView::Auto ){
    treeList->setVScrollBarMode(QScrollView::Auto);
    treeList->setHScrollBarMode(QScrollView::Auto);
  }
  autoResizing = false;
}


/**
 * Edit the currently selected buddy's sound config.  If they already have
 * one then it should be loaded.
 */
void BuddyListWindow::editSoundConfig(){
  if (!treeList->currentName())
    treeList->setCurrentItem(treeList->firstChild());

  const QString name = treeList->currentName();
  if (treeList->checkIfFolder(treeList->currentItem()) == true){
    return;
  }

  SoundConfigureImp *sc = new SoundConfigureImp(this, "SoundConfigure");
  connect(sc, SIGNAL(updateOrAddPounce(pounce)), this, SLOT(setSoundConfig(pounce)));

  pounce p;
  p.buddyName = name;
  p.signOnSound = i_aimSettings->sound_file_login;
  p.signOffSound = i_aimSettings->sound_file_logout;
  p.ignoreSettings = false;
  sc->setDefault(&p);
  sc->setPounce(&p);

  // If there is already a Pounce you want to edit it.
  QString buddyName = tocNormalize(name);
  pounce *pounceStruct = pounceMessages[ QString("*sc") + buddyName ];
  if (pounceStruct){
    //qDebug("Foudn old pounce");
    sc->setPounce(pounceStruct);
  }
	sc->show();
}

/**
 * update a buddy's sound config.  If the sound config it == to the default
 * then it should be removed.
 */
void BuddyListWindow::setSoundConfig(pounce newPounce){
  QString BuddyName = newPounce.buddyName;
  QString realName = BuddyName;
  BuddyName = tocNormalize(BuddyName);

  if (newPounce.signOnSound == i_aimSettings->sound_file_login &&
	newPounce.signOffSound == i_aimSettings->sound_file_logout &&
  newPounce.ignoreSettings == false){
    pounce *newPounceStruct = pounceMessages[  QString("*sc") + BuddyName ];
    if(newPounceStruct)
      pounceMessages.remove( QString("*sc") + BuddyName);
    //qDebug("Removed Pounces");
    i_aimSettings->pounces = pounceMessages;
    setup::instance()->savePounces(i_aimSettings->login_name,i_aimSettings->pounces);
    return;
  }
	pounce *newPounceStruct = pounceMessages[ QString("*sc") + BuddyName ];
  if(!newPounceStruct){
    pounce *p = new pounce();
    p->buddyName = newPounce.buddyName;
    p->hidden = true;
    p->doNotRemove = true;
    p->signOn = false;
    p->returnAway = false;
    p->returnIdle = false;
    p->openChat = false;
    p->sendMessage = false;
    p->execCommand = false;
    p->command = "";
    p->message = "";
    p->signOnSound = newPounce.signOnSound;
    p->signOffSound = newPounce.signOffSound;
    p->ignoreSettings = newPounce.ignoreSettings;
    pounceMessages.insert( QString("*sc") + BuddyName, p);
    i_aimSettings->pounces = pounceMessages;
    setup::instance()->savePounces(i_aimSettings->login_name,i_aimSettings->pounces);
  }
  else{
    newPounceStruct->signOnSound = newPounce.signOnSound;
    newPounceStruct->signOffSound = newPounce.signOffSound;
    newPounceStruct->ignoreSettings = newPounce.ignoreSettings;
    i_aimSettings->pounces = pounceMessages;
    setup::instance()->savePounces(i_aimSettings->login_name,i_aimSettings->pounces);
  }
  //qDebug("New Pouncesc/update!");
}



/**
 *
 *
 * The away Functions.
 *
 *
 */


/**
 * Simply return if we are awawy or not.  Used for plugins.
 */
bool BuddyListWindow::away_isAwayRightNow(){
  return awayRightNow;
}


/**
 * 5 minutes after a away message is sent the send away message again is
 * turned back on.
 */
void BuddyListWindow::postAwayMessageSent( ){
  QString *bud = 0;
  if( awayMessageSent.count() != 0)
    bud = awayMessageSent.first();

  if(!bud)
    return;
  QString normedName = tocNormalize(*bud);
  QString ChatWindowName = (i_aimSettings->login_name) + normedName;
  ChatWindow *targetWindow = messageWindows[ChatWindowName];
  if(targetWindow){
    //targetWindow->sentAwayMessageToBuddy = false;
  }

  sentAwayMessageToWindow.remove(targetWindow);

  if (awayMessageSent.isEmpty() != true){
    awayMessageSent.remove( awayMessageSent.begin() );
  }

  //dont leak memory:
  if(bud){
    delete bud;
  }
}

/**
 * Loads the Awaylist under the list.
 */
void BuddyListWindow::initAwayList(){
  _AwayMenu->clear();
  QMap <QString, QString>::Iterator it;
  int count = 1;
  for(it = i_aimSettings->mapAwayMessages->begin();
    it != i_aimSettings->mapAwayMessages->end(); ++it){
    _AwayMenu->insertItem(it.key(), count++);
  }
  _AwayMenu->insertSeparator();
  _AwayMenu->insertItem("&New Message...", this, SLOT(away_AddAwayMessage()),
						0, NEW_AWAY_MESSAGE_MENU_ID);
}

/**
 * The away button was clicked show the list there.
 */
void BuddyListWindow::away_ShowAwayList(){
  initAwayList();
  QPoint temp(this->x()+awayButton->x()+20,this->y()+awayButton->y()+50);
  _AwayMenu->exec(temp);
  awayButton->setDown(false);
}

/**
 * The auto away timer has signaled, set user as away.
 */
void BuddyListWindow::away_SetAutoAway(){
  //set the autoAway to the correct away message as specified by the user
  if (i_aimSettings->away_enable_auto == true){
    if (awayRightNow == false)
      away_makeAwayNow(i_aimSettings->away_auto_default_message);
  }
}

/**
 * Add a new away message.
 */
void BuddyListWindow::away_AddAwayMessage(){ 
  //  QMessageBox::information(this, "Away Messages","Use program/options to add away\nmessages for the time being.", QMessageBox::Ok);
  NewAwayMessage *newMessage = new NewAwayMessage(this, "newAwayMessage");
  newMessage->setCaption("Kinkatta - New Away Message");

  connect(newMessage, SIGNAL(makeAwayNow(QString)), this, SLOT(away_makeAwayNow(QString)));
  connect(newMessage, SIGNAL(saveSettings()), this, SLOT(saveAimSettings()));
  connect(newMessage, SIGNAL(saveSettings()), this, SLOT(initAwayList()));
  newMessage->show();
}

/**
 * Find out what number name is in the list and call away(int)
 */
void BuddyListWindow::away_makeAwayNow(QString name){
  int count = 1;
  int choice = -1;
  QMap <QString, QString>::Iterator it;
  for(it = i_aimSettings->mapAwayMessages->begin();
      it != i_aimSettings->mapAwayMessages->end(); ++it){
      if(it.key() == name){
        choice = count;
    }
    count++;
  }
  if (choice != -1){
    away_GoAway(choice);
  }
}

/**
 * Set the away message to text
 */
void BuddyListWindow::away_Update(QString text){
  //connection->setAwayMessage(text);
  awayMessage = text;
}

/**
 * Used by plugins to set the away message
 */
void BuddyListWindow::away_setAwayMessageNow( QString message ){
  muteSound(i_aimSettings->away_disable_sound);
  awayWidget->setText( message );
  awayWidget->show();
  if (awayRightNow == false){
    awayRightNow = true;
    if ((i_aimSettings->main_resizeHeight == true && i_aimSettings->main_resizeHeightMax < this->height() + DEFAULT_AWAYWIDGET_HEIGHT) || i_aimSettings->main_resizeHeight == false)
      resize(this->width(), this->height() + DEFAULT_AWAYWIDGET_HEIGHT);
    else
      resize(this->width(), this->height()-1);
      autoResize();
  
    awayMessage = message;
    if (message.length() > 1000){
      message = message.mid(0, 950);
      message = message + "... Im me for the rest of this away message.";
    }
    connection->setAwayMessage(message);
  }
}

/**
 * Set Kinkatta to away mode.
 */
void BuddyListWindow::away_GoAway(int num){
  if(num == NEW_AWAY_MESSAGE_MENU_ID)
    return;
  
  muteSound(i_aimSettings->away_disable_sound);

  QMap <QString, QString>::Iterator it;
  int count = 1;
  emit dock_statusChanged(TAIM_AWAY);
  
  for(it = i_aimSettings->mapAwayMessages->begin();
    it != i_aimSettings->mapAwayMessages->end(); ++it){
      if(count == num){
        awayWidget->setText(it.data());
			awayMessage = it.data();
			if( awayRightNow == false){
				QString message = it.data();
				if (message.length() > 1000){
				  message = message.mid(0, 950);
				  message = message + "... Im me for the rest of this away message.";
				}
				connection->setAwayMessage(message);
			}
			break;
		} else {
			count++;
		}
	}
  if ((num != 0) && (num == count)){
    awayWidget->show();
    if (awayRightNow == false){
      awayRightNow = true;
      if ((i_aimSettings->main_resizeHeight == true && i_aimSettings->main_resizeHeightMax < this->height() + DEFAULT_AWAYWIDGET_HEIGHT) || i_aimSettings->main_resizeHeight == false)
          resize(this->width(), this->height() + DEFAULT_AWAYWIDGET_HEIGHT);
	else
	  resize(this->width(), this->height()-1);

      autoResize();
    }
  }
}

/**
 * Set away = false.  Kinkatta autoresponds.
 */
void BuddyListWindow::away_Back(){
  if (i_aimSettings->away_comeBackOnlyOnBackClick == false){
    away_BackForReal();
  }
}

/**
 * Set away = false.  Kinkatta autoresponds.
 */
void BuddyListWindow::away_BackForReal(){
  muteSound(false);
  awayRightNow = false;
  awayWidget->hide();
  connection->setAwayMessage(QString(""));
  resize(this->width(), this->height() - DEFAULT_AWAYWIDGET_HEIGHT);
  emit dock_statusChanged(TAIM_ONLINE);
  this->resizeEvent(0);
}





/**
 *
 *
 * The chat Functions. (used by both chatroom and chatwindow.
 *
 *
 */

/***************************************************************************
 * Send an IM message.  If the room is not equal to 0 then you want to send
 * to a chatroom.
 * @param message the message that is going out.
 * @param contactName the person to whom the message is going too.
 ***************************************************************************/
void BuddyListWindow::chat_sendImOut(QString message, QString contactName){
  TWINDOW_AIM_SANITY_CHECK;
  if (sendingPounce == false){
    if(awayRightNow == true)
      away_Back();
    emit sendMessageChat(message, contactName, false, true);
  }
  else{
    emit sendMessageChat(message, contactName, false, false);
  }
}


/**
 *
 *
 * The chatWindow Functions.
 *
 *
 */

/**
 * A message came in. Open window and send massage
 * @param message the message that is coming in.
 * @param contactName the person to whom message should go to.
 * @param isAuto if the message is an automatic reply.
 */
void BuddyListWindow::receivedIM(QString message, QString contactName, bool isAuto){
  if (i_aimSettings->ignore_automated_get_away == true){
    if (message == QString(">>>Automated Message: Getting Away Message<<<")){
      if (awayRightNow == true){
        chatWindow_sendAutoIM(awayMessage, contactName);
	return;
      }
    }
  }
  
  ChatWindow *targetWindow = messageWindow(contactName);
  targetWindow->show();
  // Slot autoin
  if (isAuto){
    message = QString("<B>Auto Response: </B>") + message;
  }
  targetWindow->updateBuddyName(contactName);
  targetWindow->messageIn(message);
  if (awayRightNow == true){
    if (sentAwayMessageToWindow.find(targetWindow) == -1){

      QString outMessage = awayMessage;
      QString currentDate = QDate::currentDate().toString();
      QString currentTime = QTime::currentTime().toString();
      outMessage.replace( QRegExp("%d"), currentDate );
      outMessage.replace( QRegExp("%t"), currentTime );
      outMessage.replace( QRegExp("%n"), contactName );

      QString awayMessage = QString("<B>") + "Auto Reply:</B> " + outMessage +"\n";
      targetWindow->postMessage(awayMessage);
      chatWindow_sendAutoIM(awayMessage, contactName);
      sentAwayMessageToWindow.append(targetWindow);

      //targetWindow->sentAwayMessageToBuddy = true;

      awayMessageSent += new QString(contactName);
      QTimer::singleShot( POST_AWAY_MESSAGE_SENT_DELAY *1000, this, SLOT(postAwayMessageSent()));
    }
  }
}

/**
 * Send an auto IM message.  Idle time doesn't change and other im client
 * may interprite this message differently.
 * @param target person to whom the message is going too.
 * @param message the message to send to them.
 */
void BuddyListWindow::chatWindow_sendAutoIM(QString contactName, QString message){
  TWINDOW_AIM_SANITY_CHECK;
  emit sendMessageChat(contactName, message, true, true);
}


/**
 * Open a chat window with 'contactName'
 * @param contactName name of the person to chat with
 */
void BuddyListWindow::chatWindow_ChatWithBuddy(QString contactName){
  ChatWindow *targetWindow = messageWindow( contactName );
  if ( NULL != targetWindow ){
    targetWindow->show();
    targetWindow->raise();
  }
}

/**
 * init the global chat window settings.  Then set up them.
 */
void BuddyListWindow::initChatSettings(){
  emit( updateChatSettings() );
  emit( updateChatColorSettings() );
  emit( updateChatFontSettings() );
  emit( updateChatSoundSettings() );
}

/**
 * Check what name is wanted to chat with
 */
void BuddyListWindow::chatWindow_ChatWithBuddy(){
  if (treeList->currentItem() == 0)
    treeList->setCurrentItem(treeList->firstChild());
  QString name = "";
  QListViewItem  *cItem = treeList->currentItem();
  if ( cItem != NULL)
    name = treeList->currentName();
  if (treeList->checkIfFolder(cItem) == true)
    name = "";

	bool ok = false;
  QString text;
  #if QT_VERSION < 300
  text = QInputDialog::getText( tr( "Kinkatta - New Instant Message" ), tr( "Please enter the buddy's name" ), QString::null, &ok, this );
  #else
  text = QInputDialog::getText( tr( "Kinkatta - New Instant Message" ), tr( "Please enter the buddy's name" ), QLineEdit::Normal, QString::null, &ok, this );
  #endif
  if ( ok && !text.isEmpty() )
    chatWindow_ChatWithBuddy( text );
}

/**
 * Get a Chat Window
 * @param contactName the chat window to which we are chatting to return.
 */
ChatWindow *BuddyListWindow::messageWindow(const QString &contactName){
  QString ChatWindowName = i_aimSettings->login_name + tocNormalize(contactName);
  ChatWindow *targetWindow = messageWindows[ ChatWindowName ];
  if(targetWindow == NULL){
    TBuddyList list = connection->buddyList();
    if (list.getNum(contactName) == -1){
      targetWindow = new ChatWindow(i_aimSettings->login_name, contactName, false);
    }
    else{
      TBuddy *edited = list.getByNum(list.getNum(contactName));
      QString alias = "";
      if (edited)
        alias = edited->alias;
      if (alias == contactName)
        alias = "";

      targetWindow = new ChatWindow(i_aimSettings->login_name, contactName, true,0,alias);
      
    }
    emit (creatingChatWindow((Chat*)targetWindow));
    messageWindows.insert(ChatWindowName, targetWindow);
    connect(targetWindow, SIGNAL(messageOut(QString, QString)), this, SLOT(chat_sendImOut(QString, QString)) );
    messageWindows.setAutoDelete(false);
    targetWindow->updateChatSettings();
    targetWindow->updateChatColorSettings();
    targetWindow->updateChatSoundSettings();
    targetWindow->updateChatFontSettings();
    // Signals out from ChatWindow
    connect(targetWindow, SIGNAL(addContact(QString)), this, SLOT(slotAddBuddy(QString)));
    connect(targetWindow, SIGNAL(removeContact(QString)), this, SLOT(slotRemoveBuddy(QString)));
    connect(targetWindow, SIGNAL(blockBuddy(QString)), this, SLOT(chatWindow_BlockBuddy(QString)));
    connect(targetWindow, SIGNAL(warningOut(QString)), this, SLOT(chatWindow_WarnBuddy(QString)) );
    connect(targetWindow, SIGNAL(getInfo(QString)), this, SLOT(slotGetBuddyInfo(QString)) );
    connect(targetWindow, SIGNAL(pounce(QString)), this, SLOT(pounce_SlotAddDialogWithBuddyName(QString)));

    connect(targetWindow, SIGNAL(openURL(const QString &)), kApp, SLOT(invokeBrowser(const QString &)));
    connect(targetWindow, SIGNAL(soundBeep()), kApp, SLOT(beep()));
    connect(targetWindow, SIGNAL(soundPlayFile(const QString &)), kApp, SLOT(playFile(const QString &)));

    // Update Singles to Chat Window
    connect(this, SIGNAL(updateChatSettings()), targetWindow, SLOT(updateChatSettings()));
    connect(this, SIGNAL(updateChatColorSettings()), targetWindow, SLOT(updateChatColorSettings()));
    connect(this, SIGNAL(updateChatFontSettings()), targetWindow, SLOT(updateChatFontSettings()));
    connect(this, SIGNAL(updateChatSoundSettings()), targetWindow, SLOT(updateChatSoundSettings()));
    connect(this, SIGNAL(updateIfIsBuddy(QString,bool)), targetWindow, SLOT(setIfIsBuddy(QString, bool)));

    // Quit signal from Chat Window
    connect(targetWindow, SIGNAL(quiting(QString)), this, SLOT(chatWindow_RemoveWindow(QString)));
    targetWindow->show();
  }

  return targetWindow;
}

/**
 * When a buddy window dies it needs to be removed from our internal list
 * @param contactName the name of the buddy whom the windows belonged too.
 */
void BuddyListWindow::chatWindow_RemoveWindow(QString contactName){
  QString normedName = i_aimSettings->login_name + tocNormalize(contactName);
  ChatWindow *targetWindow = NULL;
  targetWindow = messageWindows[ normedName ];
  if (targetWindow != NULL)
  {
    emit ( distroyingChatWindow((Chat*)targetWindow) );
    messageWindows.remove(normedName);
    delete targetWindow;
  }
}

/**
 * block buddy "name"
 * @param contactName - Name of the buddy that is to be Blocked
 */
void BuddyListWindow::chatWindow_BlockBuddy(QString contactName){
  QString buddyName = "";
  int answer = QMessageBox::warning(0, "Kinkatta - Block Buddy",
    "Do you wish to block this buddy from your buddylist?",
    "Yes", "Cancel", 0,1);
  if (!answer){
    TBuddyList list = connection->denyList();
    TBuddy *edited = new TBuddy();
    edited->name = contactName;
    edited->group = 0;
    edited->status = TAIM_OFFLINE;
    edited->userClass = 0;
    edited->signonTime = 0;
    edited->evil = 0;
    list.add(edited);
    delete edited;
    connection->setDenyList(list);
    connection->setServerDenyList(list);
    if(connection->permissions() != 4)
      connection->setPermissions(4);
  }
}

/**
 * Prompt if you really want to warn "name"
 * Prompt if you want to do in anon or not
 * @Param contactName - Name of the buddy that is to be Warned
 */
void BuddyListWindow::chatWindow_WarnBuddy(QString contactName){
  QString buddyName = "";
  int answer = QMessageBox::warning(0, "Kinkatta - Warn",
    QString("Do you wish to warn ") + contactName + "?",
    "Yes", "Cancel", 0,1);
  if (!answer){
    int anon = QMessageBox::warning(this, "Kinkatta - Message",
     "Do you wish to warn anonymously?",
     "Yes", "No", 0,1);
    if (!anon)
      chatWindow_SendWarning(contactName, true);
    else
      chatWindow_SendWarning(contactName, false);
  }
}

/**
 * Send an IM warning against name
 * @Param contactName - Name of the buddy
 * @Param isAnonymouse - warn anonymouse or not.
 */
void BuddyListWindow::chatWindow_SendWarning(QString contactName, bool isAnonymous){
  TWINDOW_AIM_SANITY_CHECK;
  connection->sendWarning(contactName, isAnonymous);
}








/**
 *
 *
 * The Chat room Functions.
 *
 *
 */

/**
 * The user has decided to join a chat, Ask them for the name of the room
 * that they would like to join and tell the server.
 */
void BuddyListWindow::chatRoom_JoinButton(){
  bool ok = false;
  QString text;

  #if QT_VERSION < 300
  text = QInputDialog::getText( tr( "Enter a chat room name you wish to join/start." ), tr( "Please enter the room name you wish to join/start." ), QString::null, &ok, this );
  #else
  text = QInputDialog::getText( tr( "Enter a chat room name you wish to join/start." ), tr( "Please enter the room name you wish to join/start." ), QLineEdit::Normal, QString::null, &ok, this );
  #endif

  if ( ok && !text.isEmpty() ){
    int answer = QMessageBox::information(0, "Kinkatta - Join Chat Room",
    "Aim Private or AOL Community Public", "Public", "Private", 0,1);
    if (!answer)
      connection->chatJoin(text, 5);
    else{
      connection->chatJoin(text, 4);
    }
  }
}

/**
 * You have just joined a chatroom.  Create/show room and set it up.
 * @param roomNumber the chat room's number.
 * @param roomName the name of the chatroom.
 */
void BuddyListWindow::chatRoom_Joined(int roomNumber, QString roomName){
  ChatRoom *chatRoom = getAChatRoom( roomNumber, roomName );
  if ( NULL != chatRoom ){
    chatRoom->setCaption( roomName +" - Kinkatta chat room");
  }
}

/**
 * A message has come in for a chat room.  Find the room and pass the message in.
 * @param roomNumber the number of the room.
 * @param contactName the contact that is sending the message.
 * @param whisper - no longer used.
 * @param message the message that contact is sending.
 */
void BuddyListWindow::chatRoom_In( int roomNumber, QString contactName, bool whisper, QString message ){
  ChatRoom *chatRoom = getAChatRoom( roomNumber );
  if ( NULL != chatRoom ){
    chatRoom->messageInParse( contactName, whisper, message );
  }
}

/**
 * A buddy in a chatroom has been updated.
 * @param roomNumber the number of the room.
 * @param newStatus the new status of the contact
 * @param contact the person too whom the new status information goes to.
 */
void BuddyListWindow::chatRoom_UpdateBuddy( int roomNumber, bool newStatus, QString contactName ){
  ChatRoom *chatRoom = getAChatRoom( roomNumber );
  if ( NULL != chatRoom ){
    chatRoom->updateBuddy(contactName, newStatus);
  }
}

/**
 * Someone has invited you into a chat room.  Asks if the user accepts
 * the invitation and if so send back a chatAccept.
 * @param roomName the name of the room
 * @param roomNumber the number of the chatroom.
 * @param sender the contact that is inviting you to the room.
 * @param message the message that they are inviting you with.
 */
void BuddyListWindow::chatRoom_Invite(QString roomName, int roomNumber, QString sender, QString message){
  QString theMessage = sender + ": " + message;
  if (message.length() == 0)
    theMessage = "";
  int answer = QMessageBox::information(0, "Kinkatta - Join Chat Room",
  QString("You have been invited to a chat room \"") + roomName +"\" by " + sender + "\n" + theMessage,
    "Yes", "No Thanks", 0,1);
  if (!answer){
    connection->chatAccept(roomNumber);
  }
}

/**
 * Someone has invited you into a chat room.  Simply ask if the user accpts
 * the invitation and if so send back the chatAccept.
 * @param room the room to invite people too.
 */
void BuddyListWindow::chatRoom_ShowInvite( int roomNumber ){
  ChatRoomInviteImp *chatroominvite = new ChatRoomInviteImp(this, "ChatRoomInvite");
  chatroominvite->setRoomNumber(roomNumber);
  connect(chatroominvite, SIGNAL(inviteBuddy(int,QString,QString)), connection, SLOT(chatInvite(int, QString, QString)));
  TBuddyList list = connection->buddyList();
  int numberOfBuddies = list.getCount();
  for(int i = 0; i < numberOfBuddies; i++){
   if (list.getName(i) != i_aimSettings->login_name)
     chatroominvite->buddyList->insertItem(list.getName(i), -1);
  }
  chatroominvite->show();
}

/**
 * You have left the chat room 'room', If the chat room exists tell it.
 * @param roomNumber the room to let know that you are not curreently connected to.
 */
void BuddyListWindow::chatRoom_Left(int roomNumber){
  if (chatRoom_isThereARoom(roomNumber) == true){
    ChatRoom *chatRoom = getAChatRoom(roomNumber);
    if ( NULL != chatRoom ){
      chatRoom->leftRoom();
    }
  }
}

/**
 * Simply see if there is a chat room.
 * roomNumber number to check with.
 */
bool BuddyListWindow::chatRoom_isThereARoom(const int roomNumber){
  QString Number = QString("%1").arg(roomNumber);
  ChatRoom *targetWindow = chatRooms[Number];
  if ( NULL == targetWindow ){
    return false;
  }
  return true;
}

/**
 * Get a Chat Room, if a chat room can not be found create one.
 * @param roomNumber the room number that message is going to.
 * @param roomName the name of the room.
 */
ChatRoom *BuddyListWindow::getAChatRoom( const int roomNumber, QString roomName ){
  QString Number = QString("%1").arg(roomNumber);
  ChatRoom *targetWindow = chatRooms[Number];
  if (targetWindow == NULL){
    if (roomName.length() == 0)
      return NULL;
    targetWindow = new ChatRoom(i_aimSettings->login_name, QString("%1").arg(roomNumber), 0);
    emit ( creatingChatRoom(targetWindow));
    chatRooms.insert(Number, targetWindow);
    chatRooms.setAutoDelete(false);
    connect(targetWindow, SIGNAL(messageOut(QString, QString)), this, SLOT(chatRoom_sendImOut(QString, QString)));
    connect(targetWindow, SIGNAL(getInfo(QString)), this, SLOT(slotGetBuddyInfo(QString)));
    connect(targetWindow, SIGNAL(im(QString)), this, SLOT(chatWindow_ChatWithBuddy(QString)));
    connect(targetWindow, SIGNAL(showInviteWidget(int)), this, SLOT(chatRoom_ShowInvite(int)));
    connect(targetWindow, SIGNAL(openURL(const QString &)),  kApp, SLOT(invokeBrowser(const QString &)));

    targetWindow->updateChatSettings();
    targetWindow->updateChatColorSettings();
    targetWindow->updateChatSoundSettings();
    targetWindow->updateChatFontSettings();

    // ROOM

    // Update Singles to Chat Window
    connect(this, SIGNAL(updateChatSettings()),
			 targetWindow, SLOT(updateChatSettings()));
    connect(this, SIGNAL(updateChatColorSettings()),
			 targetWindow, SLOT(updateChatColorSettings()));
    connect(this, SIGNAL(updateChatFontSettings()),
			 targetWindow, SLOT(updateChatFontSettings()));
    connect(this, SIGNAL(updateChatSoundSettings()),
			 targetWindow, SLOT(updateChatSoundSettings()));

    // Quit signal from Chat Window
    connect(targetWindow, SIGNAL(quiting(QString)), this, SLOT(chatRoom_RemoveWindow(QString)));
    targetWindow->show();
  }
  return targetWindow;
}

/**
 * Close a Chat Room
 * - Remove the room from the map
 * - Delete the memory
 * - Send out left room signal
 * @param room the room number to remove
 */
void BuddyListWindow::chatRoom_RemoveWindow(QString roomNumber){
  connection->chatLeave(roomNumber.toInt());
  ChatRoom *chatRoom = getAChatRoom(roomNumber.toInt());
  if (chatRoom != NULL){
    emit (distroyingChatRoom(chatRoom));
    // Clean up everything else.
    QString Number = QString("%1").arg(roomNumber);
    chatRooms.remove(Number);
    delete chatRoom;
  }
}

/**
 * Send an IM message.  If the room is not equal to 0 then you want to send
 * to a chatroom.
 * @param message the message that goes to the room.
 * @param room the room number that message is going to.
 */
void BuddyListWindow::chatRoom_sendImOut(QString message, QString roomNumber){
  TWINDOW_AIM_SANITY_CHECK;
  if ( 0 != roomNumber.toInt() ){
    //chat_sendImOut(message, roomNumber);
    //emit sendMessageRoom(roomNumber.toInt(), message);
    connection->chatSend(roomNumber.toInt(), message);
    return;
  }
}






/**
 *
 *
 * The Import/Export Functions.
 *
 *
 */

/**
 * Import buddy list from a buddy list within a kinkatta xml file.
 */
void BuddyListWindow::importXmlConfig(QString fileName){
  qApp->setOverrideCursor(Qt::waitCursor);
  QString config = setup::instance()->buddyListFileToString(fileName);
  config = QString("Config:\n") + config;
  // Got config from file, parse out lists
  TBuddyList buddyList = connection->buddyList();
  TBuddyList permitList = connection->permitList();
  TBuddyList denyList = connection->denyList();
  int permitStatus = connection->getStatus();
  tocParseConfigAlias(config, &buddyList, &permitList, &denyList, &permitStatus);
  connection->setBuddyList(buddyList);
  connection->setPermitList(permitList);
  connection->setDenyList(denyList);
  saveAimSettings();
  qApp->restoreOverrideCursor();
}

/**
 * Import buddy list from a buddy list.
 */
void BuddyListWindow::importConfig(QString fileName){
  qApp->setOverrideCursor(Qt::waitCursor);
  // Got a file, open and parse.
  QFile file(fileName);
  QString config;
  if (file.open(IO_ReadWrite)){
    config += "CONFIG:";
    QTextStream stream(&file);
    while(!stream.eof()){
      config += stream.readLine();
      config += "\n";
    }
    file.close();
  }
  else
    QMessageBox::information(this, "Kinkatta - Error","Unable to open file.", QMessageBox::Ok);
  // Got config from file, parse out lists
  TBuddyList buddyList = connection->buddyList();
  TBuddyList permitList = connection->permitList();
  TBuddyList denyList = connection->denyList();
  int permitStatus = connection->getStatus();
  tocParseConfigAlias(config, &buddyList, &permitList, &denyList, &permitStatus);

  connection->setBuddyList(buddyList);
  connection->setPermitList(permitList);
  connection->setDenyList(denyList);
  saveAimSettings();
  qApp->restoreOverrideCursor();
}

/**
 * Import buddy list from a buddy list.
 */
void BuddyListWindow::importConfigAlias(QString fileName){
  qApp->setOverrideCursor(Qt::waitCursor);
  // Got a file, open and parse.
  QFile file(fileName);
  QString config;
  if (file.open(IO_ReadWrite)){
    config += "CONFIG:";
    QTextStream stream(&file);
    while(!stream.eof()){
      config += stream.readLine();
      config += "\n";
    }
    file.close();
  }
  else
    QMessageBox::information(this, "Kinkatta - Error","Unable to open file.", QMessageBox::Ok);
  
  // Got config from file, parse out lists
  TBuddyList buddyList = connection->buddyList();
  TBuddyList permitList = connection->permitList();
  TBuddyList denyList = connection->denyList();
  int permitStatus = connection->getStatus();
  tocParseConfigAlias(config, &buddyList, &permitList, &denyList, &permitStatus);
  connection->setBuddyList(buddyList);
  connection->setPermitList(permitList);
  connection->setDenyList(denyList);
  saveAimSettings();
  qApp->restoreOverrideCursor();
}

/**
 * Import buddy list from a gaim buddy list.
 */
void BuddyListWindow::slotImportFromGaim(){
  QString buddyFile = QDir::homeDirPath();
  buddyFile += "/.gaim";
  QString s( KFileDialog::getOpenFileName(buddyFile,QString("*.blist"),this, "Gaim Buddy List (*.blist)") );
  if ( s.isEmpty() == true)
  return;
  importConfigAlias(s);
  loadList();
}

/**
 * Import buddy list from a kinkatta buddy list.
 */
void BuddyListWindow::slotImportFromKinkatta(){
  QString buddyFile =  QDir::homeDirPath();
  buddyFile += "/.kde/share/apps/kinkatta/";
  QString s( KFileDialog::getOpenFileName(buddyFile,QString("*.xml *.buddyList"),this, "Kinkatta Buddy List (*.buddyList)") );
  if ( s.isEmpty() == true)
    return;

  if (s.length() > 3 && s.mid(s.length()-3,3) == "xml")
    importXmlConfig(s);
  else
    importConfigAlias(s);
  loadList();
}

/**
 * Import buddy list from a tik buddy list.
 */
void BuddyListWindow::slotImportFromTik(){
  QString buddyFile = QDir::homeDirPath();
  buddyFile += "/.tic";
  QString s( KFileDialog::getOpenFileName(buddyFile,QString("*.config"),this, "Tik Buddy List (*.config)") );
  if ( s.isEmpty() == true)
    return;
  importConfig(s);
  loadList();
}

/**
 * Import buddy list from a windows buddy list.
 */
void BuddyListWindow::slotImportFromAim(){
  QString buddyFile = QDir::homeDirPath();
  QString s( KFileDialog::getOpenFileName(buddyFile,QString("*.*"),this, "Official Aim Buddy List (*.*)") );
  if ( s.isEmpty() == true)
  	return;

	qApp->setOverrideCursor(Qt::waitCursor);
  // Got a file, open and parse.
  QFile file(s);
  QString config;
  bool file_Buddy = false;
  bool file_list = false;
  QString group = "";
  QString unknown = "";
  QString subunknown = QString("");
  int sub = 0;
  if (file.open(IO_ReadWrite)){
    config += "CONFIG:";
    QTextStream stream(&file);
    while(!stream.eof()){
      QString line = stream.readLine();
      if ( file_Buddy == true && file_list == true && group.length() != 0 && subunknown.length() == 0){
      	line.replace(QRegExp("\t"), "");
        line.replace(QRegExp("\""), "");
        line.replace(QRegExp(" "), "");
        if (line.find("}", false) == -1 && (line.find("{", false) == -1) ){
          config += "b " + line;
          config += "\n";
        }
      } 

      // Entering a group
      if (line.find("{", false) != -1){
        if (line.find("Buddy {", false) != -1){
					file_Buddy = true;
				}
				else{
					if (line.find("list {", false) != -1){
						if (file_Buddy == true){
							file_list = true;
						}
					}
					else{
						if ( file_Buddy == true && file_list == true && group.length() == 0){
							line = line.mid(0, line.length()-2);
				  		line.replace(QRegExp("\t"), "");
							line.replace(QRegExp("\""), "");
							line.replace(QRegExp(" "), "");
							config += "g " + line;
	     	  		config += "\n";
							group = line;
						}
						else{
							if (file_Buddy == true && file_list == true ){
								if (sub == 0){
									line = line.mid(0, line.length()-2);
						  		line.replace(QRegExp("\t"), "");
									line.replace(QRegExp("\""), "");
									line.replace(QRegExp(" "), "");
				  				config += "b " + line;
	     	  				config += "\n";
									subunknown = line;
								}
								sub++;
							}
							else unknown = line;
						}
					}
				}
			}
			// Leaving a group
			if (line.find("}", false) != -1){
			  if (subunknown.length() !=0){
					if (sub == 1)
						subunknown = "";
					sub--;
				}
				else{
				if (group.length() != 0)
					group = "";
				else{
					if (file_list == true){
						file_list = false;
					}
					else {
						if (file_list == false && file_Buddy == true && unknown.length() == 0)
							file_Buddy = false;
						else
							unknown = "";
					}
				}
				}
			}
    }
    file.close();
  }
  else
    QMessageBox::information(this, "Kinkatta - Error","Unable to open file.", QMessageBox::Ok);

  if (config == "CONFIG:")
    QMessageBox::information(this, "Kinkatta - Error","Unable to import official aim client list.\nDid you use aim's export?  Do you have the latest aim?", QMessageBox::Ok);

  // Got config from file, parse out lists
  TBuddyList buddyList = connection->buddyList();
  TBuddyList permitList = connection->permitList();
  TBuddyList denyList = connection->denyList();
  int permitStatus = connection->getStatus();
  tocParseConfigAlias(config, &buddyList, &permitList, &denyList, &permitStatus);

  connection->setBuddyList(buddyList);
  connection->setPermitList(permitList);
  connection->setDenyList(denyList);
  saveAimSettings();
  qApp->restoreOverrideCursor();
  loadList();
}

/**
 * Import buddy list from a kit buddy list.
 */
void BuddyListWindow::slotImportFromKit(){
QString buddyFile = QDir::homeDirPath();
  buddyFile += "/.kde/share/config/";
  //kitprofilerc

  QString fileName( KFileDialog::getOpenFileName(buddyFile,QString("kit*"),this, "Kit profile (*)") );
  if ( fileName.isEmpty() == true)
    return;

  // Got a file, open and parse.
  QFile file(fileName);
  QString config;
  QString name;
  bool import = false;
  bool endimport = false;
  QString temp;
  if (file.open(IO_ReadWrite)){
    QTextStream stream(&file);
    while(!stream.eof() && endimport == false ){
      temp =  stream.readLine();
      if (temp.mid(0,1) == QString("[")){
        QString buddy = temp.mid(1, temp.length()-2);
        int answer = QMessageBox::information(0, "Kinkatta - Import",
          QString("Found """) + buddy +""" in profile, import" + buddy +"""?",
          "Yes", "No, see if there is another.", 0,1);
        if (!answer){
          import = true;
        }
      }
      if (temp.mid(0,14) == QString("Configuration=")){
        if ( import == true ){
          config += temp.mid(14,temp.length()-14);
          endimport = true;
        }
      }
    }
    file.close();
  }
  else
    QMessageBox::information(this, "Kinkatta - Error","Unable to open file.", QMessageBox::Ok);

  if (import == false){
    QMessageBox::information(this, "Kinkatta - Error","No more possible users to import.\nImport canceled.", QMessageBox::Ok);
    return;
  }
  qApp->setOverrideCursor(Qt::waitCursor);

  // Got config from file, parse out lists
  TBuddyList buddyList = connection->buddyList();
  TBuddyList permitList = connection->permitList();
  TBuddyList denyList = connection->denyList();
  int permitStatus = connection->getStatus();
  tocParseConfigAlias(config, &buddyList, &permitList, &denyList, &permitStatus);

  connection->setBuddyList(buddyList);
  connection->setPermitList(permitList);
  connection->setDenyList(denyList);
  saveAimSettings();
  qApp->restoreOverrideCursor();
  loadList();
}

/**
 * Export the buddylist to a file.
 */
void BuddyListWindow::slotExportBuddyList(){
  QString saveAsThisFile( KFileDialog::getSaveFileName( QString(""),QString("*.buddylist"),this, "buddyList (*.buddylist)") );

  if ( saveAsThisFile.isEmpty())
    return;
  QFileInfo fi(saveAsThisFile);
  if( fi.extension( FALSE ).isEmpty() )
    saveAsThisFile.append( ".buddylist" );

  qApp->setOverrideCursor(Qt::waitCursor);
  QFile file(saveAsThisFile);
  if (file.open(IO_ReadWrite))
  {
    QString config = setup::instance()->buddyListToString(i_aimSettings->login_name);
    QTextStream stream(&file);
    stream << config << "\n";
    file.close();
  }
  else
    QMessageBox::critical(this, "Kinkatta - Message",("Could not export buddy list."));
  qApp->restoreOverrideCursor();
}



/**
 *
 *
 * The Pounce Functions.
 *
 *
 */

/**
 * load the saved recurring pounces.
 */
void BuddyListWindow::loadRecurringPounces() {
	i_aimSettings->pounces.clear();
	i_aimSettings->pounces = setup::instance()->readPounces(i_aimSettings->login_name);

	QDict<pounce> savedPounces = i_aimSettings->pounces;
	QDictIterator<pounce> it(savedPounces);
	pounce *p;
	if (!savedPounces.isEmpty()) {
		while( it.current() != NULL ){
			p = it.current();
			if (p->buddyName.length() == 0)
				break;
			QString BuddyName = tocNormalize(p->buddyName);
			pounce *newPounceStruct = pounceMessages[ BuddyName ];
	  	if(!newPounceStruct){
				if (p->hidden == false)
          pounce_SlotAdd(*p);
				else
          setSoundConfig(*p);
			}
			it += 1;
		}
	}
}

/**
 * Open a pounce dialog for a new pounce to be added.
 */
void BuddyListWindow::pounce_SlotAddDialog(){
  NewPounceImp *pounceDialog = new NewPounceImp(this, "AddPounceDialog", "");
  connect(pounceDialog, SIGNAL(addPounce(pounce)), this, SLOT(pounce_SlotAdd(pounce)));
  TBuddyList list = connection->buddyList();
  int numberOfBuddies = list.getCount();
	for (int i = 0; i < numberOfBuddies; i++){
		pounceDialog->buddyName->insertItem(list.getName(i), -1);
	}
  pounceDialog->show();
}

/**
 * Bring up the pounce dialog with the current selected buddy name
 */
void BuddyListWindow::pounce_SlotAddDialogWithBuddy(){
  if (treeList->currentItem() == 0)
    treeList->setCurrentItem(treeList->firstChild());
  const QString name = treeList->currentName();
  if (treeList->checkIfFolder(treeList->currentItem()) == false){
    pounce_SlotAddDialogWithBuddyName(name);
  }
}

/**
 * Bring up the pounce dialog with the current selected buddy name
 */
void BuddyListWindow::pounce_SlotAddDialogWithBuddyName(QString name){
  NewPounceImp *pounceDialog = new NewPounceImp(this, "AddPounceDialog", name);
  connect(pounceDialog, SIGNAL(addPounce(pounce)), this, SLOT(pounce_SlotAdd(pounce)));

  // If there is already a Pounce you want to edit it.
  QString buddyName = tocNormalize(buddyName);
  pounce *pounceStruct = pounceMessages[ buddyName ];
  if (pounceStruct)
    pounceDialog->setPounce(pounceStruct);

  TBuddyList list = connection->buddyList();
  int numberOfBuddies = list.getCount();
  for (int i = 0; i < numberOfBuddies; i++){
    if (list.getName(i) != name)
      pounceDialog->buddyName->insertItem(list.getName(i), -1);
  }
  pounceDialog->show();
}


/**
 * Bring up the pounce dialog with the current pounce info.
 */
void BuddyListWindow::pounce_Edit(int menuId){
  QString buddyName = _PounceMenu->text(menuId);
  int cname = buddyName.find(":", false);
  if( cname != -1)
    buddyName = buddyName.left(cname);
  else
    buddyName = "";
  if (!buddyName.length() == 0){ //user didnt press Add Pounce, or Remove Pounce
    buddyName = tocNormalize(buddyName);
    pounce *pounceStruct = pounceMessages[ buddyName ];
    if(pounceStruct){
      NewPounceImp *pounceDialog = new NewPounceImp(this, "AddPounceDialog", "");
      connect(pounceDialog, SIGNAL(addPounce(pounce)), this, SLOT(pounce_SlotAdd(pounce)));
      pounceDialog->setPounce(pounceStruct);
      pounceDialog->show();
    }
    else
     QMessageBox::critical(this, "Kinkatta - Error",QString("Can't find pounce for: ") + buddyName, "Ok");
  }
}

/**
 * Add a pounce to the internal list of pounces.
 */
void BuddyListWindow::pounce_SlotAdd(pounce newPounce){
  QString BuddyName = newPounce.buddyName;
  QString realName = BuddyName;
  BuddyName = tocNormalize(BuddyName);
  pounce *newPounceStruct = pounceMessages[ BuddyName ];
  if(!newPounceStruct){
    newPounceStruct = new pounce();
    pounceMessages.insert(BuddyName, newPounceStruct);
    
    newPounceStruct->buddyName = BuddyName;
    newPounceStruct->signOn = newPounce.signOn;
    newPounceStruct->returnAway = newPounce.returnAway;
    newPounceStruct->returnIdle = newPounce.returnIdle;
    newPounceStruct->openChat = newPounce.openChat;
    newPounceStruct->sendMessage = newPounce.sendMessage;
    newPounceStruct->message = newPounce.message;
    newPounceStruct->execCommand = newPounce.execCommand;
    newPounceStruct->command = newPounce.command;
    newPounceStruct->doNotRemove = newPounce.doNotRemove;
    newPounceStruct->hidden = false;
    QString textInMenu = realName + ": ";
    if (newPounce.execCommand && newPounce.openChat){
      textInMenu = "Chat & Exec Command";
    }
    if (newPounce.execCommand){
      QString command =  newPounce.command;
      if (command.length() > 20){
        command = command.mid(0,16);
        command += "...";
      }
      if (command.length() > 0)
        textInMenu += command;
      else
        textInMenu += "Exec Command";
    }
    if (newPounce.openChat){
      QString message =  newPounce.message;
      if (message.length() > 20){
        message = message.mid(0,16);
        message += "...";
      }
      if (newPounceStruct->sendMessage && message.length() > 0)
        textInMenu += message;
      else
        textInMenu += "Open Chat Window";	
    }
    // Add pounce icon to buddy.
    TBuddyList list = connection->buddyList();
    TBuddy *bud = list.getByNum(list.getNum(realName));
    if (bud) {
      loadTreeBuddy(bud);
    }
    i_aimSettings->pounces = pounceMessages;
    setup::instance()->savePounces(i_aimSettings->login_name,i_aimSettings->pounces);
    // Do these last.
    newPounceStruct->editMenuId = _PounceMenu->insertItem(textInMenu,-1);
    newPounceStruct->deleteMenuId = _PounceDelete->insertItem(newPounceStruct->buddyName, -1);
  }
  else{
    newPounceStruct->signOn = newPounce.signOn;
    newPounceStruct->returnAway = newPounce.returnAway;
    newPounceStruct->returnIdle = newPounce.returnIdle;
    newPounceStruct->openChat = newPounce.openChat;
    newPounceStruct->sendMessage = newPounce.sendMessage;
    newPounceStruct->message = newPounce.message;
    newPounceStruct->execCommand = newPounce.execCommand;
    newPounceStruct->command = newPounce.command;
    newPounceStruct->doNotRemove = newPounce.doNotRemove;
  }
}

/**
 * If the Pounce delete menu is empty, this inserts a disabled item "(Empty)"
 */
void BuddyListWindow::pounce_DeleteMenuAboutToShow(){
	// first update menu to remove disabled items
	pounce_UpdateMenu();
	if(_PounceDelete->count() < 1  && empty1 == -1){
		empty1 = _PounceDelete->insertItem("(Empty)", -1);
		_PounceDelete->setItemEnabled(empty1, false);
		empty2 = _PounceMenu->insertItem("(Empty)", -1);
		_PounceMenu->setItemEnabled(empty2, false);
	} 
	else {
		if (empty1 != -1)	{
		  if (_PounceDelete->count() != 1){
				_PounceDelete->removeItem(empty1);
		    _PounceMenu->removeItem(empty2);
				empty1 = -1;
			}
	  }
	}
}

/**
 * Check to see if the buddy buddyName has a pounce for signOn and if so
 * pounce that buddy.
 */
void BuddyListWindow::pounce_CheckSignOn(QString buddyName){
  buddyName = tocNormalize(buddyName);
  pounce *pounceStruct = pounceMessages[ buddyName ];
  if(pounceStruct){
    if (pounceStruct->signOn == true){
      pounce_Activate(buddyName);
    }
  }
}

/**
 * Check to see if the buddy buddyName has a pounce for returnAway and if so
 * pounce that buddy.
 */
void BuddyListWindow::pounce_CheckReturnAway(QString buddyName){
  buddyName = tocNormalize(buddyName);
  pounce *pounceStruct = pounceMessages[ buddyName ];
  if(pounceStruct){
    if (pounceStruct->returnAway == true){
      pounce_Activate(buddyName); 
    }
  }
}

/**
 * Check to see if the buddy buddyName has a pounce for returnIdle and if so
 * pounce that buddy.
 */
void BuddyListWindow::pounce_CheckReturnIdle(QString buddyName){
  buddyName = tocNormalize(buddyName);
  pounce *pounceStruct = pounceMessages[ buddyName ];
  if(pounceStruct){
    if (pounceStruct->returnIdle == true){
      pounce_Activate(buddyName);
    }  
  }
}

/**
 * When this function is called it will attempt to do whatever the pounce
 * for buddy buddyName wants.
 */
void BuddyListWindow::pounce_Activate(QString buddyName){
	pounce *pounceStruct = pounceMessages[ buddyName ];
  if(pounceStruct){
    if (pounceStruct->openChat == true){
      chatWindow_ChatWithBuddy(buddyName);
    }
    if (pounceStruct->openChat == false && pounceStruct->sendMessage == true){
      emit sendMessageChat(pounceStruct->message,buddyName, false, false);
    }
    if (pounceStruct->openChat == true && pounceStruct->sendMessage == true){
      ChatWindow *targetWindow = messageWindows[(i_aimSettings->login_name) + tocNormalize(buddyName) ];
      if(targetWindow){
        sendingPounce = true;
				targetWindow->sendOutAMessage(pounceStruct->message);
				sendingPounce = false;
      }
    }
    if (pounceStruct->execCommand == true){
      system(QString(pounceStruct->command + " &").latin1());
    }
    // Find the menu id number and then remove the menu item.
    if (pounceStruct->doNotRemove == false){
      pounce_SlotRemove(pounceStruct->deleteMenuId);
    }
  }
}

/**
 *  If you remove a pounce from the delete list it is removed here.
 */
void BuddyListWindow::pounce_SlotRemove(int deleteMenuNumber){
  QString realName = _PounceDelete->text(deleteMenuNumber);
  QString buddyName = tocNormalize(realName);
  pounce *pounceStruct = pounceMessages[ buddyName ];
  if (pounceStruct != NULL){
    // only disable not remove object of signal processing routine...can segfault
    _PounceDelete->setItemEnabled(pounceStruct->deleteMenuId, FALSE);
    _PounceMenu->setItemEnabled(pounceStruct->editMenuId, FALSE);
    pounceMessages.remove(buddyName);
    //delete pounceStruct; //dont need this, auto-deletion enabled
  }
  TBuddyList list = connection->buddyList();
  TBuddy *bud = list.getByNum(list.getNum(realName));
  if (bud) {
    loadTreeBuddy(bud);
  }
  i_aimSettings->pounces = pounceMessages;
  setup::instance()->savePounces(i_aimSettings->login_name,i_aimSettings->pounces);
}

/**
 * Save the pounces under the currently logged in name.
 */
void BuddyListWindow::savePounce(){
  setup::instance()->savePounces(setup::settings()->login_name, setup::settings()->pounces);
}

/**
 * Update pounce Menu just before it displays.  It removes any items in the
 * pounce menu that are disabled other then the "Empty" items.
 */
void BuddyListWindow::pounce_UpdateMenu(){
	int itP = _PounceMenu->count();
	int itD = _PounceDelete->count();
	int id = 0;
	// remove disabled items...
	while (itP > 3) {
		id = _PounceMenu->idAt(itP-1);
		if (!_PounceMenu->isItemEnabled(id)) {
			if (_PounceMenu->text(id) != "(Empty)") {
					_PounceMenu->removeItem(id);
			}
		}
		itP--;
	}
	// remove disabled items...
	while (itD > 0) {
		id = _PounceDelete->idAt(itD-1);
		if (!_PounceDelete->isItemEnabled(id)) {
			if (_PounceDelete->text(id) != "(Empty)") {
				_PounceDelete->removeItem(id);
			}
		}
		itD--;
	}
}




/*
  DOCK STUFF
 */

/**
 * Show's the (hidden) widget, after restoring its position
 * If we offline don't show.
 */
void BuddyListWindow::showKinkatta(){
  if(connection->getStatus() == TAIM_OFFLINE){
    kApp->loginWindow->show();
    return;
  }

  setGeometry(globalPosition.x(), globalPosition.y(), width(), height());
  show();
}

/**
 * Saves the global position of this widget, then hides the widget.
 */
void BuddyListWindow::hideKinkatta(){
  if(connection->getStatus() == TAIM_OFFLINE){
    kApp->loginWindow->hide();
    return;
  }
  
  QRect globalGeometry = KWin::info( winId() ).frameGeometry;
  globalPosition.setX( globalGeometry.x() );
  globalPosition.setY( globalGeometry.y() );
  hide();
}

// BuddyListWindow

#include "buddylistwindow.moc"

