/***************************************************************************
                                  main.cpp
                             -------------------
    begin                : Sun Feb 13 01:05:24 EST 2000
    copyright            : (C) 2000 by Benjamin Meyer
    email                : benjamin@csh.rit.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "buddylistwindow.h"
#include "application.h" 
#include <string.h>
#include <kcmdlineargs.h>

#include <kaboutdata.h>
#include <klocale.h>
#include <stdlib.h>
#include <stdio.h>

int main(int argc, char *argv[]){
  bool baseFont = false;
  int baseFontParam = 0;
  bool baseFontSize = false;
  int baseFontSizeParam = 0;
  if (argc >= 0){
    if (strcmp(argv[1],"-help")==0 || strcmp(argv[1],"--help")==0 || strcmp(argv[1],"-h")==0 || strcmp(argv[1],"-?")==0){
    printf("Usage: kinkatta [OPTION...]\n"
"\n"
"Help options\n"
"  -?, -h -help, --help            Show this help message.\n"
"\n"
"Kinkatta Options\n"
"  --base-font [fontname]      Select the font that Kinkatta will use by default\n"
"                              for the entire application.\n"
"  --base-font-size [size]     Select the font size that Kinkatta will use by default\n"
"                              for the entire application (default=12).\n"
"\n"
"QT Options\n"
"  -style=[style]              Sets the application GUI style/theme. Possible\n"
"                              values are motif, windows, and platinum.\n"
"  -session=[session]          Restores the application from an earlier session.\n"
"\n"
"QT X11 Options\n"
"  -display [display]          Sets the X display (default is $DISPLAY).\n"
);
      exit(1);
    }

    int i=1;
    while ( i < argc ) {
      if ( strcmp( argv[i],"--base-font" ) == 0 ) {
	      if ((i + 1 ) < argc) {
	        baseFont = true;
        	baseFontParam = i + 1;
	      }
      }

      if ( strcmp( argv[i],"--base-font-size" ) == 0 ) {
	      if ((i + 1 ) < argc) {
	        baseFontSize = true;
        	baseFontSizeParam = i + 1;
	      }
      }

      i++;
    }
  }


  // about data
  KAboutData aboutData("kinkatta", I18N_NOOP("Kinkatta"), release_number,
    I18N_NOOP("AOL Instant Messenger Client"), KAboutData::License_LGPL, "(c) 2000-2001, Benjamin Meyer",
    0, "http://kinkatta.sourceforge.net");
    aboutData.addAuthor("Benjamin Meyer", I18N_NOOP("Original author"), "ben@meyerhome.net");
    aboutData.addAuthor("Dimi Shahbaz", I18N_NOOP("Developer"), "dshahbaz@ucla.edu");
    aboutData.addAuthor("Jim Wilson", I18N_NOOP("Developer"), "jimw@kelcomaine.com");
    aboutData.addAuthor("Adam Keys", I18N_NOOP("Developer"), "adam.keys@engr.smu.edu");
    aboutData.addAuthor("Neil Stevens", I18N_NOOP("Contributions"), "multivac@fcmail.com");
    aboutData.addAuthor("David Johnson", I18N_NOOP("Contributions"), "david@usermode.org");
    aboutData.addAuthor("Bob Herrmann", I18N_NOOP("Contributions"), "bob@jadn.com");
  

  // command line
  KCmdLineArgs::init(argc, argv, &aboutData);

  KinkattaApplication a(argc, argv);
  if (baseFont) {
	if (baseFontSize) {
	  KApplication::setFont( QFont(argv[baseFontParam], atoi(argv[baseFontSizeParam])) );
	} else {
  	KApplication::setFont( QFont(argv[baseFontParam], atoi("12")) );
    }
  }
  BuddyListWindow *kinkatta = new BuddyListWindow(0, "BuddyListWindow");
  a.setMainWidget(kinkatta);
  return a.exec();
}

// main.cpp

