/***************************************************************************
                             controlimp.h
                             -------------------
    begin                : Saturday March 24 2001
    copyright            : (C) 2001 Benjamin Meyer 
    email                : ben-dev@meyerhome.net
 ***************************************************************************/

#ifndef CONTROLIMP_H
#define CONTROLIMP_H

#include <control.h>

class KPopupMenu;
class QString;

/**
 * A list of buddies with the ability to ignore, private im, info etc.
 * Used in the chatroom
 * @author Benjamin Meyer
 */

class ChatRoomControlImp : public ChatRoomControl {

Q_OBJECT
	
signals:
  /// Get info on 'contactName'
  void getInfo( QString contactName );

  /// Im 'contactName'
  void im( QString contactName );

public:
  /// Constructor
  ChatRoomControlImp( QWidget *parent=0, const char *name=0 );

  /// returns if this person should be ignored or not.
  bool ignore( QString contactName = "" );

  /// The Person who opened this windows (i.e. can't ignore him/her)
  QString owner;

public slots:
  /// Update the status of this contact
  void updateContact( QString contactName, bool newStatus );

private slots:
  /// Get the info on the currently selected contact.
  void infoClicked();

  /// Ignore/Un-ignore the currently selected contact.
  void ignoreClicked();

  /// Im the currently selected contact.
  void imClicked();

  /// Im the currently selected contact.
  void doubleClick( QListBoxItem* );

  /// Pull up the menu.
  void rightClick( QListBoxItem *, const QPoint &pos );

private:
  /// Menu used for when the user right clicks on a buddy.
  KPopupMenu *_Menu;

};

#endif

// chatroominviteimp.h

