/******************************************************************************
                               chatplugin.h
                           -------------------
    begin                : Fri Dec 7 2000
    copyright            : (C) 2000 by Benjamin Meyer
    email                : ben-dev@meyerhome.net
 ******************************************************************************/

#ifndef CHATPLUGIN_H
#define CHATPLUGIN_H

class QString;

/**
 * For a plugin writer to be able to manipulate the chat window before the
 * text is rendered to the log and sent out they must inherit this class and
 * implement the enhanceText function.  In there info struct they must also
 * set the flag that states that they are a ChatPlugin class.  Order or 
 * processing in the chat window is not guaranteed like text output is.  You are
 * guaranteed that this happens before the output.
 * @author Benjamin Meyer 
 */
class ChatPlugin {

public:
  // Constructor
  ChatPlugin();

  /**
   * When adding features to enhance the text (such as auto linking) this is
   * is the function that you need to implement.  Try not to spend too much
   * time going through this function for you are delaying the time that the
   * text is to the screen. 
   * @param text the text to look at and change.
   */
  virtual void enhanceText( QString &text ) = 0;

};

#endif

// chatplugin.h

